/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.service;

import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component
public class TarmedCodeElementService
implements ICodeElementServiceContribution {
    public String getSystem() {
        return "Tarmed";
    }

    public Optional<ICodeElement> createFromCode(String code, HashMap<Object, Object> context) {
        return Optional.ofNullable(TarmedLeistung.getFromCode(code, this.getDate(context), this.getLaw(context)));
    }

    private TimeTool getDate(HashMap<Object, Object> context) {
        Object date = context.get(ICodeElementService.ContextKeys.DATE);
        if (date instanceof TimeTool) {
            return (TimeTool)date;
        }
        Konsultation kons = (Konsultation)context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (kons != null) {
            return new TimeTool(kons.getDatum());
        }
        return new TimeTool();
    }

    private String getLaw(HashMap<Object, Object> context) {
        Object law = context.get(ICodeElementService.ContextKeys.LAW);
        if (law instanceof String) {
            return (String)law;
        }
        Object coverage = context.get(ICodeElementService.ContextKeys.COVERAGE);
        if (coverage instanceof Fall) {
            return ((Fall)coverage).getConfiguredBillingSystemLaw().name();
        }
        Object consultation = context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (consultation instanceof Konsultation && ((Konsultation)consultation).getFall() != null) {
            return ((Konsultation)consultation).getFall().getConfiguredBillingSystemLaw().name();
        }
        return null;
    }
}

