/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Person;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.Verrechnet;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Verifier;

public class XMLExporterUtil {
    private static final String ELEMENT_EMAIL = "email";
    private static final String ELEMENT_ONLINE = "online";

    public static Element buildRechnungsstellerAdressElement(Kontakt k) {
        return XMLExporterUtil.buildAdressElement(k, false, true);
    }

    public static Element buildAdressElement(Kontakt k) {
        return XMLExporterUtil.buildAdressElement(k, false, false);
    }

    public static Element buildAdressElement(Kontakt k, boolean useAnschrift) {
        return XMLExporterUtil.buildAdressElement(k, useAnschrift, false);
    }

    public static Element buildAdressElement(Kontakt k, boolean useAnschrift, boolean checkAnrede) {
        Element ret;
        boolean anredeOrganization = false;
        if (checkAnrede) {
            String anrede = (String)k.getInfoElement("Anrede");
            boolean bl = anredeOrganization = anrede == null || anrede.isEmpty();
        }
        if (!k.istPerson() || anredeOrganization) {
            Element onlineElement;
            ret = new Element("company", XMLExporter.nsinvoice);
            Element companyname = new Element("companyname", XMLExporter.nsinvoice);
            companyname.setText(StringTool.limitLength((String)k.get("Bezeichnung1"), (int)35));
            ret.addContent((Content)companyname);
            ret.addContent((Content)XMLExporterUtil.buildPostalElement(k));
            Element telcom = XMLExporterUtil.buildTelekomElement(k);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                ret.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(k)) != null) {
                ret.addContent((Content)onlineElement);
            }
        } else {
            Element onlineElement;
            ret = new Element("person", XMLExporter.nsinvoice);
            Element familyname = new Element("familyname", XMLExporter.nsinvoice);
            Element givenname = new Element("givenname", XMLExporter.nsinvoice);
            String anschrift = k.get("Anschrift");
            if (!useAnschrift || StringTool.isNothing((Object)anschrift) || anschrift.equals(k.createStdAnschrift())) {
                XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", k.getInfoString("Anrede"), 35);
                XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "title", k.get("Titel"), 35);
                if (StringUtils.isEmpty((String)k.getInfoString("Anrede"))) {
                    XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", XMLExporterUtil.getSalutation(k), 35);
                }
                familyname.setText(StringTool.limitLength((String)k.get("Bezeichnung1"), (int)35));
                String gn = k.get(StringTool.limitLength((String)"Bezeichnung2", (int)35));
                if (StringTool.isNothing((Object)gn)) {
                    gn = "Unbekannt";
                }
                givenname.setText(gn);
                ret.addContent((Content)familyname);
                ret.addContent((Content)givenname);
                ret.addContent((Content)XMLExporterUtil.buildPostalElement(k));
            } else {
                Postanschrift postAnschrift = new Postanschrift(k);
                familyname.setText(StringTool.limitLength((String)postAnschrift.name, (int)35));
                givenname.setText(StringTool.limitLength((String)postAnschrift.vorname, (int)35));
                XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", postAnschrift.anrede, 35);
                ret.addContent((Content)familyname);
                ret.addContent((Content)givenname);
                ret.addContent((Content)XMLExporterUtil.buildPostalElement(postAnschrift));
            }
            Element telcom = XMLExporterUtil.buildTelekomElement(k);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                ret.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(k)) != null) {
                ret.addContent((Content)onlineElement);
            }
        }
        return ret;
    }

    private static String getSalutation(Kontakt k) {
        if (k.istPerson()) {
            Person p = Person.load((String)k.getId());
            if (p.getGeschlecht().equals("m")) {
                return ch.elexis.data.Messages.Contact_SalutationM;
            }
            return ch.elexis.data.Messages.Contact_SalutationF;
        }
        return "";
    }

    public static Element buildPostalElement(Kontakt k) {
        Element ret = new Element("postal", XMLExporter.nsinvoice);
        XMLExporterUtil.addElementIfExists(ret, "pobox", null, StringTool.limitLength((String)k.getInfoString("Postfach"), (int)35), null);
        XMLExporterUtil.addElementIfExists(ret, "street", null, StringTool.limitLength((String)k.get("Strasse"), (int)35), null);
        Element zip = XMLExporterUtil.addElementIfExists(ret, "zip", null, StringTool.limitLength((String)k.get("Plz"), (int)9), "0000");
        XMLExporterUtil.setAttributeIfNotEmpty(zip, "countrycode", StringTool.limitLength((String)k.get("Land"), (int)3));
        XMLExporterUtil.addElementIfExists(ret, "city", null, StringTool.limitLength((String)k.get("Ort"), (int)35), Messages.XMLExporter_Unknown);
        return ret;
    }

    public static Element buildPostalElement(Postanschrift postanschrift) {
        Element ret = new Element("postal", XMLExporter.nsinvoice);
        XMLExporterUtil.addElementIfExists(ret, "pobox", null, StringTool.limitLength((String)postanschrift.adresse2, (int)35), null);
        XMLExporterUtil.addElementIfExists(ret, "street", null, StringTool.limitLength((String)postanschrift.adresse1, (int)35), null);
        Element zip = XMLExporterUtil.addElementIfExists(ret, "zip", null, StringTool.limitLength((String)postanschrift.plz, (int)9), "0000");
        XMLExporterUtil.setAttributeIfNotEmpty(zip, "countrycode", StringTool.limitLength((String)postanschrift.land, (int)3));
        XMLExporterUtil.addElementIfExists(ret, "city", null, StringTool.limitLength((String)postanschrift.ort, (int)35), Messages.XMLExporter_unknown);
        return ret;
    }

    public static Element buildOnlineElement(Kontakt k) {
        Element ret = null;
        String value = XMLExporterUtil.getValidXMLString(StringTool.limitLength((String)k.get("E-Mail"), (int)70));
        if (!value.equals("")) {
            if (!value.matches(".+@.+")) {
                value = "mail@invalid.invalid";
            }
            if (ret == null) {
                ret = new Element(ELEMENT_ONLINE, XMLExporter.nsinvoice);
            }
            XMLExporterUtil.addElementIfExists(ret, ELEMENT_EMAIL, null, value, null);
        }
        if (!(value = XMLExporterUtil.getValidXMLString(StringTool.limitLength((String)k.get("Website"), (int)100))).equals("")) {
            if (ret == null) {
                ret = new Element(ELEMENT_ONLINE, XMLExporter.nsinvoice);
                XMLExporterUtil.addElementIfExists(ret, ELEMENT_EMAIL, null, "mail@invalid.invalid", null);
            }
            XMLExporterUtil.addElementIfExists(ret, "url", null, value, null);
        }
        return ret;
    }

    public static Element buildTelekomElement(Kontakt k) {
        Element ret = new Element("telecom", XMLExporter.nsinvoice);
        Element phoneElement = XMLExporterUtil.addElementIfExists(ret, "phone", null, StringTool.limitLength((String)k.get("Telefon1"), (int)25), null);
        if (phoneElement != null) {
            XMLExporterUtil.addElementIfExists(ret, "fax", null, StringTool.limitLength((String)k.get("Fax"), (int)25), null);
        }
        return ret;
    }

    public static boolean setAttributeIfNotEmpty(Element element, String name, String value) {
        if (element == null) {
            return false;
        }
        if (StringTool.isNothing((Object)name)) {
            return false;
        }
        if (StringTool.isNothing((Object)value)) {
            return false;
        }
        element.setAttribute(name, value);
        return true;
    }

    public static boolean setAttributeIfNotEmptyWithLimit(Element element, String name, String value, int len) {
        if (value.length() >= len) {
            value = value.substring(0, len - 1);
        }
        return XMLExporterUtil.setAttributeIfNotEmpty(element, name, value);
    }

    public static String makeTarmedDatum(String datum) {
        return String.valueOf(new TimeTool(datum).toString(6)) + "T00:00:00";
    }

    public static TimeTool getFirstKonsDate(Rechnung rechnung) {
        TimeTool ret = new TimeTool("20380118");
        List konsultationen = rechnung.getKonsultationen();
        for (Konsultation konsultation : konsultationen) {
            TimeTool tt = new TimeTool(konsultation.getDatum());
            if (!tt.isBefore(ret)) continue;
            ret.set(tt);
        }
        return ret;
    }

    public static TimeTool getLastKonsDate(Rechnung rechnung) {
        TimeTool ret = new TimeTool("19700101");
        List konsultationen = rechnung.getKonsultationen();
        for (Konsultation konsultation : konsultationen) {
            TimeTool tt = new TimeTool(konsultation.getDatum());
            if (!tt.isAfter(ret)) continue;
            ret.set(tt);
        }
        return ret;
    }

    private static Element addElementIfExists(Element parent, String name, String attr, String val, String defValue) {
        if (StringTool.isNothing((Object)val)) {
            val = defValue;
        }
        if (!StringTool.isNothing((Object)val)) {
            Element ret = new Element(name, XMLExporter.nsinvoice);
            if (attr == null) {
                ret.setText(val.replaceAll("\u001f", ""));
            } else {
                ret.setAttribute(attr, val);
            }
            parent.addContent((Content)ret);
            return ret;
        }
        return null;
    }

    public static void setAttributeWithDefault(Element element, String name, String value, String def) {
        if (element != null && !StringTool.isNothing((Object)name)) {
            if (StringTool.isNothing((Object)value)) {
                value = def;
            }
            element.setAttribute(name, value);
        }
    }

    public static void setVatAttribute(Verrechnet verrechnet, Money amount, Element el, XMLExporter.VatRateSum vatsum) {
        double value = 0.0;
        String vatScale = verrechnet.getDetail("vat_scale");
        if (vatScale != null && vatScale.length() > 0) {
            value = Double.parseDouble(vatScale);
        }
        el.setAttribute("vat_rate", Double.toString(value));
        vatsum.add(value, amount.doubleValue());
    }

    public static String getResponsibleEAN(Konsultation kons) {
        Rechnungssteller rechnungssteller;
        String anrede;
        Object responsibleKontakt = null;
        String responsibleId = (String)kons.getMandant().getInfoElement("ch.elexis.tarmedprefs.responsible");
        responsibleKontakt = responsibleId != null && !responsibleId.isEmpty() ? Mandant.load((String)responsibleId) : ((anrede = (rechnungssteller = kons.getMandant().getRechnungssteller()).getInfoString("Anrede")) != null && !anrede.isEmpty() ? rechnungssteller : kons.getMandant());
        return TarmedRequirements.getEAN((Kontakt)responsibleKontakt);
    }

    public static void negate(Element el, String attr) {
        String v = el.getAttributeValue(attr);
        if (!StringTool.isNothing((Object)v) && !v.equals("0.00")) {
            v = v.startsWith("-") ? v.substring(1) : "-" + v;
            el.setAttribute(attr, v);
        }
    }

    public static String getValidXMLString(String source) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        int len = source.length();
        while (i < len) {
            if (Verifier.isXMLCharacter((int)source.charAt(i))) {
                ret.append(source.charAt(i));
            }
            ++i;
        }
        return ret.toString();
    }

    private static class Postanschrift {
        private String anrede = "";
        private String name = "";
        private String vorname = "";
        private String adresse1 = "";
        private String adresse2 = "";
        private String plz = "";
        private String ort = "";
        private String land = "";

        public Postanschrift(Kontakt k) {
            this.init(k);
        }

        private void init(Kontakt k) {
            int index;
            String postAnschrift = k.getPostAnschrift(true);
            StringTokenizer tokenizer = new StringTokenizer(postAnschrift, "\n");
            Vector<String> zeileList = new Vector<String>();
            while (tokenizer.hasMoreElements()) {
                zeileList.add(tokenizer.nextToken());
            }
            String plzOrt = "";
            String nameVorname = "";
            int len = zeileList.size();
            switch (len) {
                case 0: {
                    throw new IllegalArgumentException(Messages.XMLExporter_NoPostal);
                }
                case 1: {
                    nameVorname = (String)zeileList.get(0);
                    break;
                }
                case 2: {
                    nameVorname = (String)zeileList.get(0);
                    plzOrt = (String)zeileList.get(1);
                    break;
                }
                case 3: {
                    if (((String)zeileList.get(0)).indexOf(" ") < 0) {
                        this.anrede = (String)zeileList.get(0);
                        nameVorname = (String)zeileList.get(1);
                        plzOrt = (String)zeileList.get(2);
                        break;
                    }
                    nameVorname = (String)zeileList.get(0);
                    this.adresse1 = (String)zeileList.get(1);
                    plzOrt = (String)zeileList.get(2);
                    break;
                }
                case 4: {
                    if (((String)zeileList.get(0)).indexOf(" ") < 0) {
                        this.anrede = (String)zeileList.get(0);
                        nameVorname = (String)zeileList.get(1);
                        this.adresse1 = (String)zeileList.get(2);
                        plzOrt = (String)zeileList.get(3);
                        break;
                    }
                    nameVorname = (String)zeileList.get(0);
                    this.adresse1 = (String)zeileList.get(1);
                    this.adresse2 = (String)zeileList.get(2);
                    plzOrt = (String)zeileList.get(3);
                    break;
                }
                default: {
                    if (len <= 4) break;
                    this.anrede = (String)zeileList.get(0);
                    nameVorname = (String)zeileList.get(1);
                    this.adresse1 = (String)zeileList.get(2);
                    this.adresse2 = (String)zeileList.get(3);
                    plzOrt = (String)zeileList.get(4);
                }
            }
            if (!StringTool.isNothing((Object)nameVorname)) {
                index = (nameVorname = nameVorname.trim()).lastIndexOf(" ");
                if (index > 0) {
                    this.name = nameVorname.substring(0, index);
                    this.vorname = nameVorname.substring(index + 1);
                } else {
                    this.name = nameVorname;
                }
            }
            this.land = k.get("Land");
            if (plzOrt.length() > 3 && plzOrt.substring(0, 3).indexOf("-") > 0) {
                index = plzOrt.indexOf("-");
                this.land = plzOrt.substring(0, index);
                plzOrt = plzOrt.substring(index + 1);
            }
            this.plz = k.get("Plz");
            if (plzOrt.indexOf(" ") > 0) {
                index = plzOrt.indexOf(" ");
                this.plz = plzOrt.substring(0, index);
                plzOrt = plzOrt.substring(index + 1);
            }
            this.ort = plzOrt;
        }
    }
}

