/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Rechnung;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class XMLExporterTreatment {
    private static final String BY_CONTRACT = "by_contract";
    private static final String ICPC = "ICPC";
    private static final String ATTR_TYPE = "type";
    private Element insuranceElement;
    private List<IDiagnose> diagnoses;

    private XMLExporterTreatment(Element insuranceElement) {
        this.insuranceElement = insuranceElement;
    }

    public Element getElement() {
        return this.insuranceElement;
    }

    public static XMLExporterTreatment buildTreatment(Rechnung rechnung, XMLExporter xmlExporter) {
        Fall actFall = rechnung.getFall();
        Mandant actMandant = rechnung.getMandant();
        Element element = new Element("treatment", XMLExporter.nsinvoice);
        element.setAttribute("date_begin", XMLExporterUtil.makeTarmedDatum(XMLExporterUtil.getFirstKonsDate(rechnung).toString(4)));
        element.setAttribute("date_end", XMLExporterUtil.makeTarmedDatum(XMLExporterUtil.getLastKonsDate(rechnung).toString(4)));
        element.setAttribute("canton", actMandant.getInfoString(XMLExporter.ta.KANTON));
        element.setAttribute("reason", XMLExporterTreatment.match_type(actFall.getGrund()));
        List<IDiagnose> diagnosen = XMLExporterTreatment.getDiagnosen(rechnung);
        for (IDiagnose diagnose : diagnosen) {
            Element diagnosis = new Element("diagnosis", XMLExporter.nsinvoice);
            String diagnosisType = XMLExporterTreatment.match_diag(diagnose.getCodeSystemName());
            diagnosis.setAttribute(ATTR_TYPE, diagnosisType);
            String code = diagnose.getCode();
            if (diagnosisType.equalsIgnoreCase("freetext")) {
                diagnosis.setText(diagnose.getText());
            } else {
                if (code.length() > 12) {
                    code = code.substring(0, 12);
                }
                diagnosis.setAttribute("code", code);
            }
            element.addContent((Content)diagnosis);
        }
        XMLExporterTreatment ret = new XMLExporterTreatment(element);
        ret.diagnoses = diagnosen;
        return ret;
    }

    private static List<IDiagnose> getDiagnosen(Rechnung rechnung) {
        ArrayList<IDiagnose> ret = new ArrayList<IDiagnose>();
        List lb = rechnung.getKonsultationen();
        for (Konsultation b : lb) {
            ArrayList ld = b.getDiagnosen();
            for (IDiagnose dg : ld) {
                String dgc = dg.getCode();
                if (dgc == null) continue;
                ret.add(dg);
            }
        }
        return ret;
    }

    private static String match_type(String type) {
        if (type == null) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_DISEASE)) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_ACCIDENT)) {
            return "accident";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_MATERNITY)) {
            return "maternity";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_PREVENTION)) {
            return "prevention";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_BIRTHDEFECT)) {
            return "birthdefect";
        }
        return "disease";
    }

    private static String match_diag(String name) {
        if (name != null) {
            if (name.equalsIgnoreCase("freetext")) {
                return "freetext";
            }
            if (name.equalsIgnoreCase("ICD-10")) {
                return "ICD";
            }
            if (name.equalsIgnoreCase("by contract")) {
                return BY_CONTRACT;
            }
            if (name.equalsIgnoreCase(ICPC)) {
                return ICPC;
            }
            if (name.equalsIgnoreCase("birthdefect")) {
                return "birthdefect";
            }
        }
        return BY_CONTRACT;
    }

    public List<IDiagnose> getDiagnoses() {
        if (this.diagnoses == null) {
            return Collections.emptyList();
        }
        return this.diagnoses;
    }
}

