/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import org.jdom.Content;
import org.jdom.Element;

public class XMLExporterTiers {
    private Element tiersElement;
    private String tiers;

    private XMLExporterTiers(Element tiers) {
        this.tiersElement = tiers;
    }

    public Element getElement() {
        return this.tiersElement;
    }

    public String getTiers() {
        return this.tiers;
    }

    public static XMLExporterTiers buildTiers(Rechnung rechnung, XMLExporter xmlExporter) {
        Kontakt kostentraeger;
        TarmedACL ta = TarmedACL.getInstance();
        Fall fall = rechnung.getFall();
        Patient patient = fall.getPatient();
        Mandant mandant = rechnung.getMandant();
        String tiers = "TP";
        Fall.Tiers tiersType = fall.getTiersType();
        if (Fall.Tiers.GARANT == tiersType) {
            tiers = "TG";
        }
        if ((kostentraeger = fall.getCostBearer()) == null) {
            kostentraeger = patient;
        }
        String kEAN = TarmedRequirements.getEAN(kostentraeger);
        Element element = null;
        if (tiers.equals("TG")) {
            element = new Element("tiers_garant", XMLExporter.nsinvoice);
            String paymentPeriode = mandant.getRechnungssteller().getInfoString("rnfrist");
            if (StringTool.isNothing((Object)paymentPeriode)) {
                paymentPeriode = "30";
            }
            element.setAttribute("payment_period", "P" + paymentPeriode + "D");
        } else {
            element = new Element("tiers_payant", XMLExporter.nsinvoice);
        }
        XMLExporterTiers ret = new XMLExporterTiers(element);
        Element biller = new Element("biller", XMLExporter.nsinvoice);
        biller.setAttribute("ean_party", TarmedRequirements.getEAN((Kontakt)mandant.getRechnungssteller()));
        XMLExporterUtil.setAttributeIfNotEmpty(biller, "zsr", TarmedRequirements.getKSK((Kontakt)mandant.getRechnungssteller()));
        String spec = mandant.getRechnungssteller().getInfoString(ta.SPEC);
        if (!spec.equals("")) {
            biller.setAttribute("specialty", spec);
        }
        biller.addContent((Content)XMLExporterUtil.buildRechnungsstellerAdressElement((Kontakt)mandant.getRechnungssteller()));
        ret.tiersElement.addContent((Content)biller);
        Element provider = new Element("provider", XMLExporter.nsinvoice);
        provider.setAttribute("ean_party", TarmedRequirements.getEAN((Kontakt)mandant));
        provider.setAttribute("zsr", TarmedRequirements.getKSK((Kontakt)mandant));
        spec = mandant.getInfoString(ta.SPEC);
        if (!spec.equals("")) {
            provider.setAttribute("specialty", spec);
        }
        provider.addContent((Content)XMLExporterUtil.buildRechnungsstellerAdressElement((Kontakt)mandant));
        ret.tiersElement.addContent((Content)provider);
        Element onlineElement = null;
        Element insurance = new Element("insurance", XMLExporter.nsinvoice);
        if (tiers.equals("TG")) {
            if (kostentraeger.istOrganisation() && kEAN.matches("[0-9]{13,13}")) {
                insurance.setAttribute("ean_party", kEAN);
                insurance.addContent((Content)XMLExporterUtil.buildAdressElement(kostentraeger));
                ret.tiersElement.addContent((Content)insurance);
            }
        } else {
            insurance.setAttribute("ean_party", kEAN);
            Element company = new Element("company", XMLExporter.nsinvoice);
            Element companyname = new Element("companyname", XMLExporter.nsinvoice);
            companyname.setText(StringTool.limitLength((String)kostentraeger.get("Bezeichnung1"), (int)35));
            company.addContent((Content)companyname);
            company.addContent((Content)XMLExporterUtil.buildPostalElement(kostentraeger));
            Element telcom = XMLExporterUtil.buildTelekomElement(kostentraeger);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                company.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(kostentraeger)) != null) {
                company.addContent((Content)onlineElement);
            }
            insurance.addContent((Content)company);
            ret.tiersElement.addContent((Content)insurance);
        }
        Element patientElement = xmlExporter.buildPatient(patient);
        ret.tiersElement.addContent((Content)patientElement);
        Element guarantor = xmlExporter.buildGuarantor(XMLExporterTiers.getGuarantor(tiers, patient, fall), (Kontakt)patient);
        ret.tiersElement.addContent((Content)guarantor);
        Element referrer = new Element("referrer", XMLExporter.nsinvoice);
        Kontakt auftraggeber = fall.getRequiredContact("Zuweiser");
        if (auftraggeber != null) {
            String zsr;
            String ean = TarmedRequirements.getEAN(auftraggeber);
            if (ean != null && !ean.isEmpty()) {
                referrer.setAttribute("ean_party", TarmedRequirements.getEAN(auftraggeber));
            }
            if ((zsr = TarmedRequirements.getKSK(auftraggeber)) != null && !zsr.isEmpty()) {
                referrer.setAttribute("zsr", zsr);
            }
            referrer.addContent((Content)XMLExporterUtil.buildAdressElement(auftraggeber));
            ret.tiersElement.addContent((Content)referrer);
        }
        ret.tiers = tiers;
        return ret;
    }

    public static Kontakt getGuarantor(String paymentMode, Patient patient, Fall fall) {
        Kontakt legalGuardian;
        Kontakt invoiceReceiver;
        if (paymentMode.equals("TP")) {
            Kontakt legalGuardian2 = patient.getLegalGuardian();
            if (legalGuardian2 != null) {
                return legalGuardian2;
            }
            return patient;
        }
        Object ret = paymentMode.equals("TG") ? ((invoiceReceiver = fall.getGarant()).equals((Object)patient) ? ((legalGuardian = patient.getLegalGuardian()) != null ? legalGuardian : patient) : invoiceReceiver) : fall.getGarant();
        ret.getPostAnschrift(true);
        return ret;
    }
}

