/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.Artikel;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LaborLeistung;
import ch.elexis.data.PhysioLeistung;
import ch.elexis.data.RFE;
import ch.elexis.data.Rechnung;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterServices {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterServices.class);
    public static final String ELEMENT_SERVICES = "services";
    public static final String ELEMENT_DETAIL = "detail";
    private static final String ATTR_RECORD_ID = "record_id";
    private static final String ELEMENT_RECORD_OTHER = "record_other";
    private static final String ELEMENT_RECORD_PARAMED = "record_paramed";
    private static final String ELEMENT_RECORD_MIGEL = "record_migel";
    private static final String ELEMENT_RECORD_DRUG = "record_drug";
    private static final String ATTR_UNIT_FACTOR = "unit_factor";
    private static final String ATTR_UNIT = "unit";
    private static final String ELEMENT_RECORD_LAB = "record_lab";
    private static final String ATTR_OBLIGATION = "obligation";
    private static final String ATTR_VALIDATE = "validate";
    private static final String ATTR_EXTERNAL_FACTOR_TT = "external_factor_tt";
    private static final String ATTR_SCALE_FACTOR_TT = "scale_factor_tt";
    private static final String ATTR_UNIT_FACTOR_TT = "unit_factor_tt";
    private static final String ATTR_UNIT_TT = "unit_tt";
    private static final String ATTR_EXTERNAL_FACTOR_MT = "external_factor_mt";
    private static final String ATTR_SCALE_FACTOR_MT = "scale_factor_mt";
    private static final String ATTR_UNIT_FACTOR_MT = "unit_factor_mt";
    private static final String ATTR_UNIT_MT = "unit_mt";
    private static final String ATTR_BODY_LOCATION = "body_location";
    private static final String ATTR_MEDICAL_ROLE = "medical_role";
    private static final String ATTR_BILLING_ROLE = "billing_role";
    private static final String ATTR_EAN_RESPONSIBLE = "responsible_id";
    private static final String ATTR_EAN_PROVIDER = "provider_id";
    private static final String ATTR_TREATMENT = "treatment";
    private static final String ATTR_DATE_BEGIN = "date_begin";
    private static final String ATTR_SESSION = "session";
    private static final String ELEMENT_RECORD_TARMED = "record_tarmed";
    private static final String TL = "TL";
    private static final String AL = "AL";
    private static final String TARMED_FALSE = "false";
    private static final String TARMED_TRUE = "true";
    private Element servicesElement;
    private double sumTarmedAL = 0.0;
    private double sumTarmedTL = 0.0;
    private double tpTarmedTL = 0.0;
    private double tpTarmedAL = 0.0;
    private Money mTarmed;
    private Money mKant;
    private Money mUebrige;
    private Money mAnalysen;
    private Money mMigel;
    private Money mPhysio;
    private Money mMedikament;
    private Money mObligations;
    boolean initialized = false;

    public XMLExporterServices(Element services) {
        this.servicesElement = services;
        this.mTarmed = new Money();
        this.mKant = new Money();
        this.mUebrige = new Money();
        this.mAnalysen = new Money();
        this.mMigel = new Money();
        this.mPhysio = new Money();
        this.mMedikament = new Money();
        this.mObligations = new Money();
    }

    public Element getElement() {
        return this.servicesElement;
    }

    public double getSumTarmedAL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.sumTarmedAL;
    }

    public double getSumTarmedTL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.sumTarmedTL;
    }

    public double getTpTarmedAL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.tpTarmedAL;
    }

    public double getTpTarmedTL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.tpTarmedTL;
    }

    public Money getTarmedMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mTarmed;
    }

    public Money getKantMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mKant;
    }

    public Money getUebrigeMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mUebrige;
    }

    public Money getAnalysenMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mAnalysen;
    }

    public Money getMigelMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mMigel;
    }

    public Money getPhysioMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mPhysio;
    }

    public Money getMedikamentMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mMedikament;
    }

    public Money getObligationsMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mObligations;
    }

    public void negateAll() {
        List sr = this.servicesElement.getChildren();
        for (Element el : sr) {
            try {
                XMLExporterUtil.negate(el, "quantity");
                XMLExporterUtil.negate(el, "amount_mt");
                XMLExporterUtil.negate(el, "amount_tt");
                XMLExporterUtil.negate(el, "amount");
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
    }

    private void initFromElement() {
        List records = this.servicesElement.getChildren();
        for (Object object : records) {
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            try {
                if (element.getName().equals(ELEMENT_RECORD_TARMED)) {
                    this.mTarmed.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_LAB)) {
                    this.mAnalysen.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_DRUG)) {
                    this.mMedikament.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_MIGEL)) {
                    this.mMigel.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_PARAMED)) {
                    this.mPhysio.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_OTHER)) {
                    this.mUebrige.addAmount(element.getAttributeValue("amount"));
                }
                String obligation = element.getAttributeValue(ATTR_OBLIGATION);
                if (obligation == null || !TARMED_TRUE.equals(obligation)) continue;
                this.mObligations.addAmount(obligation);
            }
            catch (ParseException e) {
                logger.error("Error parsing services " + e);
            }
        }
        this.initialized = true;
    }

    public static XMLExporterServices buildServices(Rechnung rechnung, XMLExporter.VatRateSum vatSummer) {
        XMLExporterServices ret = new XMLExporterServices(new Element(ELEMENT_SERVICES, XMLExporter.nsinvoice));
        List konsultationen = rechnung.getKonsultationen();
        int recordNumber = 1;
        String lastKonsDatum = null;
        int session = 1;
        for (Konsultation konsultation : konsultationen) {
            List leistungen = konsultation.getLeistungen();
            String konsDatum = konsultation.getDatum();
            if (konsDatum.equals(lastKonsDatum)) {
                ++session;
            } else {
                lastKonsDatum = konsDatum;
                session = 1;
            }
            TimeTool tt = new TimeTool(konsDatum);
            String dateForTarmed = XMLExporterUtil.makeTarmedDatum(konsultation.getDatum());
            BillingLaw law = konsultation.getFall().getConfiguredBillingSystemLaw();
            boolean bRFE = false;
            for (Verrechnet verrechnet : leistungen) {
                Money preis;
                Money mAmountLocal;
                LaborLeistung ll;
                Element el;
                double zahl = verrechnet.getZahl();
                IVerrechenbar v = verrechnet.getVerrechenbar();
                if (v == null) {
                    logger.error(String.valueOf(Messages.XMLExporter_ErroneusBill) + rechnung.getNr() + " Null-Verrechenbar bei Kons " + konsultation.getLabel());
                    continue;
                }
                if (v instanceof TarmedLeistung) {
                    TarmedLeistung tl = (TarmedLeistung)v;
                    double primaryScale = verrechnet.getPrimaryScaleFactor();
                    double secondaryScale = verrechnet.getSecondaryScaleFactor();
                    double mult = tl.getVKMultiplikator(tt, (IFall)rechnung.getFall());
                    double tlAL = TarmedLeistung.getAL(verrechnet);
                    double tlTL = TarmedLeistung.getTL(verrechnet);
                    Money mAL = new Money((int)Math.round(tlAL * mult * zahl * primaryScale * secondaryScale));
                    Money mTL = new Money((int)Math.round(tlTL * mult * zahl * primaryScale * secondaryScale));
                    Money mAmountLocal2 = new Money((int)Math.round((tlAL + tlTL) * mult * zahl * primaryScale * secondaryScale));
                    ret.tpTarmedTL += tlTL * zahl;
                    ret.tpTarmedAL += tlAL * zahl;
                    ret.sumTarmedAL += tlAL * mult * zahl * primaryScale * secondaryScale;
                    ret.sumTarmedTL += tlTL * mult * zahl * primaryScale * secondaryScale;
                    ret.mTarmed.addCent(mAmountLocal2.getCents());
                    el = new Element(ELEMENT_RECORD_TARMED, XMLExporter.nsinvoice);
                    el.setAttribute(ATTR_TREATMENT, "ambulatory");
                    el.setAttribute("tariff_type", "001");
                    Hashtable<String, String> ext = tl.loadExtension();
                    String bezug = ext.get("Bezug");
                    if (StringTool.isNothing((Object)bezug)) {
                        bezug = verrechnet.getDetail("Bezug");
                    }
                    if (!StringTool.isNothing((Object)bezug)) {
                        el.setAttribute("ref_code", bezug);
                    }
                    el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((Kontakt)konsultation.getMandant()));
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(konsultation));
                    el.setAttribute(ATTR_BILLING_ROLE, "both");
                    el.setAttribute(ATTR_MEDICAL_ROLE, "self_employed");
                    el.setAttribute(ATTR_BODY_LOCATION, TarmedLeistung.getSide(verrechnet));
                    el.setAttribute(ATTR_UNIT_MT, XMLTool.doubleToXmlDouble((double)(tlAL / 100.0), (int)2));
                    XMLExporterServices.getALNotScaled(verrechnet).ifPresent(d -> el.setAttribute(ATTR_UNIT_MT, XMLTool.doubleToXmlDouble((double)(d / 100.0), (int)2)));
                    el.setAttribute(ATTR_UNIT_FACTOR_MT, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    el.setAttribute(ATTR_SCALE_FACTOR_MT, XMLTool.doubleToXmlDouble((double)primaryScale, (int)1));
                    XMLExporterServices.getALScalingFactor(verrechnet).ifPresent(f -> {
                        f = f * primaryScale;
                        el.setAttribute(ATTR_SCALE_FACTOR_MT, XMLTool.doubleToXmlDouble((double)f, (int)1));
                    });
                    el.setAttribute(ATTR_EXTERNAL_FACTOR_MT, XMLTool.doubleToXmlDouble((double)secondaryScale, (int)1));
                    el.setAttribute("amount_mt", XMLTool.moneyToXmlDouble((Money)mAL));
                    el.setAttribute(ATTR_UNIT_TT, XMLTool.doubleToXmlDouble((double)(tlTL / 100.0), (int)2));
                    el.setAttribute(ATTR_UNIT_FACTOR_TT, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    el.setAttribute(ATTR_SCALE_FACTOR_TT, XMLTool.doubleToXmlDouble((double)primaryScale, (int)1));
                    el.setAttribute(ATTR_EXTERNAL_FACTOR_TT, XMLTool.doubleToXmlDouble((double)secondaryScale, (int)1));
                    el.setAttribute("amount_tt", XMLTool.moneyToXmlDouble((Money)mTL));
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal2));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal2, el, vatSummer);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    if (TarmedLeistung.isObligation(verrechnet)) {
                        el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        ret.mObligations.addMoney(mAmountLocal2);
                    } else {
                        el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                    }
                    if (!bRFE) {
                        List<RFE> rfes = RFE.getRfeForKons(konsultation.getId());
                        if (rfes.size() > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (RFE rfe : rfes) {
                                sb.append("551_").append(rfe.getCode()).append(" ");
                            }
                            el.setAttribute("remark", sb.toString());
                        }
                        bRFE = true;
                    }
                } else if (v instanceof Labor2009Tarif) {
                    el = new Element(ELEMENT_RECORD_LAB, XMLExporter.nsinvoice);
                    el.setAttribute("tariff_type", v.getCodeSystemCode());
                    el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((Kontakt)konsultation.getMandant()));
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(konsultation));
                    ll = (Labor2009Tarif)v;
                    double mult = ll.getFactor(tt, (IFall)rechnung.getFall());
                    Money preis2 = verrechnet.getNettoPreis();
                    double korr = (double)preis2.getCents() / mult;
                    el.setAttribute(ATTR_UNIT, XMLTool.doubleToXmlDouble((double)(korr / 100.0), (int)2));
                    el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    mAmountLocal = new Money(preis2);
                    mAmountLocal.multiply(zahl);
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal, el, vatSummer);
                    el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                    ret.mObligations.addMoney(mAmountLocal);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    ret.mAnalysen.addMoney(mAmountLocal);
                } else if (v instanceof LaborLeistung) {
                    el = new Element(ELEMENT_RECORD_LAB, XMLExporter.nsinvoice);
                    el.setAttribute("tariff_type", "316");
                    ll = (LaborLeistung)v;
                    double mult = ll.getFactor(tt, (IFall)rechnung.getFall());
                    Money preis3 = verrechnet.getNettoPreis();
                    double korr = (double)preis3.getCents() / mult;
                    el.setAttribute(ATTR_UNIT, XMLTool.doubleToXmlDouble((double)(korr / 100.0), (int)2));
                    el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    mAmountLocal = new Money(preis3);
                    mAmountLocal.multiply(zahl);
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal, el, vatSummer);
                    el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                    ret.mObligations.addMoney(mAmountLocal);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    ret.mAnalysen.addMoney(mAmountLocal);
                } else if ("Medikamente".equals(v.getCodeSystemName()) || "Medicals".equals(v.getCodeSystemName()) || "400".equals(v.getCodeSystemCode()) || "402".equals(v.getCodeSystemCode())) {
                    el = new Element(ELEMENT_RECORD_DRUG, XMLExporter.nsinvoice);
                    Artikel art = (Artikel)v;
                    double mult = art.getFactor(tt, (IFall)rechnung.getFall());
                    Money preis4 = verrechnet.getNettoPreis();
                    Money mAmountLocal3 = new Money(preis4);
                    mAmountLocal3.multiply(zahl);
                    if (XMLExporterServices.isPartialAmount(verrechnet)) {
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)verrechnet.getBruttoPreis()));
                        el.setAttribute("quantity", Double.toString(verrechnet.getSecondaryScaleFactor()));
                    } else {
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)preis4));
                        el.setAttribute("quantity", Double.toString(zahl));
                    }
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal3));
                    el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    if (TARMED_TRUE.equals(verrechnet.getDetail("indicated"))) {
                        el.setAttribute("tariff_type", "207");
                    } else {
                        el.setAttribute("tariff_type", v.getCodeSystemCode());
                    }
                    if ("402".equals(v.getCodeSystemCode())) {
                        String gtin = ((Artikel)v).getEAN();
                        el.setAttribute("code", gtin);
                    } else if ("400".equals(v.getCodeSystemCode())) {
                        String pk = ((Artikel)v).getPharmaCode();
                        el.setAttribute("code", StringTool.pad((int)1, (char)'0', (String)pk, (int)7));
                    } else {
                        logger.warn("Unknown medical code " + v.getCodeSystemCode() + " encountered for " + v.getCodeSystemName() + "@" + v);
                    }
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal3, el, vatSummer);
                    String ckzl = art.getExt("Kassentyp");
                    if (ckzl.equals("1")) {
                        el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        ret.mObligations.addMoney(mAmountLocal3);
                    } else {
                        el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                    }
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((Kontakt)konsultation.getMandant()));
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(konsultation));
                    ret.mMedikament.addMoney(mAmountLocal3);
                } else if ("MiGeL".equals(v.getCodeSystemName())) {
                    el = new Element(ELEMENT_RECORD_MIGEL, XMLExporter.nsinvoice);
                    preis = verrechnet.getNettoPreis();
                    el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)preis));
                    el.setAttribute(ATTR_UNIT_FACTOR, "1.0");
                    el.setAttribute("tariff_type", "452");
                    el.setAttribute("code", v.getCode());
                    el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((Kontakt)konsultation.getMandant()));
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(konsultation));
                    Money mAmountLocal4 = new Money(preis);
                    mAmountLocal4.multiply(zahl);
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal4));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal4, el, vatSummer);
                    el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                    ret.mObligations.addMoney(mAmountLocal4);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    ret.mMigel.addMoney(mAmountLocal4);
                } else if (v instanceof PhysioLeistung) {
                    el = new Element(ELEMENT_RECORD_PARAMED, XMLExporter.nsinvoice);
                    el.setAttribute("tariff_type", v.getCodeSystemCode());
                    if (law == BillingLaw.KVG) {
                        el.setAttribute("tariff_type", "312");
                    }
                    PhysioLeistung pl = (PhysioLeistung)v;
                    double mult = pl.getFactor(tt, (IFall)rechnung.getFall());
                    Money preis5 = verrechnet.getNettoPreis();
                    double korr = (double)preis5.getCents() / mult;
                    el.setAttribute(ATTR_UNIT, XMLTool.doubleToXmlDouble((double)(korr / 100.0), (int)2));
                    el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                    mAmountLocal = new Money(preis5);
                    mAmountLocal.multiply(zahl);
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal, el, vatSummer);
                    el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                    ret.mObligations.addMoney(mAmountLocal);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    String ean = TarmedRequirements.getEAN((Kontakt)konsultation.getMandant());
                    if (ean.equals("2000000000000")) {
                        ean = "unknown";
                    }
                    el.setAttribute(ATTR_EAN_PROVIDER, ean);
                    ean = XMLExporterUtil.getResponsibleEAN(konsultation);
                    if (ean.equals("2000000000000")) {
                        ean = "unknown";
                    }
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, ean);
                    ret.mPhysio.addMoney(mAmountLocal);
                } else {
                    preis = verrechnet.getNettoPreis();
                    el = new Element(ELEMENT_RECORD_OTHER, XMLExporter.nsinvoice);
                    String codeSystemCode = v.getCodeSystemCode();
                    el.setAttribute("tariff_type", codeSystemCode);
                    if ("3028".equals(v.getCode())) {
                        el.setAttribute("tariff_type", "406");
                    } else if ("406".equals(codeSystemCode)) {
                        el.setAttribute("code", "2000");
                        el.setAttribute("name", String.valueOf(verrechnet.getText()) + " [" + XMLExporterServices.getServiceCode(verrechnet) + "]");
                    }
                    if ("590".equals(codeSystemCode) && v instanceof IArticle) {
                        el.setAttribute("code", "1310");
                    }
                    Money mAmountLocal5 = new Money(preis);
                    mAmountLocal5.multiply(zahl);
                    if (XMLExporterServices.isPartialAmount(verrechnet)) {
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)verrechnet.getBruttoPreis()));
                        el.setAttribute("quantity", Double.toString(verrechnet.getSecondaryScaleFactor()));
                    } else {
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)preis));
                        el.setAttribute("quantity", Double.toString(zahl));
                    }
                    el.setAttribute(ATTR_UNIT_FACTOR, "1.0");
                    el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal5));
                    XMLExporterUtil.setVatAttribute(verrechnet, mAmountLocal5, el, vatSummer);
                    el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                    el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                    el.setAttribute("external_factor", "1.0");
                    el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((Kontakt)konsultation.getMandant()));
                    el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(konsultation));
                    ret.mUebrige.addMoney(mAmountLocal5);
                }
                el.setAttribute(ATTR_SESSION, Integer.toString(session));
                el.setAttribute(ATTR_RECORD_ID, Integer.toString(recordNumber++));
                el.setAttribute(ATTR_DATE_BEGIN, dateForTarmed);
                if (el.getAttribute("name") == null) {
                    el.setAttribute("name", verrechnet.getText());
                }
                if (el.getAttribute("quantity") == null) {
                    el.setAttribute("quantity", Double.toString(zahl));
                }
                if (el.getAttribute("code") == null) {
                    XMLExporterUtil.setAttributeWithDefault(el, "code", XMLExporterServices.getServiceCode(verrechnet), "0");
                }
                ret.servicesElement.addContent((Content)el);
            }
        }
        ret.initialized = true;
        return ret;
    }

    private static boolean isPartialAmount(Verrechnet verrechnet) {
        return verrechnet.getZahl() == 1 && verrechnet.getSecondaryScaleFactor() != 1.0;
    }

    private static Optional<Double> getALScalingFactor(Verrechnet verrechnet) {
        String scalingFactor = verrechnet.getDetail("AL_SCALINGFACTOR");
        if (scalingFactor != null && !scalingFactor.isEmpty()) {
            try {
                return Optional.of(Double.parseDouble(scalingFactor));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static Optional<Double> getALNotScaled(Verrechnet verrechnet) {
        String notScaled = verrechnet.getDetail("AL_NOTSCALED");
        if (notScaled != null && !notScaled.isEmpty()) {
            try {
                return Optional.of(Double.parseDouble(notScaled));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static String getServiceCode(Verrechnet verrechnet) {
        String ret = verrechnet.getCode();
        IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
        if ((verrechenbar instanceof Eigenleistung || verrechenbar instanceof Artikel && ((Artikel)verrechenbar).get("Typ").equals("Eigenartikel")) && verrechenbar.getId().equals(ret)) {
            ret = "";
        }
        return ret;
    }
}

