/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Rechnung;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.XMLTool;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterProcessing {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterProcessing.class);
    private static final String ELEMENT_PROCESSING = "processing";
    public static final String ATTR_INTERMEDIAT_PRINT = "print_at_intermediate";
    private static final String ATTR_PATIENT_COPY_PRINT = "print_patient_copy";
    public static final String ELEMENT_TRANSPORT = "transport";
    public static final String ELEMENT_TRANSPORT_VIA = "via";
    private static final String ATTR_TRANSPORT_FROM = "from";
    private static final String ATTR_TRANSPORT_TO = "to";
    public static final String ATTR_TRANSPORT_VIA_VIA = "via";
    private static final String ATTR_TRANSPORT_VIA_SEQ = "sequence_id";
    private Element processingElement;

    private XMLExporterProcessing(Element processing) {
        this.processingElement = processing;
    }

    public Element getElement() {
        return this.processingElement;
    }

    public static XMLExporterProcessing buildProcessing(Rechnung rechnung, XMLExporter xmlExporter) {
        Fall actFall = rechnung.getFall();
        Mandant actMandant = rechnung.getMandant();
        Element element = null;
        element = new Element(ELEMENT_PROCESSING, XMLExporter.nsinvoice);
        element.setAttribute(ATTR_INTERMEDIAT_PRINT, xmlExporter.isPrintAtIntermediate() ? "1" : "0");
        if (actFall.getCopyForPatient()) {
            element.setAttribute(ATTR_PATIENT_COPY_PRINT, "1");
        }
        Element transport = new Element(ELEMENT_TRANSPORT, XMLExporter.nsinvoice);
        transport.setAttribute(ATTR_TRANSPORT_FROM, xmlExporter.getSenderEAN(actMandant));
        transport.setAttribute(ATTR_TRANSPORT_TO, XMLExporterProcessing.getRecipientEAN(rechnung, xmlExporter));
        logger.debug("Using intermediate EAN [" + XMLExporterProcessing.getIntermediateEAN(rechnung, xmlExporter) + "]");
        Element via = new Element("via", XMLExporter.nsinvoice);
        via.setAttribute("via", XMLExporterProcessing.getIntermediateEAN(rechnung, xmlExporter));
        via.setAttribute(ATTR_TRANSPORT_VIA_SEQ, "1");
        transport.addContent((Content)via);
        element.addContent((Content)transport);
        Fall.Tiers tiersType = actFall.getTiersType();
        if (Fall.Tiers.GARANT == tiersType && TarmedRequirements.hasTCContract((Kontakt)actMandant)) {
            String tcCode = TarmedRequirements.getTCCode((Kontakt)actMandant);
            Element demand = new Element("demand", XMLExporter.nsinvoice);
            demand.setAttribute("tc_demand_id", "0");
            demand.setAttribute("tc_token", xmlExporter.getBesr().createCodeline(XMLTool.moneyToXmlDouble((Money)xmlExporter.getDueMoney()).replaceFirst("[.,]", ""), tcCode));
            demand.setAttribute("insurance_demand_date", XMLExporterUtil.makeTarmedDatum(rechnung.getDatumRn()));
            element.addContent((Content)demand);
        }
        XMLExporterProcessing ret = new XMLExporterProcessing(element);
        return ret;
    }

    public static String getIntermediateEAN(Rechnung rechnung, XMLExporter xmlExporter) {
        Fall actFall = rechnung.getFall();
        String kEAN = XMLExporterProcessing.getKostentraegerEAN(rechnung, xmlExporter);
        String rEAN = XMLExporterProcessing.getRecipientEAN(rechnung, xmlExporter);
        String iEAN = xmlExporter.getIntermediateEAN(actFall);
        logger.debug("Intermediate EAN [" + iEAN + "]");
        if (StringTool.isNothing((Object)iEAN)) {
            iEAN = !rEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? (kEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? kEAN : "2000000000000") : rEAN;
        }
        return iEAN;
    }

    private static Kontakt getKostentTraeger(Fall invoiceCoverage) {
        Kontakt kostentraeger = invoiceCoverage.getCostBearer();
        if (kostentraeger == null) {
            kostentraeger = invoiceCoverage.getPatient();
        }
        return kostentraeger;
    }

    public static String getRecipientEAN(Rechnung rechnung, XMLExporter xmlExporter) {
        String rEAN = TarmedRequirements.getRecipientEAN(XMLExporterProcessing.getKostentTraeger(rechnung.getFall()));
        logger.debug("Recipient EAN [" + rEAN + "]");
        if (rEAN.equals("unknown")) {
            rEAN = XMLExporterProcessing.getKostentraegerEAN(rechnung, xmlExporter);
        }
        return rEAN;
    }

    public static String getKostentraegerEAN(Rechnung rechnung, XMLExporter xmlExporter) {
        String kEAN = TarmedRequirements.getEAN(XMLExporterProcessing.getKostentTraeger(rechnung.getFall()));
        logger.debug("Kostentraeger EAN [" + kEAN + "]");
        return kEAN;
    }
}

