/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import org.jdom.Element;

public class XMLExporterInsurance {
    private static final String ATTR_CASE_ID = "case_id";
    private Element insuranceElement;

    private XMLExporterInsurance(Element insuranceElement) {
        this.insuranceElement = insuranceElement;
    }

    public Element getElement() {
        return this.insuranceElement;
    }

    public static XMLExporterInsurance buildInsurance(Rechnung rechnung, XMLExporter xmlExporter) {
        Fall actFall = rechnung.getFall();
        Patient actPatient = actFall.getPatient();
        Mandant actMandant = rechnung.getMandant();
        String gesetz = TarmedRequirements.getGesetz(actFall);
        Element element = new Element(gesetz.toLowerCase(), XMLExporter.nsinvoice);
        if (gesetz.equalsIgnoreCase("ivg")) {
            String caseNumber = actFall.getRequiredString(TarmedRequirements.CASE_NUMBER);
            if (!((caseNumber = caseNumber.replaceAll("[^0-9]", "")).matches("[0-9]{14}") || caseNumber.matches("[0-9]{10}") || caseNumber.matches("[0-9]{9}") || caseNumber.matches("[0-9]{6}"))) {
                if (CoreHub.userCfg.get("billing/strict", true)) {
                    rechnung.reject(RnStatus.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_IVCaseNumberInvalid);
                } else {
                    caseNumber = "123456";
                }
            }
            element.setAttribute(ATTR_CASE_ID, caseNumber);
            XMLExporterInsurance.addSSNAttribute(element, actPatient, actFall, rechnung, false);
            String nif = TarmedRequirements.getNIF((Kontakt)actMandant.getRechnungssteller()).replaceAll("[^0-9]", "");
            if (CoreHub.userCfg.get("billing/strict", true) && !nif.matches("[0-9]{1,7}")) {
                rechnung.reject(RnStatus.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_NIFInvalid);
            } else {
                element.setAttribute("nif", nif);
            }
        } else if (gesetz.equalsIgnoreCase("mvg")) {
            XMLExporterInsurance.addSSNAttribute(element, actPatient, actFall, rechnung, false);
            XMLExporterInsurance.addInsuredId(element, actPatient, actFall);
        } else if (gesetz.equalsIgnoreCase("uvg")) {
            String casenumber = actFall.getRequiredString(TarmedRequirements.CASE_NUMBER);
            if (StringTool.isNothing((Object)casenumber)) {
                casenumber = actFall.getRequiredString(TarmedRequirements.ACCIDENT_NUMBER);
            }
            if (!StringTool.isNothing((Object)casenumber)) {
                element.setAttribute(ATTR_CASE_ID, casenumber);
            }
            XMLExporterInsurance.addSSNAttribute(element, actPatient, actFall, rechnung, true);
            XMLExporterInsurance.addInsuredId(element, actPatient, actFall);
        } else {
            XMLExporterInsurance.addInsuredId(element, actPatient, actFall);
        }
        String casedate = actFall.getInfoString("Unfalldatum");
        if (StringTool.isNothing((Object)casedate)) {
            casedate = rechnung.getDatumVon();
        }
        element.setAttribute("case_date", XMLExporterUtil.makeTarmedDatum(casedate));
        XMLExporterUtil.setAttributeIfNotEmpty(element, "contract_number", actFall.getInfoString("Vertragsnummer"));
        return new XMLExporterInsurance(element);
    }

    private static void addInsuredId(Element element, Patient actPatient, Fall actFall) {
        String vnummer = actFall.getRequiredString(TarmedRequirements.INSURANCE_NUMBER);
        if (StringTool.isNothing((Object)vnummer)) {
            vnummer = actFall.getRequiredString(TarmedRequirements.CASE_NUMBER);
        }
        if (StringTool.isNothing((Object)vnummer)) {
            vnummer = actPatient.getId();
        }
        element.setAttribute("insured_id", vnummer);
    }

    private static void addSSNAttribute(Element element, Patient actPatient, Fall actFall, Rechnung rechnung, boolean isOptional) {
        boolean ahvValid;
        String ahv = TarmedRequirements.getAHV((Person)actPatient).replaceAll("[^0-9]", "");
        if (ahv.length() == 0) {
            ahv = actFall.getRequiredString(TarmedRequirements.SSN).replaceAll("[^0-9]", "");
        }
        boolean bl = ahvValid = ahv.matches("[0-9]{11}") || ahv.matches("[0-9]{13}");
        if (!isOptional && CoreHub.userCfg.get("billing/strict", true) && !ahvValid) {
            rechnung.reject(RnStatus.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_AHVInvalid);
        } else if (ahvValid) {
            element.setAttribute("ssn", ahv);
        }
    }
}

