/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterBalance;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Organisation;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.XMLTool;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jdom.Content;
import org.jdom.Element;

public class XMLExporterEsr9 {
    private static final String ATTR_PARTICIPANT_NUMBER = "participant_number";
    private static final String ATTR_TYPE = "type";
    private Element esr9Element;

    private XMLExporterEsr9(Element esr9) {
        this.esr9Element = esr9;
    }

    public Element getElement() {
        return this.esr9Element;
    }

    public static XMLExporterEsr9 buildEsr9(Rechnung rechnung, XMLExporterBalance balance, XMLExporter xmlExporter) {
        Mandant actMandant = rechnung.getMandant();
        String esrmode = actMandant.getRechnungssteller().getInfoString(XMLExporter.ta.ESR5OR9);
        ESR besr = xmlExporter.getBesr();
        if (!esrmode.equals("esr9")) {
            MessageDialog.openError(null, (String)Messages.XMLExporter_MandatorErrorCaption, (String)Messages.XMLExporter_MandatorErrorText);
            return null;
        }
        Element element = new Element("esr9", XMLExporter.nsinvoice);
        element.setAttribute(ATTR_PARTICIPANT_NUMBER, besr.makeParticipantNumber(true));
        element.setAttribute(ATTR_TYPE, "16or27");
        String refnr = besr.makeRefNr(true);
        String codingline = besr.createCodeline(XMLTool.moneyToXmlDouble((Money)balance.getDue()).replaceFirst("[.,]", ""), null);
        element.setAttribute("reference_number", refnr);
        element.setAttribute("coding_line", codingline);
        String bankid = actMandant.getRechnungssteller().getInfoString(XMLExporter.ta.RNBANK);
        if (!bankid.equals("")) {
            Organisation bank = Organisation.load((String)bankid);
            Element eBank = new Element("bank", XMLExporter.nsinvoice);
            Element company = XMLExporterUtil.buildAdressElement((Kontakt)bank);
            eBank.addContent((Content)company);
            element.addContent((Content)eBank);
        }
        return new XMLExporterEsr9(element);
    }
}

