/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.Validator;
import ch.elexis.TarmedRechnung.XMLExporterBalance;
import ch.elexis.TarmedRechnung.XMLExporterEsr9;
import ch.elexis.TarmedRechnung.XMLExporterInsurance;
import ch.elexis.TarmedRechnung.XMLExporterProcessing;
import ch.elexis.TarmedRechnung.XMLExporterProlog;
import ch.elexis.TarmedRechnung.XMLExporterServices;
import ch.elexis.TarmedRechnung.XMLExporterTiers;
import ch.elexis.TarmedRechnung.XMLExporterTreatment;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.preferences.CorePreferenceInitializer;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.TrustCenters;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporter
implements IRnOutputter {
    private static Logger logger = LoggerFactory.getLogger(XMLExporter.class);
    public static final String VAT_ISMANDANTVAT = "at.medevit.medelexis.vat_ch/IsMandantVat";
    public static final String VAT_MANDANTVATNUMBER = "at.medevit.medelexis.vat_ch/MandantVatNumber";
    public static final String ATTR_REMARK = "remark";
    public static final String ELEMENT_TIERS_PAYANT = "tiers_payant";
    public static final String ELEMENT_TIERS_GARANT = "tiers_garant";
    public static final String ATTR_CODE = "code";
    public static final String BIRTHDEFECT = "birthdefect";
    public static final String DISEASE = "disease";
    public static final String FREETEXT = "freetext";
    public static final String ATTR_BIRTHDATE = "birthdate";
    public static final String ELEMENT_VAT = "vat";
    public static final String ELEMENT_VAT_NUMBER = "vat_number";
    public static final String ATTR_VAT_RATE = "vat_rate";
    public static final String ATTR_TARIFF_TYPE = "tariff_type";
    public static final String ELEMENT_REMARK = "remark";
    private static final String ELEMENT_PAYLOAD = "payload";
    private static final String ATTR_PAYLOAD_TYPE = "type";
    private static final String ATTR_PAYLOAD_COPY = "copy";
    private static final String ATTR_PAYLOAD_STORNO = "storno";
    public static final String ATTR_EAN_PARTY = "ean_party";
    private static final String ATTR_MODUS = "modus";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ELEMENT_REQUEST = "request";
    private static final String ATTR_REQUEST_TIMESTAMP = "request_timestamp";
    public static final String ATTR_REQUEST_DATE = "request_date";
    public static final String ATTR_REQUEST_ID = "request_id";
    public static final String TIERS_GARANT = "TG";
    public static final String TIERS_PAYANT = "TP";
    public static final String ATTR_AMOUNT_PHYSIO = "amount_physio";
    public static final String ATTR_AMOUNT_MIGEL = "amount_migel";
    public static final String ATTR_AMOUNT_LAB = "amount_lab";
    public static final String ATTR_AMOUNT_DRUG = "amount_drug";
    public static final String ATTR_AMOUNT_UNCLASSIFIED = "amount_unclassified";
    public static final String ATTR_AMOUNT_CANTONAL = "amount_cantonal";
    public static final String ATTR_AMOUNT_TARMED_TT = "amount_tarmed.tt";
    public static final String ATTR_AMOUNT_TARMED_MT = "amount_tarmed.mt";
    public static final String ATTR_AMOUNT_TARMED = "amount_tarmed";
    public static final String ATTR_AMOUNT = "amount";
    public static final String ATTR_AMOUNT_REMINDER = "amount_reminder";
    public static final String ATTR_AMOUNT_TT = "amount_tt";
    public static final String ATTR_AMOUNT_MT = "amount_mt";
    public static final String ATTR_QUANTITY = "quantity";
    public static final String ATTR_AMOUNT_DUE = "amount_due";
    public static final String ATTR_AMOUNT_PREPAID = "amount_prepaid";
    public static final String ELEMENT_BALANCE = "balance";
    public static final String ELEMENT_INVOICE = "invoice";
    public static final String ELEMENT_BODY = "body";
    public static final String ATTR_BODY_ROLE = "role";
    public static final String ATTR_BODY_PLACE = "place";
    public static final String ELEMENT_ANNULMENT = "annulment";
    public static final String FIELDNAME_TIMESTAMPXML = "TimeStampXML";
    public static final String ELEMENT_REMINDER = "reminder";
    public static final String ATTR_REMINDER_LEVEL = "reminder_level";
    public static final Namespace ns = Namespace.getNamespace((String)"http://www.forum-datenaustausch.ch/invoice");
    public static final Namespace nsinvoice = Namespace.getNamespace((String)"invoice", (String)"http://www.forum-datenaustausch.ch/invoice");
    public static final Namespace nsxsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace nsxenc = Namespace.getNamespace((String)"nsxenc", (String)"http://www.w3.org/2001/04/xmlenc#");
    public static final Namespace nsds = Namespace.getNamespace((String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
    Fall actFall;
    Patient actPatient;
    Mandant actMandant;
    String tiers;
    Rechnung rn;
    private XMLExporterBalance xmlBalance;
    private XMLExporterTreatment xmlTreatment;
    private ESR besr;
    static TarmedACL ta;
    private String outputDir;
    private XMLExporterEsr9 esr9;
    private boolean printAtIntermediate = true;
    public static final String PREFIX = "TarmedRn:";

    public void clear() {
        this.actFall = null;
        this.actPatient = null;
        this.actMandant = null;
        this.rn = null;
    }

    public XMLExporter() {
        ta = TarmedACL.getInstance();
        this.clear();
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        SWTHelper.SimpleDialog dlg;
        final Result ret = new Result();
        if (this.outputDir == null && (dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

            public Control getControl(Composite parent) {
                return XMLExporter.this.createSettingsControl(parent);
            }

            public void beforeClosing() {
            }
        })).open() != 0) {
            return ret;
        }
        ProgressMonitorDialog progress = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RechnungsDrucker_PrintingBills, rnn.size());
                    for (Rechnung rn : rnn) {
                        if (XMLExporter.this.doExport(rn, String.valueOf(XMLExporter.this.outputDir) + File.separator + rn.getNr() + ".xml", type, false) == null) {
                            ret.add(Result.SEVERITY.ERROR, 1, String.valueOf(Messages.XMLExporter_ErrorInBill) + rn.getNr(), (Object)rn, true);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(XMLExporter.class).error("Error outputting bills", (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.RechnungsDrucker_MessageErrorWhilePrinting, (String)(String.valueOf(Messages.RechnungsDrucker_MessageErrorWhilePrinting) + "[" + e.getMessage() + "]"));
        }
        return ret;
    }

    public boolean canStorno(Rechnung rn) {
        return true;
    }

    public boolean isPrintAtIntermediate() {
        return this.printAtIntermediate;
    }

    public void setPrintAtIntermediate(boolean value) {
        this.printAtIntermediate = value;
    }

    private void negate(Element el, String attr) {
        String v = el.getAttributeValue(attr);
        if (!StringTool.isNothing((Object)v) && !v.equals("0.00")) {
            v = v.startsWith("-") ? v.substring(1) : "-" + v;
            el.setAttribute(attr, v);
        }
    }

    public Document doExport(Rechnung rechnung, String dest, IRnOutputter.TYPE type, boolean doVerify) {
        this.clear();
        VatRateSum vatSummer = new VatRateSum();
        this.rn = rechnung;
        if (this.xmlBillExists(rechnung)) {
            logger.info("Updating existing bill for " + rechnung.getNr());
            Document updated = this.updateExistingXmlBill(rechnung, dest, type, doVerify);
            if (updated != null) {
                return updated;
            }
        }
        if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            SWTHelper.showError((String)Messages.XMLExporter_StornoImpossibleCaption, (String)Messages.XMLExporter_StornoImpossibleText);
            return null;
        }
        this.actFall = this.rn.getFall();
        this.actPatient = this.actFall.getPatient();
        this.actMandant = this.rn.getMandant();
        Kontakt kostentraeger = this.actFall.getCostBearer();
        if (kostentraeger == null) {
            kostentraeger = this.actPatient;
        }
        logger.info("Creating new bill for " + rechnung.getNr());
        Element root = new Element(ELEMENT_REQUEST, nsinvoice);
        root.addNamespaceDeclaration(nsxsi);
        root.addNamespaceDeclaration(nsxenc);
        root.addNamespaceDeclaration(nsxsi);
        root.addNamespaceDeclaration(nsinvoice);
        root.setAttribute("schemaLocation", "http://www.forum-datenaustausch.ch/invoice generalInvoiceRequest_440.xsd", nsxsi);
        root.setAttribute(ATTR_MODUS, this.getRole(this.actFall));
        root.setAttribute(ATTR_LANGUAGE, Locale.getDefault().getLanguage());
        Document xmlRn = new Document(root);
        XMLExporterServices services = null;
        services = XMLExporterServices.buildServices(this.rn, vatSummer);
        this.initBalanceData(rechnung, services, vatSummer);
        XMLExporterProcessing processing = XMLExporterProcessing.buildProcessing(rechnung, this);
        root.addContent((Content)processing.getElement());
        Element payload = new Element(ELEMENT_PAYLOAD, nsinvoice);
        payload.setAttribute(ATTR_PAYLOAD_TYPE, ELEMENT_INVOICE);
        payload.setAttribute(ATTR_PAYLOAD_COPY, type.equals((Object)IRnOutputter.TYPE.COPY) ? "1" : "0");
        payload.setAttribute(ATTR_PAYLOAD_STORNO, type.equals((Object)IRnOutputter.TYPE.STORNO) ? "1" : "0");
        String ts = null;
        if (type.equals((Object)IRnOutputter.TYPE.COPY)) {
            ts = this.rn.getExtInfo(FIELDNAME_TIMESTAMPXML);
            if (StringTool.isNothing((Object)ts)) {
                ts = Long.toString(new Date().getTime() / 1000L);
                this.rn.setExtInfo(FIELDNAME_TIMESTAMPXML, ts);
            }
        } else {
            ts = Long.toString(new Date().getTime() / 1000L);
            this.rn.setExtInfo(FIELDNAME_TIMESTAMPXML, ts);
        }
        Element invoice = new Element(ELEMENT_INVOICE, nsinvoice);
        invoice.setAttribute(ATTR_REQUEST_TIMESTAMP, ts);
        invoice.setAttribute(ATTR_REQUEST_ID, this.rn.getRnId());
        invoice.setAttribute(ATTR_REQUEST_DATE, String.valueOf(new TimeTool(this.rn.getDatumRn()).toString(6)) + "T" + new TimeTool().toString(2));
        payload.addContent((Content)invoice);
        Element body = new Element(ELEMENT_BODY, nsinvoice);
        body.setAttribute(ATTR_BODY_ROLE, "physician");
        body.setAttribute(ATTR_BODY_PLACE, "practice");
        XMLExporterProlog prolog = XMLExporterProlog.buildProlog(rechnung, this);
        body.addContent((Content)prolog.getElement());
        body.addContent((Content)this.xmlBalance.getElement());
        this.esr9 = XMLExporterEsr9.buildEsr9(rechnung, this.xmlBalance, this);
        body.addContent((Content)this.esr9.getElement());
        XMLExporterTiers xmlTiers = XMLExporterTiers.buildTiers(rechnung, this);
        this.tiers = xmlTiers.getTiers();
        body.addContent((Content)xmlTiers.getElement());
        XMLExporterInsurance xmlInsurance = XMLExporterInsurance.buildInsurance(rechnung, this);
        body.addContent((Content)xmlInsurance.getElement());
        this.xmlTreatment = XMLExporterTreatment.buildTreatment(rechnung, this);
        body.addContent((Content)this.xmlTreatment.getElement());
        if (services != null) {
            body.addContent((Content)services.getElement());
        } else {
            logger.warn("services is null!");
        }
        payload.addContent((Content)body);
        root.addContent((Content)payload);
        if (!this.rn.setBetrag(this.xmlBalance.getAmount().roundTo5())) {
            this.rn.reject(RnStatus.REJECTCODE.SUM_MISMATCH, Messages.XMLExporter_SumMismatch);
        } else if (doVerify) {
            new Validator().checkBill(this, (Result<Rechnung>)new Result());
        }
        this.checkXML(xmlRn, dest, this.rn, doVerify);
        if (this.rn.getStatus() != 22) {
            try {
                StringWriter stringWriter = new StringWriter();
                XMLOutputter xout = new XMLOutputter(Format.getCompactFormat());
                xout.output(xmlRn, (Writer)stringWriter);
                NamedBlob blob = NamedBlob.load((String)(PREFIX + this.rn.getNr()));
                blob.putString(stringWriter.toString());
                if (dest != null) {
                    this.writeFile(xmlRn, dest);
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.alert((String)Messages.XMLExporter_ErrorCaption, (String)MessageFormat.format(Messages.XMLExporter_CouldNotWriteFile, dest));
                return null;
            }
        }
        return xmlRn;
    }

    private Document updateExistingXmlBill(Rechnung rechnung, String dest, IRnOutputter.TYPE type, boolean doVerify) {
        Document ret;
        NamedBlob blob;
        block16: {
            blob = NamedBlob.load((String)(PREFIX + rechnung.getNr()));
            SAXBuilder builder = new SAXBuilder();
            this.actFall = rechnung.getFall();
            this.actMandant = rechnung.getMandant();
            try {
                ret = builder.build((Reader)new StringReader(blob.getString()));
                Element root = ret.getRootElement();
                if (XMLExporter.getXmlVersion(root).equals("4.0")) {
                    this.updateExisting4Xml(root, type, rechnung);
                    break block16;
                }
                if (XMLExporter.getXmlVersion(root).equals("4.4")) {
                    this.updateExisting44Xml(root, type, rechnung);
                    int status = rechnung.getStatus();
                    if (status == 6 || status == 7) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m1.xml");
                        }
                        this.addReminderEntry(root, rechnung, "1");
                    } else if (status == 8 || status == 9) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m2.xml");
                        }
                        this.addReminderEntry(root, rechnung, "2");
                    } else if (status == 10 || status == 11) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m3.xml");
                        }
                        this.addReminderEntry(root, rechnung, "3");
                    }
                    break block16;
                }
                logger.warn("Bill in unknown XML version " + XMLExporter.getXmlVersion(root) + ", recreating bill.");
                return null;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.XMLExporter_ReadErrorCaption, (String)Messages.XMLExporter_ReadErrorText);
                return null;
            }
        }
        this.checkXML(ret, dest, this.rn, doVerify);
        if (dest != null) {
            if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
                this.writeFile(ret, dest.toLowerCase().replaceFirst("\\.xml$", "_storno.xml"));
            } else {
                this.writeFile(ret, dest);
            }
        }
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xout = new XMLOutputter(Format.getCompactFormat());
        xout.output(ret, (Writer)stringWriter);
        blob.putString(stringWriter.toString());
        return ret;
    }

    private void addReminderEntry(Element root, Rechnung rechnung, String reminderLevel) {
        boolean firstReminder = false;
        Element payload = root.getChild(ELEMENT_PAYLOAD, nsinvoice);
        payload.setAttribute(ATTR_PAYLOAD_TYPE, ELEMENT_REMINDER);
        TimeTool tt = new TimeTool(new Date());
        String timestamp = Long.toString(tt.getTimeInMillis() / 1000L);
        String dateString = String.valueOf(tt.toString(6)) + "T00:00:00";
        Element reminder = payload.getChild(ELEMENT_REMINDER, nsinvoice);
        if (reminder == null) {
            reminder = new Element(ELEMENT_REMINDER, nsinvoice);
            firstReminder = true;
        }
        reminder.setAttribute(ATTR_REQUEST_TIMESTAMP, timestamp);
        reminder.setAttribute(ATTR_REQUEST_DATE, dateString);
        reminder.setAttribute(ATTR_REQUEST_ID, rechnung.getRnId());
        reminder.setAttribute(ATTR_REMINDER_LEVEL, reminderLevel);
        Element body = payload.getChild(ELEMENT_BODY, nsinvoice);
        if (body != null) {
            Element balance = body.getChild(ELEMENT_BALANCE, nsinvoice);
            Money amountReminder = rechnung.getRemindersBetrag();
            balance.setAttribute(ATTR_AMOUNT_REMINDER, XMLTool.moneyToXmlDouble((Money)amountReminder));
            Money mDue = new Money(rechnung.getBetrag());
            mDue.addMoney(amountReminder);
            mDue.subtractMoney(rechnung.getAnzahlung());
            balance.setAttribute(ATTR_AMOUNT_DUE, XMLTool.moneyToXmlDouble((Money)mDue));
        }
        if (firstReminder) {
            List children = payload.getChildren();
            ArrayList<Element> newChildren = new ArrayList<Element>();
            int i = 0;
            while (i < children.size()) {
                newChildren.add((Element)children.get(i));
                if (((Element)children.get(i)).getName().equals(ELEMENT_INVOICE)) {
                    newChildren.add(reminder);
                }
                ++i;
            }
            payload.removeContent();
            payload.setContent(newChildren);
        }
    }

    private void updateExisting44Xml(Element root, IRnOutputter.TYPE type, Rechnung rechnung) {
        Element guarantorUpdate;
        Kontakt guarantorContact;
        Element patientUpdate;
        Element payload;
        Element body;
        Element tiersGarant;
        Money mPaid = this.rn.getAnzahlung();
        Element processing = root.getChild("processing", nsinvoice);
        String intermediatePrint = processing.getAttributeValue("print_at_intermediate");
        if (("1".equals(intermediatePrint) || "true".equals(intermediatePrint)) && !this.isPrintAtIntermediate()) {
            processing.setAttribute("print_at_intermediate", "0");
        } else if (("0".equals(intermediatePrint) || "false".equals(intermediatePrint)) && this.isPrintAtIntermediate()) {
            processing.setAttribute("print_at_intermediate", "1");
        }
        Element transport = processing.getChild("transport", nsinvoice);
        if (transport != null) {
            Element via = transport.getChild("via", nsinvoice);
            String iEAN = XMLExporterProcessing.getIntermediateEAN(rechnung, this);
            if (iEAN != null && !iEAN.isEmpty()) {
                via.setAttribute("via", iEAN);
            }
        }
        if ((tiersGarant = (body = (payload = root.getChild(ELEMENT_PAYLOAD, nsinvoice)).getChild(ELEMENT_BODY, nsinvoice)).getChild(ELEMENT_TIERS_GARANT, nsinvoice)) != null && this.actFall.getPatient() != null && (patientUpdate = this.buildPatient(this.actFall.getPatient())) != null) {
            ArrayList existing = new ArrayList(tiersGarant.getChildren("patient", nsinvoice));
            for (Element element : existing) {
                tiersGarant.removeContent((Content)element);
            }
            tiersGarant.addContent((Content)patientUpdate);
        }
        if (tiersGarant != null && (guarantorContact = XMLExporterTiers.getGuarantor(TIERS_GARANT, this.actPatient, this.actFall)) != null && (guarantorUpdate = this.buildGuarantor(guarantorContact, (Kontakt)this.actPatient)) != null) {
            ArrayList existing = new ArrayList(tiersGarant.getChildren("guarantor", nsinvoice));
            for (Element element : existing) {
                tiersGarant.removeContent((Content)element);
            }
            tiersGarant.addContent((Content)guarantorUpdate);
        }
        Element balance = body.getChild(ELEMENT_BALANCE, nsinvoice);
        XMLExporterBalance xmlBalance = new XMLExporterBalance(balance);
        this.tryToFixPrepaid(xmlBalance, mPaid);
        if (!mPaid.equals((Object)xmlBalance.getPrepaid())) {
            xmlBalance.setPrepaid(mPaid);
            Money mDue = xmlBalance.getAmount();
            mDue.addMoney(xmlBalance.getReminder());
            mDue.subtractMoney(mPaid);
            mDue.roundTo5();
            xmlBalance.setDue(mDue);
        }
        payload.setAttribute(ATTR_PAYLOAD_COPY, type.equals((Object)IRnOutputter.TYPE.COPY) ? "1" : "0");
        if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            payload.setAttribute(ATTR_PAYLOAD_STORNO, Boolean.toString(true));
            Element services = body.getChild("services", nsinvoice);
            XMLExporterServices xmlServices = new XMLExporterServices(services);
            xmlServices.negateAll();
            xmlBalance.negateAmount();
            xmlBalance.negateAmountObligations();
            xmlBalance.setDue(new Money());
            xmlBalance.setPrepaid(new Money());
        }
    }

    private void tryToFixPrepaid(XMLExporterBalance xmlBalance, Money mPaid) {
        if (!xmlBalance.hasPrepaid()) {
            xmlBalance.setPrepaid(mPaid);
        }
        Money xmlAmount = xmlBalance.getAmount();
        Money xmlDue = xmlBalance.getDue();
        Money xmlPrepaid = xmlBalance.getPrepaid();
        Money xmlReminder = xmlBalance.getReminder();
        double diffDouble = xmlAmount.doubleValue() + xmlReminder.doubleValue() - (xmlPrepaid.doubleValue() + xmlDue.doubleValue());
        if (Math.abs(diffDouble) > 1.0) {
            xmlBalance.setDue(new Money(xmlAmount.doubleValue() + xmlReminder.doubleValue() - xmlPrepaid.doubleValue()).roundTo5());
        }
    }

    private void updateExisting4Xml(Element root, IRnOutputter.TYPE type, Rechnung rechnung) {
        Namespace namespace = Namespace.getNamespace((String)"http://www.xmlData.ch/xmlInvoice/XSD");
        Money mPaid = this.rn.getAnzahlung();
        Element invoice = root.getChild(ELEMENT_INVOICE, namespace);
        this.fixCanton(invoice, namespace);
        Element balance = invoice.getChild(ELEMENT_BALANCE, namespace);
        Money anzInBill = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue(ATTR_AMOUNT_PREPAID));
        if (!mPaid.equals((Object)anzInBill)) {
            Money mAmount = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue(ATTR_AMOUNT));
            if (mPaid.isMoreThan(mAmount)) {
                mPaid = mAmount;
            }
            balance.setAttribute(ATTR_AMOUNT_PREPAID, XMLTool.moneyToXmlDouble((Money)mPaid));
            Money mDue = new Money(mAmount).subtractMoney(mPaid).roundTo5();
            balance.setAttribute(ATTR_AMOUNT_DUE, XMLTool.moneyToXmlDouble((Money)mDue));
        }
        if (type.equals((Object)IRnOutputter.TYPE.COPY)) {
            invoice.setAttribute("resend", Boolean.toString(true));
        } else if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            Element detail = invoice.getChild("detail", namespace);
            Element services = detail.getChild("services", namespace);
            List sr = services.getChildren();
            for (Element el : sr) {
                try {
                    this.negate(el, ATTR_QUANTITY);
                    this.negate(el, "amount.mt");
                    this.negate(el, "amount.tt");
                    this.negate(el, ATTR_AMOUNT);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
            this.negate(balance, ATTR_AMOUNT);
            this.negate(balance, ATTR_AMOUNT_TARMED);
            this.negate(balance, ATTR_AMOUNT_TARMED_MT);
            this.negate(balance, ATTR_AMOUNT_TARMED_TT);
            this.negate(balance, ATTR_AMOUNT_CANTONAL);
            this.negate(balance, ATTR_AMOUNT_UNCLASSIFIED);
            this.negate(balance, ATTR_AMOUNT_DRUG);
            this.negate(balance, ATTR_AMOUNT_LAB);
            this.negate(balance, ATTR_AMOUNT_MIGEL);
            this.negate(balance, ATTR_AMOUNT_PHYSIO);
            this.negate(balance, "amount_obligations");
            balance.setAttribute(ATTR_AMOUNT_DUE, "0.00");
            balance.setAttribute(ATTR_AMOUNT_PREPAID, "0.00");
            Element payant = invoice.getChild(ELEMENT_TIERS_PAYANT);
            if (payant != null) {
                payant.setAttribute("purpose", ELEMENT_ANNULMENT);
            }
        }
    }

    private void fixCanton(Element invoice, Namespace namespace) {
        Element detail = invoice.getChild("detail", namespace);
        String canton = detail.getAttributeValue("canton", namespace);
        if (canton == null || canton.isEmpty()) {
            detail.setAttribute("canton", "AG");
        }
    }

    public static String getXmlVersion(Element root) {
        String location = root.getAttributeValue("schemaLocation", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        if (location != null && !location.isEmpty()) {
            if (location.contains("InvoiceRequest_400")) {
                return "4.0";
            }
            if (location.contains("InvoiceRequest_440")) {
                return "4.4";
            }
        }
        return location;
    }

    private boolean xmlBillExists(Rechnung rechnung) {
        return NamedBlob.exists((String)(PREFIX + rechnung.getNr()));
    }

    protected Element buildGuarantor(Kontakt garant, Kontakt patient) {
        Element guarantor = new Element("guarantor", nsinvoice);
        guarantor.addContent((Content)XMLExporterUtil.buildAdressElement(garant));
        return guarantor;
    }

    protected Element buildPatient(Patient patient) {
        Element patientElement = new Element("patient", nsinvoice);
        String gender = "male";
        if (patient == null) {
            MessageDialog.openError(null, (String)Messages.XMLExporter_ErrorCaption, (String)Messages.XMLExporter_NoPatientText);
            return null;
        }
        if (StringTool.isNothing((Object)patient.getGeschlecht())) {
            patient.set("Geschlecht", "w");
        }
        if (patient.getGeschlecht().equals("w")) {
            gender = "female";
        }
        patientElement.setAttribute("gender", gender);
        String gebDat = patient.getGeburtsdatum();
        if (StringTool.isNothing((Object)gebDat)) {
            patientElement.setAttribute(ATTR_BIRTHDATE, "0001-00-00T00:00:00");
        } else {
            patientElement.setAttribute(ATTR_BIRTHDATE, String.valueOf(new TimeTool(patient.getGeburtsdatum()).toString(6)) + "T00:00:00");
        }
        patientElement.addContent((Content)XMLExporterUtil.buildAdressElement((Kontakt)patient));
        if (StringUtils.isNotBlank((String)((String)this.actFall.getExtInfoStoredObjectByKey((Object)"VEKANr"))) && StringUtils.isNotBlank((String)((String)this.actFall.getExtInfoStoredObjectByKey((Object)"VEKAValid")))) {
            Element cardElement = new Element("card", nsinvoice);
            cardElement.setAttribute("card_id", (String)this.actFall.getExtInfoStoredObjectByKey((Object)"VEKANr"));
            cardElement.setAttribute("expiry_date", XMLExporterUtil.makeTarmedDatum((String)this.actFall.getExtInfoStoredObjectByKey((Object)"VEKAValid")));
            patientElement.addContent((Content)cardElement);
        }
        return patientElement;
    }

    public String getDescription() {
        return Messages.XMLExporter_TarmedForTrustCenter;
    }

    protected void checkXML(Document xmlDoc, String dest, Rechnung rn, boolean doVerify) {
        if (CoreHub.userCfg.get("billing/strict", true)) {
            JDOMSource source = new JDOMSource(xmlDoc);
            String path = String.valueOf(PlatformHelper.getBasePath((String)"ch.elexis.base.ch.arzttarife")) + File.separator + "rsc";
            List errs = null;
            if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("4.0")) {
                logger.info("Validating XML against MDInvoiceRequest_400.xsd");
                errs = XMLTool.validateSchema((String)(String.valueOf(path) + File.separator + "MDInvoiceRequest_400.xsd"), (Source)source);
            } else if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("4.4")) {
                logger.info("Validating XML against generalInvoiceRequest_440.xsd");
                errs = XMLTool.validateSchema((String)(String.valueOf(path) + File.separator + "generalInvoiceRequest_440.xsd"), (Source)source);
            } else {
                errs = Collections.singletonList("Bill in unknown XML version " + XMLExporter.getXmlVersion(xmlDoc.getRootElement()));
            }
            if (!errs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String err : errs) {
                    sb.append(err).append("\n");
                }
                logger.error(sb.toString());
                rn.reject(RnStatus.REJECTCODE.VALIDATION_ERROR, sb.toString());
                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                StringWriter sw = new StringWriter();
                try {
                    xout.output(xmlDoc, (Writer)sw);
                }
                catch (IOException e) {
                    logger.error("Failed getting document as String.", (Throwable)e);
                    return;
                }
                logger.debug(sw.toString());
            }
        }
    }

    public Control createSettingsControl(Object parent) {
        final Composite parentInc = (Composite)parent;
        Composite ret = new Composite(parentInc, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(ret, 0);
        l.setText(Messages.XMLExporter_PleaseEnterOutputDirectoryForBills);
        l.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        final Text text = new Text(ret, 2056);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Button b = new Button(ret, 8);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLExporter.this.outputDir = new DirectoryDialog(parentInc.getShell(), 4096).open();
                CoreHub.localCfg.set("TarmedExport_Directory", XMLExporter.this.outputDir);
                text.setText(XMLExporter.this.outputDir);
            }
        });
        b.setText(Messages.XMLExporter_Change);
        this.outputDir = CoreHub.localCfg.get("TarmedExport_Directory", CorePreferenceInitializer.getDefaultDBPath());
        text.setText(this.outputDir);
        return ret;
    }

    protected void writeFile(Document doc, String dest) throws IOException {
        FileOutputStream fout = new FileOutputStream(dest);
        OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (Writer)cout);
        cout.close();
        fout.close();
        int status_vorher = this.rn.getStatus();
        if (status_vorher == 4 || status_vorher == 6 || status_vorher == 8 || status_vorher == 10) {
            this.rn.setStatus(status_vorher + 1);
        }
        this.rn.addTrace("Ausgegeben", String.valueOf(this.getDescription()) + ": " + RnStatus.getStatusText((int)this.rn.getStatus()));
    }

    public boolean canBill(Fall fall) {
        Kontakt garant = fall.getGarant();
        Kontakt kostentraeger = fall.getCostBearer();
        return garant != null && kostentraeger != null && garant.isValid() && kostentraeger.isValid() && kostentraeger.istOrganisation();
    }

    public void saveComposite() {
    }

    protected String getIntermediateEAN(Fall fall) {
        String trustCenter;
        String iEAN = TarmedRequirements.getIntermediateEAN(this.actFall);
        if (iEAN.length() == 0 && TarmedRequirements.hasTCContract((Kontakt)this.actMandant) && (trustCenter = TarmedRequirements.getTCName((Kontakt)this.actMandant)).length() > 0) {
            iEAN = TrustCenters.getTCEAN(trustCenter);
        }
        return iEAN;
    }

    protected String getSenderEAN(Mandant actMandant) {
        return TarmedRequirements.getEAN((Kontakt)actMandant);
    }

    private void initBalanceData(Rechnung rechnung, XMLExporterServices services, VatRateSum vatSummer) {
        this.xmlBalance = XMLExporterBalance.buildBalance(rechnung, services, vatSummer, this);
        this.besr = new ESR(this.actMandant.getRechnungssteller().getInfoString(XMLExporter.ta.ESRNUMBER), this.actMandant.getRechnungssteller().getInfoString(XMLExporter.ta.ESRSUB), rechnung.getRnId(), 27);
    }

    public ESR getBesr() {
        return this.besr;
    }

    public Money getDueMoney() {
        return this.xmlBalance.getDue();
    }

    public List<IDiagnose> getDiagnoses() {
        return this.xmlTreatment.getDiagnoses();
    }

    protected String getRole(Fall fall) {
        return "production";
    }

    class VatRateSum {
        HashMap<Double, VatRateElement> rates = new HashMap();
        double sumvat = 0.0;

        VatRateSum() {
        }

        public void add(double scale, double amount) {
            VatRateElement element = this.rates.get(scale);
            if (element == null) {
                element = new VatRateElement(scale);
                this.rates.put(new Double(scale), element);
            }
            element.add(amount);
            this.sumvat += amount / (100.0 + scale) * scale;
        }

        class VatRateElement
        implements Comparable<VatRateElement> {
            double scale;
            double sumamount;
            double sumvat;

            VatRateElement(double scale) {
                this.scale = scale;
                this.sumamount = 0.0;
                this.sumvat = 0.0;
            }

            void add(double amount) {
                this.sumamount += amount;
                this.sumvat += amount / (100.0 + this.scale) * this.scale;
            }

            @Override
            public int compareTo(VatRateElement other) {
                if (this.scale < other.scale) {
                    return -1;
                }
                if (this.scale > other.scale) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

