/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;

public class Validator {
    public Result<Rechnung> checkBill(XMLExporter xp, Result<Rechnung> res) {
        String bez;
        Kontakt kostentraeger;
        String ean;
        Fall fall;
        Rechnung rn = xp.rn;
        Mandant m = rn.getMandant();
        if (rn.getStatus() > 4) {
            return res;
        }
        if (m == null || !m.isValid()) {
            rn.reject(RnStatus.REJECTCODE.NO_MANDATOR, Messages.Validator_NoMandator);
            res.add(Result.SEVERITY.ERROR, 2, Messages.Validator_NoMandator, (Object)rn, true);
        }
        if ((fall = rn.getFall()) == null || !fall.isValid()) {
            rn.reject(RnStatus.REJECTCODE.NO_CASE, Messages.Validator_NoCase);
            res.add(Result.SEVERITY.ERROR, 4, Messages.Validator_NoCase, (Object)rn, true);
        }
        if (StringTool.isNothing((Object)(ean = TarmedRequirements.getEAN((Kontakt)m)))) {
            rn.reject(RnStatus.REJECTCODE.NO_MANDATOR, Messages.Validator_NoEAN);
            res.add(Result.SEVERITY.ERROR, 3, Messages.Validator_NoEAN, (Object)rn, true);
        }
        if (xp.getDiagnoses().isEmpty()) {
            rn.reject(RnStatus.REJECTCODE.NO_DIAG, Messages.Validator_NoDiagnosis);
            res.add(Result.SEVERITY.ERROR, 8, Messages.Validator_NoDiagnosis, (Object)rn, true);
        }
        Kontakt kontakt = kostentraeger = fall != null ? fall.getCostBearer() : null;
        if (kostentraeger == null && xp.tiers != null && xp.tiers.equals("TG")) {
            return res;
        }
        if (kostentraeger == null) {
            rn.reject(RnStatus.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)rn, true);
            return res;
        }
        ean = TarmedRequirements.getEAN(kostentraeger);
        if (StringTool.isNothing((Object)ean) || !ean.matches("[0-9]{13}")) {
            rn.reject(RnStatus.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoEAN2);
            res.add(Result.SEVERITY.ERROR, 6, Messages.Validator_NoEAN2, (Object)rn, true);
        }
        if (StringTool.isNothing((Object)(bez = kostentraeger.get("Bezeichnung1")))) {
            rn.reject(RnStatus.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)rn, true);
        }
        return res;
    }
}

