/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ResponseAnalyzer {
    static final Namespace ns = Namespace.getNamespace((String)"invoice", (String)"http://www.xmlData.ch/xmlInvoice/XSD");
    static final Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    static final Namespace nsSchema = Namespace.getNamespace((String)"schemaLocation", (String)"http://www.xmlData.ch/xmlInvoice/XSD");
    Document responseDoc;
    Element eRoot;
    private String rnNr;
    private String status;
    private Result<String> resume;
    Rechnung rn;

    public Document load(InputStream xmlResponse) {
        try {
            SAXBuilder builder = new SAXBuilder();
            this.responseDoc = builder.build(xmlResponse);
            this.eRoot = this.responseDoc.getRootElement();
            this.analyze();
            return this.responseDoc;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getRnNr() {
        return this.rnNr;
    }

    public Result<String> getResume() {
        return this.resume;
    }

    private boolean analyze() {
        this.resume = new Result();
        if (this.eRoot == null) {
            return false;
        }
        StringBuilder ret = new StringBuilder();
        Element eHeader = this.eRoot.getChild("header", ns);
        Element eSender = eHeader.getChild("sender", ns);
        Element eIntermediate = eHeader.getChild("intermediate", ns);
        Element eRecipient = eHeader.getChild("recipient", ns);
        ret.append("Sender: ").append(eSender.getAttributeValue("ean_party")).append("\n");
        ret.append(Messages.ResponseAnalyzer_Intermediate).append(eIntermediate.getAttributeValue("ean_party")).append("\n");
        ret.append(Messages.ResponseAnalyzer_Receiver).append(eRecipient.getAttributeValue("ean_party")).append("\n");
        Element eInvoice = this.eRoot.getChild("invoice", ns);
        int tr = -1;
        if (eInvoice != null) {
            String rnId = eInvoice.getAttributeValue("invoice_id");
            tr = rnId.lastIndexOf(48);
            if (tr == -1) {
                this.rnNr = rnId;
            } else {
                String patNr = Integer.toString(Integer.parseInt(rnId.substring(0, tr)));
                this.rnNr = rnId.substring(tr + 1);
            }
        } else {
            this.rnNr = "0";
        }
        this.rn = Rechnung.getFromNr((String)this.rnNr);
        if (this.rn == null) {
            ret.append(Messages.ResponseAnalyzer_BillIsNotKnown);
        } else {
            ret.append(Messages.ResponseAnalyzer_BillNumber).append(this.rnNr).append("\n");
            ret.append(Messages.ResponseAnalyzer_Patient).append(this.rn.getFall().getPatient().getLabel()).append("\n");
            ret.append(Messages.ResponseAnalyzer_Date).append(this.rn.getDatumRn()).append("\n----------------------\n");
        }
        ret.append(Messages.ResponseAnalyzer_State);
        Element eStatus = this.eRoot.getChild(Messages.ResponseAnalyzer_State2, ns);
        List lStatus = eStatus.getChildren();
        if (lStatus.size() != 1) {
            ret.append(Messages.ResponseAnalyzer_NotDeclaredCorrectly);
        } else {
            Element eStatusType = (Element)lStatus.get(0);
            Element eError = eStatusType.getChild("error", ns);
            Element eExpl = eStatusType.getChild("explanation", ns);
            String explanation = "Keine Erl\u00e4uterung angegeben";
            if (eExpl != null) {
                explanation = eExpl.getText();
            }
            this.status = eStatusType.getName().toLowerCase();
            if (this.status.equals("rejected")) {
                ret.append(Messages.ResponseAnalyzer_StateRejected).append(explanation).append("\n");
                if (eError != null) {
                    ret.append(Messages.ResponseAnalyzer_ErrorCode);
                    ret.append(eError.getAttributeValue("major")).append(".");
                    ret.append(eError.getAttributeValue("minor")).append("->");
                    ret.append(eError.getAttributeValue("error")).append("\n");
                }
                this.resume.add(new Result(Result.SEVERITY.ERROR, 1, "Rejected", (Object)ret.toString(), true));
                this.rn.reject(RnStatus.REJECTCODE.REJECTED_BY_PEER, explanation);
            } else if (this.status.equals("calledin")) {
                ret.append(Messages.ResponseAnalyzer_MoreInformationsRequested).append(explanation).append("\n");
                if (eError != null) {
                    ret.append(Messages.ResponseAnalyzer_Code).append(eError.getAttributeValue("major"));
                }
            } else if (this.status.equals("pending")) {
                ret.append(Messages.ResponseAnalyzer_Pending).append(explanation).append("\n");
            } else if (this.status.equals("resend")) {
                ret.append(Messages.ResponseAnalyzer_PleaseResend).append(explanation).append(Messages.ResponseAnalyzer_56);
            } else if (this.status.equals(Messages.ResponseAnalyzer_57)) {
                ret.append(Messages.ResponseAnalyzer_58).append(explanation).append(Messages.ResponseAnalyzer_59);
                if (eError != null) {
                    ret.append(Messages.ResponseAnalyzer_60);
                    ret.append(eError.getAttributeValue(Messages.ResponseAnalyzer_61)).append(Messages.ResponseAnalyzer_62).append(eError.getAttributeValue(Messages.ResponseAnalyzer_63)).append(Messages.ResponseAnalyzer_64).append(eError.getAttributeValue(Messages.ResponseAnalyzer_65)).append(Messages.ResponseAnalyzer_66);
                }
            } else if (this.status.equals(Messages.ResponseAnalyzer_67)) {
                ret.append(Messages.ResponseAnalyzer_68).append(explanation).append(Messages.ResponseAnalyzer_69);
                List reasons = eStatusType.getChildren();
                Element eReason = (Element)reasons.get(0);
                ret.append(eReason.getName()).append(Messages.ResponseAnalyzer_70);
            } else if (this.status.equals(Messages.ResponseAnalyzer_71)) {
                ret.append(Messages.ResponseAnalyzer_72).append(explanation).append(Messages.ResponseAnalyzer_73);
                Element eAnswer = (Element)eStatusType.getChildren().get(0);
                ret.append(eAnswer.getName()).append(Messages.ResponseAnalyzer_74);
            } else {
                ret.append(Messages.ResponseAnalyzer_75);
            }
        }
        this.resume = new Result((Object)ret.toString());
        return true;
    }
}

