/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.views.ComplementaryPrintView;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ComplementaryDrucker
implements IRnOutputter {
    TarmedACL ta = TarmedACL.getInstance();
    ComplementaryPrintView rnp;
    IWorkbenchPage rnPage;
    private Button bESR;
    private Button bForms;
    private Button bIgnoreFaults;
    private Button bSaveFileAs;
    String dirname = CoreHub.localCfg.get("TarmedExport_Directory", null);
    Text tName;
    private boolean bESRSelected;
    private boolean bFormsSelected;
    private boolean bIgnoreFaultsSelected;
    private boolean bSaveFileAsSelected;

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rechnungen, Properties props) {
        this.rnPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final Result res = new Result();
        try {
            this.rnp = (ComplementaryPrintView)this.rnPage.showView("ch.elexis.arzttarife_ch.complementaryprintview");
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.RechnungsDrucker_PrintingBills, rechnungen.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rechnungen) {
                        try {
                            if (!ComplementaryDrucker.this.rnp.doPrint(rn, type, ComplementaryDrucker.this.bSaveFileAsSelected ? String.valueOf(ComplementaryDrucker.this.dirname) + File.separator + rn.getNr() + ".xml" : null, ComplementaryDrucker.this.bESRSelected, ComplementaryDrucker.this.bFormsSelected, !ComplementaryDrucker.this.bIgnoreFaultsSelected, monitor)) {
                                String errms = String.valueOf(Messages.RechnungsDrucker_TheBill) + rn.getNr() + Messages.RechnungsDrucker_Couldntbeprintef;
                                res.add(Result.SEVERITY.ERROR, 1, errms, (Object)rn, true);
                                ++errors;
                                continue;
                            }
                            int status_vorher = rn.getStatus();
                            if (status_vorher == 4 || status_vorher == 6 || status_vorher == 8 || status_vorher == 10) {
                                rn.setStatus(status_vorher + 1);
                            }
                            rn.addTrace("Ausgegeben", String.valueOf(ComplementaryDrucker.this.getDescription()) + ": " + RnStatus.getStatusText((int)rn.getStatus()));
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            String msg = ex.getMessage();
                            if (msg == null) {
                                msg = Messages.RechnungsDrucker_MessageErrorInternal;
                            }
                            SWTHelper.showError((String)(String.valueOf(Messages.RechnungsDrucker_MessageErrorWhilePrinting) + rn.getNr()), (String)msg);
                            ++errors;
                        }
                    }
                    monitor.done();
                    if (errors == 0) {
                        SWTHelper.showInfo((String)Messages.RechnungsDrucker_PrintingFinished, (String)Messages.RechnungsDrucker_AllFinishedNoErrors);
                    } else {
                        SWTHelper.showError((String)Messages.RechnungsDrucker_ErrorsWhilePrinting, (String)(String.valueOf(Integer.toString(errors)) + Messages.RechnungsDrucker_ErrorsWhiilePrintingAdvice));
                    }
                }
            }, null);
            this.rnPage.hideView((IViewPart)this.rnp);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            ErrorDialog.openError(null, (String)Messages.RechnungsDrucker_ErrorsWhilePrinting, (String)Messages.RechnungsDrucker_CouldntOpenPrintView, (IStatus)ResultAdapter.getResultAsStatus((Result)res));
            return res;
        }
        return res;
    }

    public String getDescription() {
        return "Als Komplement\u00e4r-Rechnung ausdrucken";
    }

    public Control createSettingsControl(Object parent) {
        final Composite parentInc = (Composite)parent;
        Composite ret = new Composite(parentInc, 0);
        ret.setLayout((Layout)new GridLayout());
        this.bESR = new Button(ret, 32);
        this.bForms = new Button(ret, 32);
        this.bESR.setText(Messages.RechnungsDrucker_WithESR);
        this.bESR.setSelection(true);
        this.bForms.setText(Messages.RechnungsDrucker_WithForm);
        this.bForms.setSelection(true);
        this.bIgnoreFaults = new Button(ret, 32);
        this.bIgnoreFaults.setText(Messages.RechnungsDrucker_IgnoreFaults);
        this.bIgnoreFaults.setSelection(CoreHub.localCfg.get("TarmedRnn_relaxed", true));
        this.bIgnoreFaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("TarmedRnn_relaxed", ComplementaryDrucker.this.bIgnoreFaults.getSelection());
            }
        });
        Group cSaveCopy = new Group(ret, 0);
        cSaveCopy.setText(Messages.RechnungsDrucker_FileForTrustCenter);
        cSaveCopy.setLayout((Layout)new GridLayout(2, false));
        this.bSaveFileAs = new Button((Composite)cSaveCopy, 32);
        this.bSaveFileAs.setText(Messages.RechnungsDrucker_AskSaveForTrustCenter);
        this.bSaveFileAs.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bSaveFileAs.setSelection(CoreHub.localCfg.get("TarmedRnn_Savecopy", false));
        this.bSaveFileAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("TarmedRnn_Savecopy", ComplementaryDrucker.this.bSaveFileAs.getSelection());
            }
        });
        Button bSelectFile = new Button((Composite)cSaveCopy, 8);
        bSelectFile.setText(Messages.RechnungsDrucker_Directory);
        bSelectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog ddlg = new DirectoryDialog(parentInc.getShell());
                ComplementaryDrucker.this.dirname = ddlg.open();
                if (ComplementaryDrucker.this.dirname == null) {
                    SWTHelper.alert((String)Messages.RechnungsDrucker_DirNameMissingCaption, (String)Messages.RechnungsDrucker_DirnameMissingText);
                } else {
                    CoreHub.localCfg.set("TarmedExport_Directory", ComplementaryDrucker.this.dirname);
                    ComplementaryDrucker.this.tName.setText(ComplementaryDrucker.this.dirname);
                }
            }
        });
        this.tName = new Text((Composite)cSaveCopy, 2056);
        this.tName.setText(CoreHub.localCfg.get("TarmedExport_Directory", ""));
        return ret;
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public boolean canBill(Fall fall) {
        return true;
    }

    public void saveComposite() {
        this.bESRSelected = this.bESR.getSelection();
        this.bFormsSelected = this.bForms.getSelection();
        this.bIgnoreFaultsSelected = this.bIgnoreFaults.getSelection();
        this.bSaveFileAsSelected = this.bSaveFileAs.getSelection();
    }
}

