/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.artikel_ch.data;

import ch.elexis.artikel_ch.data.Medical;
import ch.elexis.artikel_ch.data.Medikament;
import ch.elexis.base.ch.artikel.Messages;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class MedikamentImporter
extends ImporterPage {
    public static final String MWST_TYP = "MWSt-Typ";
    private static final String HERSTELLER = "Hersteller";
    private static final String LAGERART = "Lagerart";
    public static final String KASSENTYP = "Kassentyp";
    private static final String EMPTY_PHARMACODE = "0000000";
    static final String MEDIKAMENT = "Medikament";
    static final String MEDICAL = "Medical";

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String in;
        File file = new File(this.results[0]);
        long l = file.length();
        InputStreamReader ir = new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1");
        BufferedReader br = new BufferedReader(ir);
        String mode = Messages.MedikamentImporter_ModeOfImport;
        monitor.beginTask(String.valueOf(Messages.MedikamentImporter_MedikamentImportTitle) + mode, (int)(l / 100L));
        Query qbe = new Query(Artikel.class);
        int counter = 0;
        int createdCount = 0;
        int updatedCount = 0;
        int lineNo = 0;
        while ((in = br.readLine()) != null) {
            String cmws;
            String kasse;
            String vk;
            String ek;
            Artikel a;
            ++lineNo;
            String reca = new String(in.substring(0, 2));
            String cmut = new String(in.substring(2, 3));
            String phar = new String(in.substring(3, 10));
            String ean = new String(in.substring(83, 96));
            String eanCode = null;
            String pk = null;
            try {
                long pkl = Long.parseLong(phar);
                if (pkl > 0L) {
                    pk = Long.toString(pkl);
                }
            }
            catch (NumberFormatException pkl) {
                // empty catch block
            }
            try {
                long eank = Long.parseLong(ean);
                if (eank > 0L) {
                    eanCode = Long.toString(eank);
                }
            }
            catch (NumberFormatException eank) {
                // empty catch block
            }
            if (pk == null && eanCode == null) {
                this.log.log(String.valueOf(Messages.MedikamentImporter_BadArticleEntry) + lineNo, 2);
                continue;
            }
            qbe.clear();
            if (pk != null) {
                qbe.add("SubID", "=", pk);
                qbe.or();
                qbe.add("SubID", "=", phar);
            } else {
                qbe.add("EAN", "=", ean);
                qbe.or();
                qbe.add("EAN", "=", eanCode);
            }
            List lArt = qbe.execute();
            if (lArt.size() > 1) {
                Iterator it = lArt.iterator();
                boolean hasValid = false;
                while (it.hasNext()) {
                    Artikel ax = (Artikel)it.next();
                    if (hasValid || !ax.isValid()) {
                        it.remove();
                        continue;
                    }
                    hasValid = true;
                }
            }
            Artikel artikel = a = lArt.size() > 0 ? (Artikel)lArt.get(0) : null;
            if (a == null || !a.exists()) {
                if (cmut.equals("3") || !reca.equals("11")) {
                    monitor.worked(1);
                    continue;
                }
            } else if (cmut.equals("3")) {
                a.delete();
                monitor.worked(1);
                ++updatedCount;
                continue;
            }
            if (reca.equals("11")) {
                String titel = new String(in.substring(10, 60)).trim();
                ek = new String(in.substring(60, 66)).trim();
                vk = new String(in.substring(66, 72)).trim();
                kasse = new String(in.substring(72, 73));
                String lager = new String(in.substring(73, 75));
                String hix = new String(in.substring(75, 76));
                String ithe = new String(in.substring(76, 83));
                cmws = new String(in.substring(96, 97));
                if (a == null) {
                    if (cmws.equals("1")) {
                        a = new Artikel(titel, MEDICAL, pk == null ? EMPTY_PHARMACODE : pk);
                        a.set("Klasse", Medical.class.getName());
                    } else {
                        a = new Artikel(titel, MEDIKAMENT, pk == null ? EMPTY_PHARMACODE : pk);
                        a.set("Klasse", Medikament.class.getName());
                    }
                    ++createdCount;
                } else {
                    ++updatedCount;
                }
                if (vk.matches("0+")) {
                    a.set("EK_Preis", ek);
                    a.set("EAN", ean);
                } else {
                    String[] fields = new String[]{"EK_Preis", "VK_Preis", "EAN"};
                    a.set(fields, new String[]{ek, vk, ean});
                }
                Map ext = a.getMap("ExtInfo");
                ext.put("Pharmacode", pk == null ? EMPTY_PHARMACODE : pk);
                ext.put(KASSENTYP, kasse);
                ext.put(LAGERART, lager);
                ext.put(HERSTELLER, hix);
                ext.put("EAN", ean);
                ext.put(MWST_TYP, cmws);
                a.setMap("ExtInfo", ext);
            } else if (reca.equals("10")) {
                ek = new String(in.substring(10, 16));
                vk = new String(in.substring(16, 22));
                kasse = new String(in.substring(22, 23));
                cmws = new String(in.substring(23, 24));
                if (vk.matches("0+")) {
                    if (a != null) {
                        a.set("EK_Preis", ek);
                    } else {
                        this.log.log("a is null", 2);
                    }
                } else {
                    String[] fields = new String[]{"EK_Preis", "VK_Preis"};
                    if (a != null) {
                        a.set(fields, new String[]{ek, vk});
                    } else {
                        this.log.log("a is null", 2);
                    }
                }
                ++updatedCount;
            } else {
                SWTHelper.showError((String)Messages.MedikamentImporter_BadFileFormat, (String)Messages.MedikamentImporter_OnlyIGM10AndIGM11);
                return Status.CANCEL_STATUS;
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                monitor.done();
                return Status.CANCEL_STATUS;
            }
            monitor.subTask(a != null ? a.getLabel() : "a is null");
            a = null;
            in = null;
            if (counter++ <= 1000) continue;
            PersistentObject.clearCache();
            System.gc();
            Thread.sleep(100L);
            counter = 0;
        }
        monitor.done();
        SWTHelper.showInfo((String)Messages.MedikamentImporter_SuccessTitel, (String)String.format(Messages.MedikamentImporter_SuccessContent, createdCount, updatedCount));
        return Status.OK_STATUS;
    }

    public String getTitle() {
        return Messages.MedikamentImporter_WindowTitleMedicaments;
    }

    public String getDescription() {
        return Messages.MedikamentImporter_PleaseChoseFile;
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter ret = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return ret;
    }
}

