/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.artikel_ch.data;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Artikel;
import java.util.Map;

public class Medikament
extends Artikel {
    public static final String CODESYSTEM_NAME = "Medikamente";

    protected String getConstraint() {
        return "Typ='Medikament'";
    }

    protected void setConstraint() {
        this.set("Typ", "Medikament");
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCodeSystemCode() {
        return "400";
    }

    public String getLabel() {
        return this.get("Name");
    }

    public String getCode() {
        return this.getPharmaCode();
    }

    public static Medikament load(String id) {
        return new Medikament(id);
    }

    protected Medikament() {
    }

    protected Medikament(String id) {
        super(id);
    }

    public boolean isDragOK() {
        return true;
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        Map info = this.getMap("ExtInfo");
        String typ = (String)info.get("MWSt-Typ");
        if (typ != null && typ.equals("2")) {
            return IVerrechenbar.VatInfo.VAT_CH_ISMEDICAMENT;
        }
        if (typ != null && typ.equals("1")) {
            return IVerrechenbar.VatInfo.VAT_CH_NOTMEDICAMENT;
        }
        if (typ != null && typ.equals("3")) {
            return IVerrechenbar.VatInfo.VAT_NONE;
        }
        return IVerrechenbar.VatInfo.VAT_NONE;
    }
}

