/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.artikel_ch.data;

import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.optifier.NoObligationOptifier;
import ch.elexis.data.Artikel;
import java.util.Map;

public class Medical
extends Artikel {
    public static final String CODESYSTEM_NAME = "Medicals";
    private static IOptifier noObligationOptifier = new NoObligationOptifier();

    protected String getConstraint() {
        return "Typ='Medical'";
    }

    protected void setConstraint() {
        this.set("Typ", "Medical");
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCodeSystemCode() {
        return "400";
    }

    public String getCode() {
        return this.getPharmaCode();
    }

    public static Medical load(String id) {
        return new Medical(id);
    }

    protected Medical(String id) {
        super(id);
    }

    protected Medical() {
    }

    public boolean isDragOK() {
        return true;
    }

    public String getLabel() {
        return this.get("Name");
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        Map info = this.getMap("ExtInfo");
        String typ = (String)info.get("MWSt-Typ");
        if (typ != null && typ.equals("2")) {
            return IVerrechenbar.VatInfo.VAT_CH_ISMEDICAMENT;
        }
        if (typ != null && typ.equals("1")) {
            return IVerrechenbar.VatInfo.VAT_CH_NOTMEDICAMENT;
        }
        if (typ != null && typ.equals("3")) {
            return IVerrechenbar.VatInfo.VAT_NONE;
        }
        return IVerrechenbar.VatInfo.VAT_NONE;
    }

    public IOptifier getOptifier() {
        return noObligationOptifier;
    }
}

