/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.strategy;

import ch.elexis.base.befunde.findings.migrator.messwert.MesswertFieldMapping;
import ch.elexis.base.befunde.findings.migrator.strategy.AbstractMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.IMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.NumericMigration;
import ch.elexis.base.befunde.findings.migrator.strategy.TextMigration;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.data.Patient;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMigration
extends AbstractMigrationStrategy
implements IMigrationStrategy {
    private static Logger logger = LoggerFactory.getLogger(ComponentMigration.class);
    private MesswertFieldMapping mapping;
    private Messwert messwert;
    private List<IObservation> createdObservations;
    private String componentGrpCode;
    private String componentCode;

    public ComponentMigration(MesswertFieldMapping mapping, Messwert messwert, List<IObservation> createdObservations) {
        this.mapping = mapping;
        this.messwert = messwert;
        this.createdObservations = createdObservations;
        String code = mapping.getFindingsCode();
        String[] parts = code.split("\\.");
        if (parts.length == 2) {
            this.componentGrpCode = parts[0];
            this.componentCode = parts[1];
        } else if (parts.length == 1) {
            this.componentGrpCode = parts[0];
            this.componentCode = null;
        }
    }

    @Override
    public Optional<IObservation> migrate() {
        IObservation observation = this.getOrCreateObservation();
        if (observation != null) {
            boolean valueSet = false;
            if (this.componentCode != null) {
                List components = observation.getComponents();
                for (ObservationComponent observationComponent : components) {
                    if (!ModelUtil.isCodeInList((String)CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), (String)this.componentCode, (List)observationComponent.getCoding())) continue;
                    valueSet = this.setValue(observationComponent);
                    observation.updateComponent(observationComponent);
                    break;
                }
            } else {
                valueSet = this.setValues(observation);
            }
            if (valueSet) {
                return Optional.of(observation);
            }
        }
        return Optional.empty();
    }

    private boolean setValues(IObservation observation) {
        List components = observation.getComponents();
        IObservation.ObservationType type = this.getComponentsType(components);
        if (type != null) {
            if (type == IObservation.ObservationType.NUMERIC) {
                int valuesSet = 0;
                String result = this.messwert.getResult(this.mapping.getLocalBefundField());
                List<BigDecimal> values = NumericMigration.getValues(result);
                int i = 0;
                while (i < components.size()) {
                    ObservationComponent component;
                    IObservation.ObservationType componentType;
                    if (i < values.size() && (componentType = (IObservation.ObservationType)(component = (ObservationComponent)components.get(i)).getTypeFromExtension(IObservation.ObservationType.class)) == IObservation.ObservationType.NUMERIC) {
                        component.setNumericValue(values.get(i));
                        observation.updateComponent(component);
                        ++valuesSet;
                    }
                    ++i;
                }
                if (valuesSet == components.size()) {
                    String comment = NumericMigration.getComment(result);
                    if (comment != null && !comment.isEmpty()) {
                        if (values.size() > valuesSet) {
                            comment = result;
                        }
                        observation.setComment(comment);
                    }
                    return true;
                }
                logger.error("Could only set " + valuesSet + " of " + values.size() + " values of Messwert [" + this.messwert.getId() + "]");
                return false;
            }
            if (type == IObservation.ObservationType.TEXT) {
                String value = TextMigration.getValue(this.messwert.getResult(this.mapping.getLocalBefundField()));
                for (ObservationComponent observationComponent : components) {
                    IObservation.ObservationType componentType = (IObservation.ObservationType)observationComponent.getTypeFromExtension(IObservation.ObservationType.class);
                    if (componentType != IObservation.ObservationType.TEXT) continue;
                    observationComponent.setStringValue(value);
                    return true;
                }
            }
        }
        return false;
    }

    private IObservation.ObservationType getComponentsType(List<ObservationComponent> components) {
        for (ObservationComponent observationComponent : components) {
            IObservation.ObservationType type = (IObservation.ObservationType)observationComponent.getTypeFromExtension(IObservation.ObservationType.class);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private boolean setValue(ObservationComponent observationComponent) {
        IObservation.ObservationType type = (IObservation.ObservationType)observationComponent.getTypeFromExtension(IObservation.ObservationType.class);
        if (type == IObservation.ObservationType.NUMERIC) {
            BigDecimal value = NumericMigration.getValue(this.messwert.getResult(this.mapping.getLocalBefundField()));
            observationComponent.setNumericValue(value);
            return true;
        }
        if (type == IObservation.ObservationType.TEXT) {
            String value = TextMigration.getValue(this.messwert.getResult(this.mapping.getLocalBefundField()));
            observationComponent.setStringValue(value);
            return true;
        }
        return false;
    }

    private IObservation getOrCreateObservation() {
        for (IObservation iObservation : this.createdObservations) {
            if (!ModelUtil.isCodeInList((String)CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), (String)this.componentGrpCode, (List)iObservation.getCoding())) continue;
            return iObservation;
        }
        try {
            return (IObservation)this.templateService.createFinding(Patient.load((String)this.messwert.get("PatientID")), this.template);
        }
        catch (ElexisException e) {
            logger.error("Error creating observation", (Throwable)e);
            return null;
        }
    }
}

