/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde;

import ch.elexis.base.befunde.ACLContributor;
import ch.elexis.base.befunde.Messages;
import ch.elexis.base.befunde.PrefsPage;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BefundePrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    Map<Object, Object> fields;
    Messwert setup;
    String names;
    CTabFolder ctabs;
    int lastIDX;

    public BefundePrefs() {
        super("Befunde");
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.ctabs = new CTabFolder(ret, 0);
        this.ctabs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.ctabs.setLayout((Layout)new FillLayout());
        this.setup = Messwert.getSetup();
        this.fields = this.setup.getMap("Befunde");
        this.names = (String)this.fields.get("names");
        if (!StringTool.isNothing((Object)this.names)) {
            String[] stringArray = this.names.split(";;");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                CTabItem ci = new CTabItem(this.ctabs, 0);
                ci.setText(f);
                PrefsPage fp = new PrefsPage((Composite)this.ctabs, this.fields, f);
                ci.setControl((Control)fp);
                ++n2;
            }
        }
        this.ctabs.setSelection(0);
        this.lastIDX = 0;
        this.ctabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BefundePrefs.this.lastIDX != -1) {
                    BefundePrefs.this.flush(BefundePrefs.this.lastIDX);
                    BefundePrefs.this.lastIDX = BefundePrefs.this.ctabs.getSelectionIndex();
                }
            }
        });
        Composite cButtons = new Composite(ret, 0);
        cButtons.setLayout((Layout)new FillLayout());
        Button bAdd = new Button(cButtons, 8);
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(BefundePrefs.this.getShell(), Messages.BefundePrefs_enterNameCaption, Messages.BefundePrefs_enterNameMessage, "", (IInputValidator)new FindingNameInputValidator());
                if (id.open() == 0) {
                    String name = id.getValue();
                    BefundePrefs.this.names = StringTool.isNothing((Object)BefundePrefs.this.names) ? name : String.valueOf(BefundePrefs.this.names) + ";;" + name;
                    BefundePrefs.this.fields.put("names", BefundePrefs.this.names);
                    CTabItem ci = new CTabItem(BefundePrefs.this.ctabs, 0);
                    ci.setText(name);
                    PrefsPage fp = new PrefsPage((Composite)BefundePrefs.this.ctabs, BefundePrefs.this.fields, name);
                    ci.setControl((Control)fp);
                    BefundePrefs.this.ctabs.setSelection(ci);
                }
            }
        });
        bAdd.setText(Messages.BefundePrefs_add);
        Button bRemove = new Button(cButtons, 8);
        bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefsPage pp;
                CTabItem ci = BefundePrefs.this.ctabs.getSelection();
                if (ci != null && (pp = (PrefsPage)ci.getControl()).remove()) {
                    BefundePrefs.this.names = BefundePrefs.this.names.replaceFirst(ci.getText(), "");
                    BefundePrefs.this.names = BefundePrefs.this.names.replaceAll(";;;;", ";;");
                    BefundePrefs.this.names.replaceFirst(";;$", "");
                    BefundePrefs.this.names = BefundePrefs.this.names.replaceFirst("^;;", "");
                    BefundePrefs.this.fields.put("names", BefundePrefs.this.names);
                    BefundePrefs.this.lastIDX = -1;
                    ci.dispose();
                    BefundePrefs.this.ctabs.setSelection(0);
                }
            }
        });
        bRemove.setText(Messages.BefundePrefs_deleteText);
        if (!CoreHub.acl.request(ACLContributor.DELETE_PARAM)) {
            bRemove.setEnabled(false);
        }
        Button bRename = new Button(cButtons, 8);
        bRename.setText(Messages.BefundePrefs_renameFinding);
        bRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id;
                CTabItem tab = BefundePrefs.this.ctabs.getSelection();
                if (tab != null && (id = new InputDialog(BefundePrefs.this.getShell(), Messages.BefundePrefs_enterRenameCaption, Messages.BefundePrefs_enterRenameMessage, "", (IInputValidator)new FindingNameInputValidator())).open() == 0) {
                    String oldName = tab.getText();
                    String newName = id.getValue();
                    PrefsPage pp = (PrefsPage)tab.getControl();
                    if (pp.rename(newName)) {
                        BefundePrefs.this.names = BefundePrefs.this.names.replaceFirst(oldName, newName);
                    }
                    BefundePrefs.this.fields.put("names", BefundePrefs.this.names);
                    tab.setText(newName);
                }
            }
        });
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    private void flush(int idx) {
        CTabItem it = this.ctabs.getItem(idx);
        PrefsPage pp = (PrefsPage)it.getControl();
        pp.flush();
    }

    protected void performApply() {
        this.performOk();
        int idx = this.ctabs.getSelectionIndex();
        CTabItem it = this.ctabs.getItem(idx);
        PrefsPage pp = (PrefsPage)it.getControl();
        pp.load();
    }

    public boolean performOk() {
        int idx = this.ctabs.getSelectionIndex();
        if (idx != -1) {
            this.flush(idx);
        }
        this.setup.setMap("Befunde", this.fields);
        return super.performOk();
    }

    class FindingNameInputValidator
    implements IInputValidator {
        FindingNameInputValidator() {
        }

        public String isValid(String newText) {
            if ((newText = newText.trim()).endsWith(".")) {
                return Messages.BefundePrefs_dotEndingNameNotAllowed;
            }
            return null;
        }
    }
}

