/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.barcode.scanner.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.preferences.inputs.ComboFieldEditor;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String BarcodeScanner_COMPORT = "barcode/Symbol/port";
    public static final String BarcodeScanner_AUTOSTART = "barcode/Symbol/autostart";
    public static final String BarcodeScanner_SETTINGS = "barcode/Symbol/settings";
    public static final int NUMBER_OF_SCANNERS = 2;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    public void init(IWorkbench workbench) {
        this.setDetaults();
    }

    private void setDetaults() {
        int i = 0;
        while (i < 2) {
            String postfix = i > 0 ? String.valueOf(i) : "";
            this.getPreferenceStore().setDefault(BarcodeScanner_SETTINGS + postfix, "9600,8,n,1");
            ++i;
        }
    }

    protected void createFieldEditors() {
        Group group = null;
        ArrayList<String> ports = new ArrayList<String>();
        ports.add("");
        ports.addAll(Arrays.asList(Connection.getComPorts()));
        if (ports.size() > 1) {
            String[] comPorts = ports.toArray(new String[0]);
            int i = 0;
            while (i < 2) {
                String postfix = i > 0 ? String.valueOf(i) : "";
                group = new Group(this.getFieldEditorParent(), 0);
                group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                group.setLayout((Layout)new GridLayout(1, true));
                group.setText("Barcode Scanner " + (i + 1));
                Composite c = new Composite((Composite)group, 0);
                c.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                GridLayout layout = new GridLayout(1, true);
                c.setLayout((Layout)layout);
                this.addField((FieldEditor)new ComboFieldEditor(BarcodeScanner_COMPORT + postfix, "Com-Schnittstelle", comPorts, c));
                this.addField((FieldEditor)new StringFieldEditor(BarcodeScanner_SETTINGS + postfix, "Einstellungen", c));
                ++i;
            }
            this.addField((FieldEditor)new BooleanFieldEditor(BarcodeScanner_AUTOSTART, "Bei Start automatisch verbinden", 0, this.getFieldEditorParent()));
        } else {
            SWTHelper.showError((String)"Barcode Scanner", (String)"Es wurde keine COM-Schnittstelle gefunden!");
        }
    }
}

