/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.archie.wzw.BaseStats;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PhysioLeistung;
import ch.elexis.data.Rechnung;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PatientenHitlist
extends BaseStats {
    static final String NAME = "Patienten-Hitliste";
    static final String DESC = "Listet Patienten nach Kosten";
    static final String[] HEADINGS = new String[]{"PatientNr", "Alter", "Geschlecht", "Kosten", "Tarmed", "Tarmed-AL", "Tarmed-TL", "Medicals", "Medikamente", "Physio", "Andere", "Anz. Kons", "Anz. Besuch", "Anz. Rn"};
    private int males;
    private int females;
    private double age_female;
    private double age_male;
    private double cost_male;
    private double cost_female;
    private double tarmed_male;
    private double tarmed_female;
    private double tal_male;
    private double tal_female;
    private double ttl_male;
    private double ttl_female;
    private double medicals_male;
    private double medicals_female;
    private double medics_male;
    private double medics_female;
    private double physio_male;
    private double physio_female;
    private double other_male;
    private double other_female;
    private double cons_male;
    private double cons_female;
    private double visit_male;
    private double visit_female;
    private double bills_female;
    private double bills_male;

    public PatientenHitlist() {
        super(NAME, DESC, HEADINGS);
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        try {
            HashMap<String, PatientStat> pstat = new HashMap<String, PatientStat>();
            List<Konsultation> conses = this.getConses(monitor);
            if (conses.size() > 0) {
                int clicksPerRound = this.HUGE_NUMBER / conses.size();
                for (Konsultation k : conses) {
                    Patient pat;
                    Mandant m = k.getMandant();
                    if (m == null) continue;
                    Fall fall = k.getFall();
                    if (fall != null && (pat = fall.getPatient()) != null) {
                        PatientStat ps = (PatientStat)pstat.get(pat.getId());
                        if (ps == null) {
                            ps = new PatientStat(pat);
                            pstat.put(pat.getId(), ps);
                        }
                        ps.addCons(k);
                    }
                    monitor.worked(clicksPerRound);
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
                Comparable[] sum_all = new Comparable[this.dataSet.getHeadings().size()];
                Comparable[] sum_male = new Comparable[this.dataSet.getHeadings().size()];
                Comparable[] sum_female = new Comparable[this.dataSet.getHeadings().size()];
                result.add(sum_all);
                result.add(sum_female);
                result.add(sum_male);
                sum_all[0] = "Durchschnitt Alle";
                sum_female[0] = "Frauen";
                sum_male[0] = "M\u00e4nner";
                for (PatientStat ps : pstat.values()) {
                    Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                    Patient pat = Patient.load((String)ps.PatientID);
                    if (pat == null || !pat.isValid()) continue;
                    row[0] = pat.getPatCode();
                    row[1] = pat.getAlter();
                    row[2] = pat.getGeschlecht();
                    row[3] = Double.valueOf(this.round(ps.costTotal));
                    row[4] = Double.valueOf(this.round(ps.costTarmedAL + ps.costTarmedTL));
                    row[5] = Double.valueOf(this.round(ps.costTarmedAL));
                    row[6] = Double.valueOf(this.round(ps.costTarmedTL));
                    row[7] = Double.valueOf(this.round(ps.costMedical));
                    row[8] = Double.valueOf(this.round(ps.costMedikamente));
                    row[9] = Double.valueOf(this.round(ps.costPhysio));
                    row[10] = Double.valueOf(this.round(ps.costOther));
                    row[11] = ps.numCons;
                    row[12] = ps.numVisits;
                    row[13] = Integer.valueOf(ps.bills.size());
                    result.add(row);
                    if (pat.getGeschlecht().equalsIgnoreCase("m")) {
                        ++this.males;
                        this.age_male += Double.parseDouble((String)((Object)row[1]));
                        this.cost_male += ((Double)row[3]).doubleValue();
                        this.tarmed_male += ((Double)row[4]).doubleValue();
                        this.tal_male += ((Double)row[5]).doubleValue();
                        this.ttl_male += ((Double)row[6]).doubleValue();
                        this.medicals_male += ((Double)row[7]).doubleValue();
                        this.medics_male += ((Double)row[8]).doubleValue();
                        this.physio_male += ((Double)row[9]).doubleValue();
                        this.other_male += ((Double)row[10]).doubleValue();
                        this.cons_male += (double)((Integer)row[11]).intValue();
                        this.visit_male += (double)((Integer)row[12]).intValue();
                        this.bills_male += (double)((Integer)row[13]).intValue();
                        continue;
                    }
                    ++this.females;
                    this.age_female += Double.parseDouble((String)((Object)row[1]));
                    this.cost_female += ((Double)row[3]).doubleValue();
                    this.tarmed_female += ((Double)row[4]).doubleValue();
                    this.tal_female += ((Double)row[5]).doubleValue();
                    this.ttl_female += ((Double)row[6]).doubleValue();
                    this.medicals_female += ((Double)row[7]).doubleValue();
                    this.medics_female += ((Double)row[8]).doubleValue();
                    this.physio_female += ((Double)row[9]).doubleValue();
                    this.other_female += ((Double)row[10]).doubleValue();
                    this.cons_female += (double)((Integer)row[11]).intValue();
                    this.visit_female += (double)((Integer)row[12]).intValue();
                    this.bills_female += (double)((Integer)row[13]).intValue();
                }
                sum_female[1] = Double.valueOf(this.round(this.age_female / (double)this.females));
                sum_female[2] = new Integer(this.females);
                sum_female[3] = Double.valueOf(this.round(this.cost_female / (double)this.females));
                sum_female[4] = Double.valueOf(this.round(this.tarmed_female / (double)this.females));
                sum_female[5] = Double.valueOf(this.round(this.tal_female / (double)this.females));
                sum_female[6] = Double.valueOf(this.round(this.ttl_female / (double)this.females));
                sum_female[7] = Double.valueOf(this.round(this.medicals_female / (double)this.females));
                sum_female[8] = Double.valueOf(this.round(this.medics_female / (double)this.females));
                sum_female[9] = Double.valueOf(this.round(this.physio_female / (double)this.females));
                sum_female[10] = Double.valueOf(this.round(this.other_female / (double)this.females));
                sum_female[11] = Double.valueOf(this.round(this.cons_female / (double)this.females));
                sum_female[12] = Double.valueOf(this.round(this.visit_female / (double)this.females));
                sum_female[13] = Double.valueOf(this.round(this.bills_female / (double)this.females));
                sum_male[1] = Double.valueOf(this.round(this.age_male / (double)this.males));
                sum_male[2] = new Integer(this.males);
                sum_male[3] = Double.valueOf(this.round(this.cost_male / (double)this.males));
                sum_male[4] = Double.valueOf(this.round(this.tarmed_male / (double)this.males));
                sum_male[5] = Double.valueOf(this.round(this.tal_male / (double)this.males));
                sum_male[6] = Double.valueOf(this.round(this.ttl_male / (double)this.males));
                sum_male[7] = Double.valueOf(this.round(this.medicals_male / (double)this.males));
                sum_male[8] = Double.valueOf(this.round(this.medics_male / (double)this.males));
                sum_male[9] = Double.valueOf(this.round(this.physio_male / (double)this.males));
                sum_male[10] = Double.valueOf(this.round(this.other_male / (double)this.males));
                sum_male[11] = Double.valueOf(this.round(this.cons_male / (double)this.males));
                sum_male[12] = Double.valueOf(this.round(this.visit_male / (double)this.males));
                sum_male[13] = Double.valueOf(this.round(this.bills_male / (double)this.males));
                sum_all[1] = Double.valueOf(this.round((this.age_male + this.age_female) / (double)(this.males + this.females)));
                sum_all[2] = new Integer(this.males + this.females);
                sum_all[3] = Double.valueOf(this.round((this.cost_male + this.cost_female) / (double)(this.males + this.females)));
                sum_all[4] = Double.valueOf(this.round((this.tarmed_male + this.tarmed_female) / (double)(this.males + this.females)));
                sum_all[5] = Double.valueOf(this.round((this.tal_male + this.tal_female) / (double)(this.males + this.females)));
                sum_all[6] = Double.valueOf(this.round((this.ttl_male + this.ttl_female) / (double)(this.males + this.females)));
                sum_all[7] = Double.valueOf(this.round((this.medicals_male + this.medicals_female) / (double)(this.males + this.females)));
                sum_all[8] = Double.valueOf(this.round((this.medics_male + this.medics_female) / (double)(this.males + this.females)));
                sum_all[9] = Double.valueOf(this.round((this.physio_male + this.physio_female) / (double)(this.males + this.females)));
                sum_all[10] = Double.valueOf(this.round((this.other_male + this.other_female) / (double)(this.males + this.females)));
                sum_all[11] = Double.valueOf(this.round((this.cons_male + this.cons_female) / (double)(this.males + this.females)));
                sum_all[12] = Double.valueOf(this.round((this.visit_male + this.visit_female) / (double)(this.males + this.females)));
                sum_all[13] = Double.valueOf(this.round((this.bills_male + this.bills_female) / (double)(this.males + this.females)));
                this.dataSet.setContent(result);
                monitor.done();
                return Status.OK_STATUS;
            }
        }
        catch (Throwable t) {
            ExHandler.handle((Throwable)t);
            return new Status(4, "ch.elexis.archie.wzw", t.getMessage());
        }
        return Status.CANCEL_STATUS;
    }

    private double round(double x) {
        return (double)Math.round(x * 100.0) / 100.0;
    }

    static class PatientStat {
        String PatientID;
        TimeTool birthDate;
        String sex;
        Integer numCons;
        Integer numVisits;
        Double costTarmedAL;
        Double costTarmedTL;
        Double costMedical;
        Double costMedikamente;
        Double costPhysio;
        Double costLabor;
        Double costOther;
        Double costTotal;
        ArrayList<Rechnung> bills = new ArrayList();

        PatientStat(Patient pat) {
            this.PatientID = pat.getId();
            this.birthDate = new TimeTool(pat.get("Geburtsdatum"));
            this.sex = pat.getGeschlecht();
            this.numCons = 0;
            this.numVisits = 0;
            this.costTarmedAL = 0.0;
            this.costTarmedTL = 0.0;
            this.costMedical = 0.0;
            this.costMedikamente = 0.0;
            this.costPhysio = 0.0;
            this.costLabor = 0.0;
            this.costOther = 0.0;
            this.costTotal = 0.0;
        }

        void addCons(Konsultation k) {
            TimeTool kdate = new TimeTool(k.getDatum());
            this.numCons = this.numCons + 1;
            List vr = k.getLeistungen();
            Fall fall = k.getFall();
            for (Verrechnet v : vr) {
                IVerrechenbar vv = v.getVerrechenbar();
                if (vv == null) continue;
                double cost = v.getNettoPreis().doubleValue() * (double)v.getZahl();
                this.costTotal = this.costTotal + cost;
                if (vv instanceof TarmedLeistung) {
                    int tarmedAl = TarmedLeistung.getAL((Verrechnet)v);
                    int tarmedTl = TarmedLeistung.getTL((Verrechnet)v);
                    TarmedLeistung tl = (TarmedLeistung)vv;
                    if (tl.getCode().equals("00.0060")) {
                        this.numVisits = this.numVisits + 1;
                    }
                    double cal = (double)Math.round((double)(v.getZahl() * tarmedAl) * tl.getFactor(kdate, (IFall)fall)) / 100.0;
                    this.costTarmedAL = this.costTarmedAL + cal;
                    double ctl = (double)Math.round((double)(v.getZahl() * tarmedTl) * tl.getFactor(kdate, (IFall)fall)) / 100.0;
                    this.costTarmedTL = this.costTarmedTL + ctl;
                    continue;
                }
                if (vv instanceof PhysioLeistung) {
                    this.costPhysio = this.costPhysio + cost;
                    continue;
                }
                if ("Medicals".equals(vv.getCodeSystemName()) || "MiGeL".equals(vv.getCodeSystemName())) {
                    this.costMedical = this.costMedical + cost;
                    continue;
                }
                if ("Medikamente".equals(vv.getCodeSystemName()) || "400".equals(vv.getCodeSystemCode()) || "402".equals(vv.getCodeSystemCode())) {
                    this.costMedikamente = this.costMedikamente + cost;
                    continue;
                }
                if (vv instanceof Labor2009Tarif) {
                    this.costLabor = this.costLabor + cost;
                    continue;
                }
                this.costOther = this.costOther + cost;
            }
            Rechnung r = k.getRechnung();
            if (r != null && !this.bills.contains(r)) {
                this.bills.add(r);
            }
        }
    }
}

