/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.TimeTool;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BaseStats
extends AbstractTimeSeries {
    protected String desc;
    protected String[] headings;
    private String dateMethod = "Rechnungsdatum";
    private boolean bOnlyActiveMandator;
    protected int clicksPerRound;
    protected int HUGE_NUMBER = 1000000;

    public BaseStats(String name, String desc, String[] headings) {
        super(name);
        this.headings = headings;
        this.desc = desc;
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX, index=1)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant", index=1)
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    @GetProperty(widgetType=WidgetTypes.COMBO, description="Interpretation des Datums", index=1, items={"Rechnungsdatum", "Zahlungsdatum", "Konsultationsdatum"}, name="Datum-Typ")
    public String getDateType() {
        return this.dateMethod;
    }

    @SetProperty(index=1, name="Datum-Typ")
    public void setDateType(String dT) {
        this.dateMethod = dT;
    }

    public String getDescription() {
        return this.desc;
    }

    protected List<String> createHeadings() {
        return Arrays.asList(this.headings);
    }

    protected List<Konsultation> getConses(final IProgressMonitor monitor) {
        this.HUGE_NUMBER = 1000000;
        monitor.beginTask("Sammle Konsultationsdaten ", this.HUGE_NUMBER);
        monitor.subTask("Datenbankabfrage und PostQueryFilters");
        Query qbe = new Query(Konsultation.class);
        String dateFrom = new TimeTool(this.getStartDate().getTime().getTime()).toString(9);
        String dateUntil = new TimeTool(this.getEndDate().getTimeInMillis()).toString(9);
        final TimeTool from = new TimeTool(dateFrom);
        final TimeTool to = new TimeTool(dateUntil);
        if (this.getDateType().equals("Konsultationsdatum")) {
            qbe.addPostQueryFilter(new IFilter(){

                public boolean select(Object element) {
                    Konsultation k = (Konsultation)element;
                    monitor.subTask(k.getDatum());
                    monitor.worked(1);
                    --BaseStats.this.HUGE_NUMBER;
                    TimeTool konsDatum = new TimeTool(k.getDatum());
                    return konsDatum.isAfterOrEqual(from) && konsDatum.isBeforeOrEqual(to);
                }
            });
        } else if (this.getDateType().equals("Rechnungsdatum")) {
            qbe.add("RechnungsID", "NOT", null);
            qbe.addPostQueryFilter(new IFilter(){

                public boolean select(Object element) {
                    Konsultation k = (Konsultation)element;
                    monitor.subTask(k.getDatum());
                    monitor.worked(1);
                    --BaseStats.this.HUGE_NUMBER;
                    Rechnung rn = k.getRechnung();
                    TimeTool rndate = new TimeTool(rn.getDatumRn());
                    return rndate.isAfterOrEqual(from) && rndate.isBeforeOrEqual(to);
                }
            });
        } else if (this.getDateType().equals("Zahlungsdatum")) {
            qbe.add("RechnungsID", "NOT", null);
            qbe.addPostQueryFilter(new IFilter(){

                public boolean select(Object element) {
                    Konsultation k = (Konsultation)element;
                    monitor.subTask(k.getLabel());
                    monitor.worked(1);
                    --BaseStats.this.HUGE_NUMBER;
                    Rechnung rn = k.getRechnung();
                    if (rn.getStatus() == 16 || rn.getStatus() == 17) {
                        TimeTool rndate = new TimeTool(rn.getDatumRn());
                        return rndate.isAfterOrEqual(from) && rndate.isBeforeOrEqual(to);
                    }
                    return false;
                }
            });
        }
        if (this.bOnlyActiveMandator) {
            qbe.add("MandantID", "=", CoreHub.actMandant.getId());
        }
        return qbe.execute();
    }
}

