/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.archie.wzw.BaseStats;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AlleLeistungen
extends BaseStats {
    static final String NAME = "Leistungen-Hitliste";
    static final String DESC = "Listet s\u00e4mtliche Leistungen im gegebenen Zeitraum";
    static final String[] HEADINGS = new String[]{"Codesystem", "Code", "Text", "Anzahl", "Umsatz"};

    public AlleLeistungen() {
        super(NAME, DESC, HEADINGS);
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        List<Konsultation> conses = this.getConses(monitor);
        if (conses.size() > 0) {
            int clicksPerRound = this.HUGE_NUMBER / conses.size();
            HashMap<String, TarifStat> tstats = new HashMap<String, TarifStat>();
            for (Konsultation k : conses) {
                Patient pat;
                Mandant m = k.getMandant();
                if (m == null) continue;
                Fall fall = k.getFall();
                if (fall != null && (pat = fall.getPatient()) != null) {
                    List vr = k.getLeistungen();
                    for (Verrechnet v : vr) {
                        IVerrechenbar vv = v.getVerrechenbar();
                        if (vv == null) {
                            System.out.println(v.getLabel());
                            continue;
                        }
                        String sname = vv.getCodeSystemName();
                        String scode = vv.getCode() == null ? "?" : vv.getCode();
                        TarifStat ts = (TarifStat)tstats.get(String.valueOf(sname) + scode);
                        if (ts == null) {
                            ts = new TarifStat();
                            ts.tarif = vv.getCodeSystemName();
                            ts.ziffer = vv.getCode() == null ? "?" : vv.getCode();
                            ts.text = vv.getText();
                            tstats.put(String.valueOf(sname) + scode, ts);
                        }
                        ts.count += v.getZahl();
                        ts.umsatz += v.getNettoPreis().doubleValue() + (double)v.getZahl();
                    }
                }
                monitor.worked(clicksPerRound);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            for (TarifStat ts : tstats.values()) {
                Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                row[0] = ts.tarif;
                row[1] = ts.ziffer;
                row[2] = ts.text;
                row[3] = new Integer(ts.count);
                row[4] = new Money(ts.umsatz);
                result.add(row);
            }
        }
        this.dataSet.setContent(result);
        return Status.OK_STATUS;
    }

    class TarifStat {
        String tarif;
        String ziffer;
        String text;
        int count;
        double umsatz;

        TarifStat() {
        }
    }
}

