/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.patientstatistik;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

public class Counter
extends Job {
    private static final int tasksum = 1000000;
    private int perCase = 1000000;
    private int perKons = 1;
    private HashMap<IVerrechenbar, List<Verrechnet>> result;
    private Patient p;
    private TimeTool von;
    private TimeTool bis;

    public HashMap<IVerrechenbar, List<Verrechnet>> getValues() {
        return this.result;
    }

    public Counter(Patient p, TimeTool von, TimeTool bis, final IJobFinishedListener lis) {
        super("Verrechnungsz\u00e4hler");
        this.setUser(true);
        this.setSystem(false);
        this.setPriority(30);
        this.p = p;
        this.von = von;
        this.bis = bis;
        if (lis != null) {
            this.addJobChangeListener(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    UiDesk.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            lis.jobFinished(Counter.this);
                        }
                    });
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Z\u00e4hle Verrechnungen", 1000000);
        this.result = new HashMap();
        Fall[] faelle = this.p.getFaelle();
        if (faelle.length > 0) {
            this.perCase = 1000000 / faelle.length;
            Query qbe = new Query(Konsultation.class);
            qbe.startGroup();
            Fall[] fallArray = faelle;
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                qbe.add("FallID", "=", fall.getId());
                qbe.or();
                ++n2;
            }
            qbe.endGroup();
            qbe.and();
            if (this.von != null) {
                qbe.add("Datum", ">=", this.von.toString(9));
            }
            if (this.bis != null) {
                qbe.add("Datum", "<=", this.bis.toString(9));
            }
            List kk = qbe.execute();
            this.perKons = this.perCase / kk.size();
            for (Konsultation k : kk) {
                List lv = k.getLeistungen();
                for (Verrechnet v : lv) {
                    IVerrechenbar iv = v.getVerrechenbar();
                    List<Verrechnet> liv = this.result.get(iv);
                    if (liv == null) {
                        liv = new LinkedList<Verrechnet>();
                        this.result.put(iv, liv);
                    }
                    liv.add(v);
                }
                monitor.worked(this.perKons);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public static interface IJobFinishedListener {
        public void jobFinished(Counter var1);
    }
}

