/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TerminListeDruckenDialog
extends TitleAreaDialog
implements ITextPlugin.ICallback {
    IPlannable[] liste;

    public TerminListeDruckenDialog(Shell shell, IPlannable[] liste) {
        super(shell);
        this.liste = liste;
        if (liste != null && liste.length > 0) {
            Termin termin = (Termin)liste[0];
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)termin);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new FillLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        TextContainer text = new TextContainer(this.getShell());
        text.getPlugin().createContainer(ret, (ITextPlugin.ICallback)this);
        text.getPlugin().showMenu(false);
        text.getPlugin().showToolbar(false);
        text.createFromTemplateName(null, "AgendaListe", "Allg.", (Kontakt)CoreHub.actUser, "Agenda");
        String[][] termine = new String[this.liste.length + 1][5];
        termine[0] = new String[]{"von", "bis", "Typ", "Name", "Grund"};
        int i = 1;
        while (i < this.liste.length) {
            termine[i][0] = Plannables.getStartTimeAsString(this.liste[i - 1]);
            termine[i][1] = Plannables.getEndTimeAsString(this.liste[i - 1]);
            termine[i][2] = this.liste[i - 1].getType();
            Patient pat = Patient.load((String)this.liste[i - 1].getText());
            String patCode = "";
            if (pat.exists()) {
                patCode = ", Id: " + pat.getPatCode();
            }
            termine[i][3] = String.valueOf(this.liste[i - 1].getTitle()) + patCode;
            termine[i][4] = this.liste[i - 1].getReason();
            ++i;
        }
        text.getPlugin().setFont("Helvetica", 0, 9.0f);
        text.getPlugin().insertTable("[Termine]", 0, termine, new int[]{15, 15, 20, 50, 20});
        return ret;
    }

    public void create() {
        super.create();
        this.setMessage("Terminliste ausdrucken");
        this.setTitle("Terminliste");
        this.getShell().setText("Agenda");
        this.getShell().setSize(800, 700);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }
}

