/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.commands.PrintAppointmentLabelHandler;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.util.TimeInput;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.NumberInput;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.User;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminDialog
extends TitleAreaDialog {
    private static final Logger logger = LoggerFactory.getLogger(TerminDialog.class);
    private static ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
    private static Category cmdCategory = cmdService.getCategory("ch.elexis.agenda.commands");
    DatePicker dp;
    TimeInput tiVon;
    TimeInput tiBis;
    int ts = CoreHub.userCfg.get("agenda/dayView/Start", 7);
    int te = CoreHub.userCfg.get("agenda/dayView/End", 19);
    int tagStart = this.ts * 60;
    int tagEnd = this.te * 60;
    int[] rasterValues = new int[]{5, 10, 15, 30};
    int rasterIndex = CoreHub.userCfg.get("agenda/dayView/raster", 3);
    Hashtable<String, String> tMap;
    double minutes;
    double pixelPerMinute;
    NumberInput niDauer;
    ArrayList<Termin> lTermine;
    org.eclipse.swt.widgets.List lTerminListe;
    Button bLocked;
    Button bSerie;
    Button bSave;
    Button bDelete;
    Button bChange;
    Button bPrint;
    Button bFuture;
    Button bEmergency;
    Slider slider;
    DayOverview dayBar;
    Kontakt actKontakt;
    IPlannable actPlannable;
    Text tNr;
    Text tName;
    Text tBem;
    Combo cbTyp;
    Combo cbStatus;
    Combo cbMandant;
    Text tGrund;
    Activator agenda = Activator.getDefault();
    boolean bModified;
    private String msg;
    private CollisionErrorLevel collisionErrorLevel = CollisionErrorLevel.ERROR;

    public TerminDialog(IPlannable act) {
        super(UiDesk.getTopShell());
        if (act == null) {
            act = new Termin.Free(this.agenda.getActDate().toString(9), 0, 30);
        }
        if (act instanceof Termin) {
            Termin lact = (Termin)act;
            this.actKontakt = lact.getKontakt();
        } else {
            this.actKontakt = ElexisEventDispatcher.getSelectedPatient();
        }
        Color green = UiDesk.getColor((String)"gruen");
        if (green == null) {
            UiDesk.getColorRegistry().put("gruen", new RGB(0, 255, 0));
        }
        this.actPlannable = act;
        this.tMap = Plannables.getTimePrefFor(this.agenda.getActResource());
        this.tMap.put(Termin.typFrei(), "0");
        this.tMap.put(Termin.typReserviert(), "0");
    }

    public TerminDialog(@NonNull TimeTool date, @NonNull String resource, Patient patient) {
        super(UiDesk.getTopShell());
        Termin.Free act = new Termin.Free(date.toString(9), date.get(11) * 60 + date.get(12), 30);
        this.actKontakt = patient;
        Color green = UiDesk.getColor((String)"gruen");
        if (green == null) {
            UiDesk.getColorRegistry().put("gruen", new RGB(0, 255, 0));
        }
        this.actPlannable = act;
        this.agenda.setActResource(resource);
        this.tMap = Plannables.getTimePrefFor(this.agenda.getActResource());
        this.tMap.put(Termin.typFrei(), "0");
        this.tMap.put(Termin.typReserviert(), "0");
    }

    public static void setActResource(String resource) {
        Activator.getDefault().setActResource(resource);
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite ret = new Composite((Composite)sc, 0);
        sc.setContent((Control)ret);
        ret.setLayout((Layout)new GridLayout());
        Composite topRow = new Composite(ret, 2048);
        topRow.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        topRow.setLayout((Layout)new GridLayout(3, true));
        this.dp = new DatePicker(topRow, 0);
        this.dp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.dp.setDate(this.agenda.getActDate().getTime());
        this.dp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TerminDialog.this.agenda.setActDate(new TimeTool(TerminDialog.this.dp.getDate().getTime()));
                TerminDialog.this.dayBar.redraw();
                TerminDialog.this.slider.set();
            }
        });
        Composite topCenter = new Composite(topRow, 0);
        topCenter.setLayout((Layout)new GridLayout(3, true));
        topCenter.setLayoutData((Object)new GridData(4, 4, false, true));
        this.tiVon = new TimeInput(topCenter, Messages.TerminDialog_startTime);
        this.tiVon.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
        this.tiVon.addListener(new TimeInput.TimeInputListener(){

            @Override
            public void changed() {
                TerminDialog.this.slider.set();
            }
        });
        this.niDauer = new NumberInput(topCenter, Messages.TerminDialog_duration);
        this.niDauer.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.niDauer.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TerminDialog.this.slider.set();
            }
        });
        this.tiBis = new TimeInput(topCenter, Messages.TerminDialog_endTime);
        this.tiBis.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
        this.tiBis.addListener(new TimeInput.TimeInputListener(){

            @Override
            public void changed() {
                int mVon = TerminDialog.this.tiVon.getTimeAsMinutes();
                int mBis = TerminDialog.this.tiBis.getTimeAsMinutes();
                TerminDialog.this.niDauer.setValue(mBis - mVon);
                TerminDialog.this.slider.set();
            }
        });
        this.lTermine = new ArrayList();
        this.lTerminListe = new org.eclipse.swt.widgets.List(topCenter, 2820);
        this.lTerminListe.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
        this.lTerminListe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = TerminDialog.this.lTerminListe.getSelectionIndex();
                if (idx > -1 && idx < TerminDialog.this.lTermine.size()) {
                    TerminDialog.this.actPlannable = TerminDialog.this.lTermine.get(idx);
                    TerminDialog.this.setAll();
                }
            }
        });
        Composite topRight = new Composite(topRow, 0);
        topRight.setLayoutData((Object)new GridData(4, 4, false, false));
        topRight.setLayout((Layout)new GridLayout(2, true));
        Label sep = new Label(topRight, 0);
        sep.setText(" ");
        sep.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        this.bLocked = new Button(topRight, 32);
        this.bLocked.setText(Messages.TerminDialog_locked);
        this.bLocked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TerminDialog.this.actPlannable instanceof Termin) {
                    ((Termin)TerminDialog.this.actPlannable).setLocked(TerminDialog.this.bLocked.getSelection());
                }
                TerminDialog.this.setEnablement();
            }
        });
        if (!CoreHub.acl.request(ACLContributor.CHANGE_APPLOCK)) {
            this.bLocked.setEnabled(false);
        }
        this.bSerie = new Button(topRight, 32);
        this.bSerie.setText(Messages.TerminDialog_serie);
        this.bSave = new Button(topRight, 8);
        this.bSave.setText(Messages.TerminDialog_set);
        this.bSave.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.bSave.setToolTipText(Messages.TerminDialog_createTermin);
        this.bSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TerminDialog.this.createTermin(true);
            }
        });
        Point s = this.bSave.computeSize(-1, -1);
        this.bChange = new Button(topRight, 8);
        this.bChange.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.bChange.setText(Messages.TerminDialog_change);
        this.bChange.setToolTipText(Messages.TerminDialog_changeTermin);
        this.bDelete = new Button(topRight, 8);
        this.bDelete.setText(Messages.TerminDialog_delete);
        this.bDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.bDelete.setToolTipText(Messages.TerminDialog_deleteTermin);
        this.bDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TerminDialog.this.actPlannable instanceof Termin) {
                    TerminDialog.this.lTerminListe.remove(TerminDialog.this.lTerminListe.getSelectionIndex());
                    TerminDialog.this.lTermine.remove(TerminDialog.this.actPlannable);
                    ((Termin)TerminDialog.this.actPlannable).delete();
                    ElexisEventDispatcher.reload(Termin.class);
                    TerminDialog.this.dayBar.recalc();
                    TerminDialog.this.setEnablement();
                }
                super.widgetSelected(e);
            }
        });
        Button bSearch = new Button(topRight, 8);
        bSearch.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        bSearch.setText(Messages.TerminDialog_find);
        bSearch.setToolTipText(Messages.TerminDialog_findTermin);
        bSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TerminDialog.this.actKontakt != null) {
                    Query qbe = new Query(Termin.class);
                    qbe.add("Wer", "=", TerminDialog.this.actKontakt.getId());
                    qbe.add("deleted", "<>", "1");
                    if (!TerminDialog.this.bFuture.getSelection()) {
                        qbe.add("Tag", ">", new TimeTool().toString(9));
                    }
                    List list = qbe.execute();
                    if (TerminDialog.this.bFuture.getSelection()) {
                        list.sort(new Comparator<Termin>(){

                            @Override
                            public int compare(Termin t1, Termin t2) {
                                return t2.getStartTime().compareTo((Calendar)t1.getStartTime());
                            }
                        });
                    } else {
                        list.sort(new Comparator<Termin>(){

                            @Override
                            public int compare(Termin t1, Termin t2) {
                                return t1.getStartTime().compareTo((Calendar)t2.getStartTime());
                            }
                        });
                    }
                    TerminDialog.this.lTermine.clear();
                    TerminDialog.this.lTerminListe.removeAll();
                    if (list != null && list.size() > 0) {
                        for (Termin t : list) {
                            TerminDialog.this.lTermine.add(t);
                            String label = t.getLabel();
                            logger.info(label);
                            TerminDialog.this.lTerminListe.add(label);
                        }
                        TerminDialog.this.lTerminListe.select(0);
                    }
                }
            }
        });
        this.bPrint = new Button(topRight, 8);
        this.bPrint.setText(Messages.TerminDialog_print);
        this.bPrint.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.bPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd = cmdService.getCommand("ch.elexis.agenda.commands.printAppointmentLabel");
                if (!cmd.isDefined()) {
                    PrintAppointmentLabelHandler.setTermine(TerminDialog.this.lTermine);
                    cmd.define("Print Appointment", "Print Appointment Command", cmdCategory);
                }
                try {
                    cmd.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    logger.error("Failed to execute command ch.elexis.agenda.commands.printAppointmentLabel", (Throwable)ex);
                }
            }
        });
        this.bFuture = new Button(topRight, 32);
        this.bFuture.setText(Messages.TerminDialog_past);
        this.bEmergency = new Button(topRight, 32);
        this.bEmergency.setText(Messages.TerminDialog_emergency);
        Composite cBar = new Composite(ret, 2048);
        cBar.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        cBar.setLayout((Layout)new GridLayout());
        this.dayBar = new DayOverview(cBar);
        this.dayBar.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.slider = new Slider(this.dayBar);
        Composite cBottom = new Composite(ret, 2048);
        cBottom.setLayout((Layout)new GridLayout(3, false));
        cBottom.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(cBottom, 0).setText("PatientID");
        Composite cLinks = new Composite(cBottom, 0);
        cLinks.setLayout((Layout)new RowLayout(256));
        new Label(cLinks, 0).setText("Personalien ");
        Hyperlink hlText = new Hyperlink(cLinks, 0);
        hlText.setText(Messages.TerminDialog_enterPersonalia);
        hlText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                InputDialog inp = new InputDialog(TerminDialog.this.getShell(), Messages.TerminDialog_enterText, Messages.TerminDialog_enterFreeText, "", null);
                if (inp.open() == 0) {
                    TerminDialog.this.tName.setText(inp.getValue());
                    TerminDialog.this.tNr.setText("");
                    TerminDialog.this.actKontakt = null;
                }
            }
        });
        hlText.setForeground(UiDesk.getColor((String)"blau"));
        Hyperlink hlSelect = new Hyperlink(cLinks, 0);
        hlSelect.setForeground(UiDesk.getColor((String)"blau"));
        hlSelect.setText("(Kontakt ausw\u00e4hlen)");
        hlSelect.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(TerminDialog.this.getShell(), Kontakt.class, "Termin zuordnen", "Bitte suchen Sie aus, wer den Termin hat", Kontakt.DEFAULT_SORT);
                if (ksl.open() == 0) {
                    TerminDialog.this.actKontakt = (Kontakt)ksl.getSelection();
                    if (TerminDialog.this.actKontakt != null) {
                        String phoneEnhancedLabel = TerminDialog.this.getPhoneEnhancedLabel(TerminDialog.this.actKontakt);
                        TerminDialog.this.tName.setText(phoneEnhancedLabel);
                        TerminDialog.this.tNr.setText(TerminDialog.this.actKontakt.get("Kuerzel"));
                    }
                    TerminDialog.this.setEnablement();
                }
            }
        });
        new Label(cBottom, 0).setText(Messages.TerminDialog_Mandator);
        this.tNr = new Text(cBottom, 2056);
        this.tName = new Text(cBottom, 2056);
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbMandant = new Combo(cBottom, 4);
        this.cbMandant.setItems(this.agenda.getResources());
        this.cbMandant.setText(this.agenda.getActResource());
        this.cbMandant.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TerminDialog.this.setAll();
            }
        });
        Label lBem = new Label(cBottom, 0);
        lBem.setText(Messages.TerminDialog_remarks);
        lBem.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        this.tBem = new Text(cBottom, 2056);
        this.tBem.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
        new Label(cBottom, 0).setText(Messages.TerminDialog_typeandstate);
        Label lGrund = new Label(cBottom, 0);
        lGrund.setText(Messages.TerminDialog_reason);
        lGrund.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        this.cbTyp = new Combo(cBottom, 12);
        this.setItemTypes();
        Point pTyp = this.cbTyp.computeSize(-1, -1);
        this.tGrund = new Text(cBottom, 2050);
        this.tGrund.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)true));
        this.cbStatus = new Combo(cBottom, 12);
        this.cbStatus.setItems(Termin.TerminStatus);
        Point pStatus = this.cbStatus.computeSize(-1, -1);
        int xMax = Math.max(pTyp.x, pStatus.x);
        this.cbTyp.setLayoutData((Object)new GridData(xMax, -1));
        this.cbStatus.setLayoutData((Object)new GridData(xMax, -1));
        StatusTypListener statusTypListener = new StatusTypListener();
        this.cbTyp.addSelectionListener((SelectionListener)statusTypListener);
        this.cbStatus.addSelectionListener((SelectionListener)statusTypListener);
        String val = this.tMap.get(Termin.TerminTypes[1]);
        if (val == null) {
            val = this.tMap.get(Messages.TerminDialog_32);
        }
        this.niDauer.setValue(Integer.parseInt(val));
        this.bSerie.setEnabled(false);
        ret.setSize(ret.computeSize(-1, -1));
        return sc;
    }

    private void setItemTypes() {
        this.cbTyp.removeAll();
        String[] stringArray = Termin.TerminTypes;
        int n = Termin.TerminTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            String ts = this.tMap.get(t);
            if (ts == null || !ts.equals("0")) {
                this.cbTyp.add(t);
            }
            ++n2;
        }
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        this.setMessage(Messages.TerminDialog_editTermins);
        this.setTitleImage(Images.IMG_LOGO.getImage());
        this.getShell().setText(Messages.TerminDialog_termin);
        this.dayBar.recalc();
        if (this.actPlannable instanceof Termin) {
            this.lTerminListe.add(((Termin)this.actPlannable).getLabel());
            this.lTermine.add((Termin)this.actPlannable);
            this.lTerminListe.select(0);
        }
        if (this.actKontakt == null) {
            this.setTitle(Messages.TerminDialog_noPatSelected);
            this.tNr.setText("");
            if (this.actPlannable instanceof Termin) {
                this.tName.setText(((Termin)this.actPlannable).getPersonalia());
            } else {
                this.tName.setText("");
            }
            this.tBem.setText("");
        } else {
            this.setTitle(this.actKontakt.getLabel());
            this.tNr.setText("Kuerzel");
            String phoneEnhancedLabel = this.getPhoneEnhancedLabel(this.actKontakt);
            this.tName.setText(phoneEnhancedLabel);
            this.tBem.setText(this.actKontakt.getBemerkung());
        }
        this.setAll();
    }

    private void setAll() {
        this.tiVon.setTimeInMinutes(this.actPlannable.getStartMinute());
        this.dp.setDate(new TimeTool(this.actPlannable.getDay()).getTime());
        this.agenda.setActDate(new TimeTool(this.dp.getDate().getTime()));
        this.agenda.setActResource(this.cbMandant.getText());
        if (this.actPlannable instanceof Termin.Free) {
            this.setCombo(this.cbTyp, Termin.typStandard(), 0);
            this.setCombo(this.cbStatus, Termin.statusStandard(), 0);
            this.bChange.setEnabled(false);
            String dauer = this.tMap.get(Termin.typStandard());
            if (dauer == null) {
                dauer = this.tMap.get(Messages.TerminDialog_40);
            }
            if (dauer == null) {
                dauer = "15";
            }
            this.niDauer.setValue(Integer.parseInt(dauer));
        } else {
            Termin actTermin = (Termin)this.actPlannable;
            this.tGrund.setText(actTermin.getGrund());
            this.setCombo(this.cbTyp, actTermin.getType(), 0);
            this.setCombo(this.cbStatus, actTermin.getStatus(), 0);
            this.bLocked.setSelection(actTermin.getFlag((byte)4));
            this.niDauer.getControl().setSelection(this.actPlannable.getDurationInMinutes());
            this.bEmergency.setSelection(StringUtils.equals((String)actTermin.get("priority"), (String)"1"));
        }
        this.dayBar.redraw();
        this.slider.set();
    }

    public void setCollisionErrorLevel(CollisionErrorLevel level) {
        this.collisionErrorLevel = level;
    }

    private void enable(final boolean mode) {
        this.msg = Messages.TerminDialog_editTermins;
        if (this.collisionErrorLevel == CollisionErrorLevel.ERROR) {
            this.bChange.setEnabled(mode);
            this.bSave.setEnabled(mode);
            this.getButton(0).setEnabled(mode);
        }
        this.slider.setBackground(UiDesk.getColor((String)"hellgrau"));
        if (!mode) {
            this.slider.setBackground(UiDesk.getColor((String)"dunkelgrau"));
            this.msg = String.valueOf(Messages.TerminDialog_editTermins) + "\n\t" + Messages.TerminDialog_collision;
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TerminDialog.this.collisionErrorLevel == CollisionErrorLevel.ERROR) {
                    TerminDialog.this.setMessage(TerminDialog.this.msg, mode ? 0 : 3);
                } else if (TerminDialog.this.collisionErrorLevel == CollisionErrorLevel.WARNING) {
                    TerminDialog.this.setMessage(TerminDialog.this.msg, mode ? 0 : 2);
                }
            }
        });
    }

    private void setEnablement() {
        TimeSpan ts = new TimeSpan(this.tiVon.setTimeTool(this.agenda.getActDate()), this.niDauer.getValue());
        if (this.actPlannable instanceof Termin.Free) {
            if (Plannables.collides(ts, this.dayBar.list, null) || this.terminOverlaps(this.agenda.getActDate(), ts)) {
                this.enable(false);
            } else {
                this.enable(true);
            }
        } else if (Plannables.collides(ts, this.dayBar.list, (Termin)this.actPlannable)) {
            this.enable(false);
        } else if (this.bModified) {
            if (this.actKontakt != null && this.terminOverlaps(this.agenda.getActDate(), ts)) {
                this.enable(false);
                return;
            }
            this.enable(true);
        } else {
            this.enable(false);
        }
    }

    private void setCombo(Combo combo, String value, int def) {
        String[] elems = combo.getItems();
        int idx = StringTool.getIndex((String[])elems, (String)value);
        if (idx == -1) {
            idx = def;
        }
        combo.select(idx);
    }

    public void setTime(TimeTool time) {
        this.tiVon.setText(time.toString(3));
        this.slider.set();
    }

    protected void okPressed() {
        this.createTermin(false);
        super.okPressed();
    }

    private void createTermin(boolean bMulti) {
        int von = this.tiVon.getTimeAsMinutes();
        int bis = von + this.niDauer.getValue();
        String typ = this.cbTyp.getItem(this.cbTyp.getSelectionIndex());
        String status = this.cbStatus.getItem(this.cbStatus.getSelectionIndex());
        String priority = this.bEmergency.getSelection() ? "1" : "0";
        Termin actTermin = null;
        if (this.actPlannable instanceof Termin.Free) {
            Termin newTermin;
            actTermin = newTermin = new Termin(this.agenda.getActResource(), this.agenda.getActDate().toString(9), von, bis, typ, status, priority);
        } else {
            actTermin = (Termin)this.actPlannable;
            if (bMulti) {
                final Termin clonedTermin = (Termin)actTermin.clone();
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)clonedTermin, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                        clonedTermin.delete();
                    }

                    public void lockAcquired() {
                    }
                });
            }
            actTermin.set(new String[]{"BeiWem", "Tag", "Beginn", "Dauer", "Typ", "Status", "priority"}, new String[]{this.agenda.getActResource(), this.agenda.getActDate().toString(9), Integer.toString(von), Integer.toString(bis - von), typ, status, priority});
        }
        this.lTerminListe.add(actTermin.getLabel());
        this.lTermine.add(actTermin);
        final Termin lockTermin = actTermin;
        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)lockTermin, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                if (TerminDialog.this.actKontakt != null) {
                    lockTermin.setKontakt(TerminDialog.this.actKontakt);
                } else {
                    lockTermin.set("Wer", TerminDialog.this.tName.getText());
                }
                lockTermin.setGrund(TerminDialog.this.tGrund.getText());
                lockTermin.set("ErstelltVon", ElexisEventDispatcher.getSelected(User.class).getLabel());
                if (TerminDialog.this.bLocked.getSelection()) {
                    lockTermin.setFlag((byte)4);
                }
                ElexisEventDispatcher.reload(Termin.class);
            }
        });
        this.dayBar.recalc();
        this.actPlannable = actTermin;
        this.setEnablement();
    }

    private boolean terminOverlaps(TimeTool actDate, TimeSpan terminTS) {
        boolean avoidPatientDoubleBooking = CoreHub.localCfg.get("agenda/patient/doppelteTerminvergabeVermeiden", false);
        if (avoidPatientDoubleBooking && this.actKontakt != null) {
            Query tQuery = new Query(Termin.class);
            tQuery.add("Wer", "=", this.actKontakt.getId());
            tQuery.add("Tag", "=", actDate.toString(9));
            List termine = tQuery.execute();
            if (this.actPlannable instanceof Termin.Free) {
                for (Termin t : termine) {
                    TimeSpan ts = t.getTimeSpan();
                    if (ts.overlap(terminTS) == null) continue;
                    return true;
                }
            } else {
                Termin curTermin = (Termin)this.actPlannable;
                for (Termin t : termine) {
                    TimeSpan ts;
                    if (t.getId().equals(curTermin.getId()) || (ts = t.getTimeSpan()).overlap(terminTS) == null) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String getPhoneEnhancedLabel(Kontakt actKontakt) {
        String telephoneLabel = actKontakt.getTelephoneLabel();
        String label = String.valueOf(actKontakt.getLabel()) + (telephoneLabel.length() > 0 ? " (" + telephoneLabel + ")" : "");
        return label;
    }

    public static enum CollisionErrorLevel {
        ERROR,
        WARNING;

    }

    class DayOverview
    extends Composite
    implements PaintListener {
        Point d;
        int sep;
        List<IPlannable> list;

        DayOverview(Composite parent) {
            super(parent, 0);
            this.addPaintListener(this);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.y > DayOverview.this.sep + 2) {
                        ((DayOverview)DayOverview.this).TerminDialog.this.rasterIndex = ((DayOverview)DayOverview.this).TerminDialog.this.rasterIndex >= ((DayOverview)DayOverview.this).TerminDialog.this.rasterValues.length ? 0 : ((DayOverview)DayOverview.this).TerminDialog.this.rasterIndex + 1;
                        CoreHub.userCfg.set("agenda/dayView/raster", ((DayOverview)DayOverview.this).TerminDialog.this.rasterIndex);
                        DayOverview.this.redraw();
                    } else {
                        Point loc = ((DayOverview)DayOverview.this).TerminDialog.this.slider.getLocation();
                        ((DayOverview)DayOverview.this).TerminDialog.this.slider.setLocation(e.x, loc.y);
                        ((DayOverview)DayOverview.this).TerminDialog.this.slider.updateTimes();
                    }
                }
            });
        }

        void recalc() {
            this.list = Plannables.loadTermine(TerminDialog.this.agenda.getActResource(), TerminDialog.this.agenda.getActDate());
            TerminDialog.this.tagStart = TerminDialog.this.ts * 60;
            TerminDialog.this.tagEnd = TerminDialog.this.te * 60;
            int i = 0;
            IPlannable pi = this.list.get(i);
            TerminDialog.this.tagStart = pi.getType().equals(Termin.typReserviert()) ? (pi.getDurationInMinutes() < 31 ? 0 : pi.getDurationInMinutes() - 30) : 0;
            i = this.list.size() - 1;
            pi = this.list.get(i);
            int end = pi.getStartMinute() + pi.getDurationInMinutes();
            if (end < 1408) {
                TerminDialog.this.tagEnd = 1439;
            }
            if (TerminDialog.this.tagStart != 0) {
                TerminDialog.this.tagStart = TerminDialog.this.tagStart / 60 * 60;
            }
            if (TerminDialog.this.tagEnd < 1439) {
                TerminDialog.this.tagEnd = (TerminDialog.this.tagEnd + 30) / 60 * 60;
            }
            TerminDialog.this.minutes = TerminDialog.this.tagEnd - TerminDialog.this.tagStart;
            this.d = this.getSize();
            TerminDialog.this.pixelPerMinute = (double)this.d.x / TerminDialog.this.minutes;
            this.sep = this.d.y / 2;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(this.getParent().getSize().x, 40);
        }

        public void paintControl(PaintEvent pe) {
            this.recalc();
            GC g = pe.gc;
            Color def = g.getBackground();
            g.setBackground(UiDesk.getColor((String)"gruen"));
            Rectangle r = new Rectangle(0, 0, this.d.x, this.sep - 2);
            g.fillRectangle(r);
            for (IPlannable p : this.list) {
                Plannables.paint(g, p, r, TerminDialog.this.tagStart, TerminDialog.this.tagEnd);
            }
            g.setBackground(def);
            g.setFont(UiDesk.getFont((String)"anwender/smallfont"));
            g.drawLine(0, this.sep, this.d.x, this.sep);
            if (TerminDialog.this.rasterIndex >= TerminDialog.this.rasterValues.length) {
                TerminDialog.this.rasterIndex = 0;
                CoreHub.userCfg.set("agenda/dayView/raster", TerminDialog.this.rasterIndex);
            }
            double chunkwidth = (double)TerminDialog.this.rasterValues[TerminDialog.this.rasterIndex] * TerminDialog.this.pixelPerMinute;
            int chunksPerHour = 60 / TerminDialog.this.rasterValues[TerminDialog.this.rasterIndex];
            int ch = chunksPerHour - 1;
            int hr = TerminDialog.this.tagStart / 60;
            if (chunkwidth < 0.1) {
                return;
            }
            double x = 0.0;
            while (x <= (double)this.d.x) {
                int lx = (int)Math.round(x);
                if (++ch == chunksPerHour) {
                    g.drawLine(lx, this.sep - 1, lx, this.sep + 6);
                    g.drawString(Integer.toString(hr++), lx, this.sep + 6);
                    ch = 0;
                } else {
                    g.drawLine(lx, this.sep, lx, this.sep + 4);
                }
                x += chunkwidth;
            }
            TerminDialog.this.slider.redraw();
        }
    }

    private class Slider
    extends Composite
    implements MouseListener,
    MouseMoveListener {
        boolean isDragging;

        Slider(Composite parent) {
            super(parent, 2048);
            this.setBackground(UiDesk.getColor((String)"rot"));
            this.addMouseListener(this);
            this.addMouseMoveListener(this);
        }

        void set() {
            int v = TerminDialog.this.tiVon.getTimeAsMinutes();
            int d = TerminDialog.this.niDauer.getValue();
            Rectangle r = this.getParent().getBounds();
            int x = (int)Math.round((double)(v - TerminDialog.this.tagStart) * TerminDialog.this.pixelPerMinute);
            int w = (int)Math.round((double)d * TerminDialog.this.pixelPerMinute);
            this.setBounds(x, 0, w, r.height / 2);
            TerminDialog.this.tiBis.setTimeInMinutes(v + d);
            TerminDialog.this.bModified = true;
            TerminDialog.this.setEnablement();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.isDragging = true;
        }

        public void mouseUp(MouseEvent e) {
            if (this.isDragging) {
                this.isDragging = false;
                this.updateTimes();
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.isDragging) {
                Point loc = this.getLocation();
                int x = loc.x + e.x;
                this.setLocation(x, loc.y);
            }
        }

        public void updateTimes() {
            Point loc = this.getLocation();
            Rectangle rec = this.getParent().getBounds();
            double minutes = TerminDialog.this.tagEnd - TerminDialog.this.tagStart;
            double minutesPerPixel = minutes / (double)rec.width;
            int minute = (int)Math.round((double)loc.x * minutesPerPixel) + TerminDialog.this.tagStart;
            int raster = TerminDialog.this.rasterValues[TerminDialog.this.rasterIndex];
            minute = (minute + (raster >> 1)) / raster * raster;
            TerminDialog.this.tiVon.setTimeInMinutes(minute);
            this.set();
        }
    }

    class StatusTypListener
    extends SelectionAdapter {
        StatusTypListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource().equals(TerminDialog.this.cbTyp)) {
                String type = TerminDialog.this.cbTyp.getItem(TerminDialog.this.cbTyp.getSelectionIndex());
                if (TerminDialog.this.actPlannable instanceof Termin) {
                    ((Termin)TerminDialog.this.actPlannable).setType(type);
                    TerminDialog.this.bModified = true;
                } else if (TerminDialog.this.actPlannable instanceof Termin.Free) {
                    Hashtable<String, String> map = Plannables.getTimePrefFor(TerminDialog.this.agenda.getActResource());
                    String nt = map.get(type);
                    if (nt == null && (nt = map.get("std")) == null) {
                        nt = "10";
                    }
                    int en = Integer.parseInt(nt);
                    TerminDialog.this.niDauer.setValue(en);
                    TerminDialog.this.slider.set();
                }
            } else if (e.getSource().equals(TerminDialog.this.cbStatus) && TerminDialog.this.actPlannable instanceof Termin) {
                ((Termin)TerminDialog.this.actPlannable).setStatus(TerminDialog.this.cbStatus.getItem(TerminDialog.this.cbStatus.getSelectionIndex()));
                TerminDialog.this.bModified = true;
            }
            TerminDialog.this.setEnablement();
        }
    }
}

