/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.views.BaseAgendaView;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;

public class TagesView
extends BaseAgendaView {
    public static final String ID = "ch.elexis.agenda.tagesview";
    Button bDay;
    Button bToday;
    Button bPrint;
    Text tDetail;
    Label lCreator;

    public TagesView() {
        this.self = this;
    }

    @Override
    public void create(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(5, false));
        top.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bToday = new Button(top, 0x1800008);
        this.bToday.setImage(UiDesk.getImage((String)"ch.elexis.agenda.home"));
        this.bToday.setToolTipText(Messages.TagesView_showToday);
        this.bToday.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeTool dat = new TimeTool();
                TagesView.this.agenda.setActDate(dat);
                TagesView.this.updateDate();
            }
        });
        Button bMinus = new Button(top, 8);
        bMinus.setToolTipText(Messages.TagesView_previousDay);
        bMinus.setText("<");
        bMinus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.agenda.addDays(-1);
                TagesView.this.updateDate();
            }
        });
        this.bDay = new Button(top, 0x1800008);
        this.bDay.setToolTipText(Messages.TagesView_selectDay);
        this.bDay.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateSelectorDialog dsl = new DateSelectorDialog(TagesView.this.bDay.getShell(), TagesView.this.agenda.getActDate());
                dsl.create();
                Point m = UiDesk.getDisplay().getCursorLocation();
                dsl.getShell().setLocation(m.x, m.y);
                if (dsl.open() == 0) {
                    TimeTool dat = dsl.getSelectedDate();
                    TagesView.this.agenda.setActDate(dat);
                    TagesView.this.updateDate();
                }
            }
        });
        this.bDay.setText(this.agenda.getActDate().toString(4));
        Button bPlus = new Button(top, 8);
        bPlus.setToolTipText(Messages.TagesView_nextDay);
        bPlus.setText(">");
        bPlus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.agenda.addDays(1);
                TagesView.this.updateDate();
            }
        });
        Button bPrint = new Button(top, 0x1800008);
        bPrint.setImage(Images.IMG_PRINTER.getImage());
        bPrint.setToolTipText(Messages.TagesView_printDay);
        bPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.printAction.run();
            }
        });
        SashForm sash = new SashForm(parent, 512);
        sash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv = new TableViewer((Composite)sash, 0);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv.setLabelProvider((IBaseLabelProvider)new AgendaLabelProvider());
        this.tDetail = new Text((Composite)sash, 2114);
        this.lCreator = new Label(parent, 0);
        this.lCreator.setFont(UiDesk.getFont((String)"anwender/smallfont"));
        this.lCreator.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.lCreator.setText(" - ");
        sash.setWeights(new int[]{80, 20});
        this.makePrivateActions();
    }

    public void updateDate() {
        this.bDay.setText(String.valueOf(this.agenda.getActDate().toString(12)) + ", " + this.agenda.getActDate().toString(4));
        this.tv.refresh();
    }

    @Override
    public void setTermin(Termin tf) {
        Termin t = tf;
        StringBuilder sb = new StringBuilder(200);
        TimeSpan ts = t.getTimeSpan();
        sb.append(ts.from.toString(3)).append("-").append(ts.until.toString(3)).append(" ");
        if (t.isRecurringDate()) {
            sb.append(new SerienTermin(t).getRootTermin().getPersonalia());
        } else {
            sb.append(t.getPersonalia());
        }
        sb.append("\n(").append(t.getType()).append(",").append(t.getStatus()).append(")\n--------\n").append(t.getGrund());
        sb.append("\n--------\n").append(t.getStatusHistoryDesc());
        this.tDetail.setText(sb.toString());
        sb.setLength(0);
        sb.append(StringTool.unNull((String)t.get("ErstelltVon"))).append("/").append(t.getCreateTime().toString(0));
        this.lCreator.setText(sb.toString());
        this.agenda.dispatchTermin(t);
    }

    private void makePrivateActions() {
        this.newViewAction = new Action(Messages.TagesView_newWindow){

            public void run() {
                try {
                    TagesView.this.getViewSite().getPage().showView(TagesView.ID, StringTool.unique((String)"Agenda"), 2);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
    }

    class AgendaLabelProvider
    extends LabelProvider
    implements ITableColorProvider,
    ITableLabelProvider {
        AgendaLabelProvider() {
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable p = (IPlannable)element;
                return Plannables.getStatusColor(p);
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable p = (IPlannable)element;
                return SWTHelper.getContrast((Color)Plannables.getTypColor(p));
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable p = (IPlannable)element;
                if (p.isRecurringDate()) {
                    return UiDesk.getImage((String)"ch.elexis.agenda.series");
                }
                return Plannables.getTypImage(p);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                String[] tokens;
                String grund;
                IPlannable p = (IPlannable)element;
                StringBuilder sb = new StringBuilder();
                sb.append(Plannables.getStartTimeAsString(p)).append("-").append(Plannables.getEndTimeAsString(p)).append(" ");
                if (p.isRecurringDate()) {
                    sb.append(new SerienTermin(p).getRootTermin().getTitle());
                } else {
                    sb.append(p.getTitle());
                }
                if (CoreHub.userCfg.get("agenda/show_reason", false) && p instanceof Termin && !StringTool.isNothing((Object)(grund = ((Termin)p).getGrund())) && (tokens = grund.split("[\n\r]+")).length > 0) {
                    sb.append(", " + tokens[0]);
                }
                return sb.toString();
            }
            return "?";
        }
    }
}

