/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.actions.Activator;
import ch.elexis.actions.AgendaActions;
import ch.elexis.actions.IBereichSelectionEvent;
import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.data.ICalTransfer;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.data.TerminUtil;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.series.ui.SerienTerminDialog;
import ch.elexis.agenda.ui.BereichMenuCreator;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.dialogs.TagesgrenzenDialog;
import ch.elexis.dialogs.TerminDialog;
import ch.elexis.dialogs.TerminListeDruckenDialog;
import ch.elexis.dialogs.TermineDruckenDialog;
import ch.rgw.tools.Log;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class BaseAgendaView
extends ViewPart
implements Heartbeat.HeartListener,
IRefreshable,
IBereichSelectionEvent {
    protected SelectionListener sListen = new SelectionListener();
    TableViewer tv;
    BaseAgendaView self;
    protected LockRequestingRestrictedAction<Termin> terminAendernAction;
    protected LockRequestingRestrictedAction<Termin> terminKuerzenAction;
    protected LockRequestingRestrictedAction<Termin> terminVerlaengernAction;
    protected RestrictedAction newTerminAction;
    protected IAction blockAction;
    protected IAction dayLimitsAction;
    protected IAction newViewAction;
    protected IAction printAction;
    protected IAction exportAction;
    protected IAction importAction;
    protected IAction newTerminForAction;
    protected IAction printPatientAction;
    private BereichMenuCreator bmc = new BereichMenuCreator();
    MenuManager menu = new MenuManager();
    protected Log log = Log.get((String)"Agenda");
    Activator agenda = Activator.getDefault();
    private final ElexisEventListener eeli_termin = new ElexisUiEventListenerImpl(Termin.class, 8){

        public void runInUi(ElexisEvent ev) {
            if (BaseAgendaView.this.tv != null && this.isActiveControl(BaseAgendaView.this.tv.getControl()) && !BaseAgendaView.this.tv.getControl().isDisposed()) {
                BaseAgendaView.this.tv.refresh(true);
            }
        }
    };
    private final ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            BaseAgendaView.this.updateActions();
            if (BaseAgendaView.this.tv != null && this.isActiveControl(BaseAgendaView.this.tv.getControl())) {
                BaseAgendaView.this.tv.getControl().setFont(UiDesk.getFont((String)"anwender/stdfont"));
            }
            BaseAgendaView.this.setBereich(CoreHub.userCfg.get("agenda/bereich", BaseAgendaView.this.agenda.getActResource()));
        }
    };
    private IMenuManager mgr;
    private IAction bereichMenu;
    private long highestLastUpdate;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    protected BaseAgendaView() {
        this.self = this;
        BereichSelectionHandler.addBereichSelectionListener(this);
    }

    public abstract void create(Composite var1);

    public void createPartControl(Composite parent) {
        this.setBereich(this.agenda.getActResource());
        this.create(parent);
        this.makeActions();
        this.tv.setContentProvider((IContentProvider)new AgendaContentProvider());
        this.tv.setUseHashlookup(true);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IPlannable pl = BaseAgendaView.this.getSelection();
                if (pl == null) {
                    BaseAgendaView.this.newTerminAction.run();
                } else if (pl.isRecurringDate()) {
                    SerienTermin st = new SerienTermin(pl);
                    new SerienTerminDialog(UiDesk.getTopShell(), st).open();
                    BaseAgendaView.this.tv.refresh(true);
                } else {
                    if (pl instanceof Termin.Free) {
                        TerminDialog dlg = new TerminDialog(pl);
                        dlg.open();
                    } else {
                        BaseAgendaView.this.terminAendernAction.run();
                    }
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        });
        this.menu.setRemoveAllWhenShown(true);
        this.menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (ElexisEventDispatcher.getSelected(Termin.class) == null) {
                    manager.add((IAction)BaseAgendaView.this.newTerminAction);
                    manager.add(BaseAgendaView.this.blockAction);
                } else {
                    manager.add(AgendaActions.getTerminStatusAction());
                    manager.add(BaseAgendaView.this.terminKuerzenAction);
                    manager.add(BaseAgendaView.this.terminVerlaengernAction);
                    manager.add(BaseAgendaView.this.terminAendernAction);
                    manager.add(AgendaActions.getDelTerminAction());
                }
                BaseAgendaView.this.updateActions();
            }
        });
        Menu cMenu = this.menu.createContextMenu(this.tv.getControl());
        this.tv.getControl().setMenu(cMenu);
        CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_termin, this.eeli_user});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.tv.setInput((Object)this.getViewSite());
        this.updateActions();
        this.tv.addSelectionChangedListener((ISelectionChangedListener)this.sListen);
    }

    public IPlannable getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        IPlannable pl = (IPlannable)sel.getFirstElement();
        return pl;
    }

    public void dispose() {
        CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_termin, this.eeli_user});
        super.dispose();
    }

    public void setFocus() {
        this.tv.getControl().setFocus();
    }

    public void heartbeat() {
        long lastUpdate = Termin.getHighestLastUpdate((String)"AGNTERMINE");
        this.log.log("Heartbeat [" + lastUpdate + "]", 5);
        if (lastUpdate > this.highestLastUpdate) {
            this.highestLastUpdate = lastUpdate;
            this.refresh();
        }
    }

    public void refresh() {
        this.updateActions();
        this.eeli_termin.catchElexisEvent(new ElexisEvent(null, Termin.class, 8));
    }

    public void setBereich(String b) {
        this.agenda.setActResource(b);
    }

    public abstract void setTermin(Termin var1);

    protected void updateActions() {
        this.dayLimitsAction.setEnabled(CoreHub.acl.request(ACLContributor.CHANGE_DAYSETTINGS));
        this.newTerminAction.reflectRight();
        this.terminKuerzenAction.reflectRight();
        this.terminVerlaengernAction.reflectRight();
        this.terminAendernAction.reflectRight();
        AgendaActions.updateActions();
    }

    protected void makeActions() {
        this.dayLimitsAction = new Action(Messages.BaseAgendaView_dayLimits){

            public void run() {
                new TagesgrenzenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), BaseAgendaView.this.agenda.getActDate().toString(9), BaseAgendaView.this.agenda.getActResource()).open();
                BaseAgendaView.this.tv.refresh(true);
            }
        };
        this.dayLimitsAction.setId("ch.elexis.agenda.actions.dayLimitsAction");
        this.blockAction = new Action(Messages.TagesView_lockPeriod){

            public void run() {
                IPlannable p;
                IStructuredSelection sel = (IStructuredSelection)BaseAgendaView.this.tv.getSelection();
                if (sel != null && !sel.isEmpty() && (p = (IPlannable)sel.getFirstElement()) instanceof Termin.Free) {
                    new Termin(BaseAgendaView.this.agenda.getActResource(), BaseAgendaView.this.agenda.getActDate().toString(9), p.getStartMinute(), p.getDurationInMinutes() + p.getStartMinute(), Termin.typReserviert(), Termin.statusLeer());
                    ElexisEventDispatcher.reload(Termin.class);
                }
            }
        };
        this.terminAendernAction = new LockRequestingRestrictedAction<Termin>(ACLContributor.CHANGE_APPOINTMENTS, Messages.TagesView_changeTermin){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_changeThisTermin);
            }

            public Termin getTargetedObject() {
                return (Termin)ElexisEventDispatcher.getSelected(Termin.class);
            }

            public void doRun(final Termin element) {
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)element, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        TerminDialog dlg = new TerminDialog(element);
                        dlg.setCollisionErrorLevel(TerminDialog.CollisionErrorLevel.WARNING);
                        dlg.open();
                    }
                });
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.terminKuerzenAction = new LockRequestingRestrictedAction<Termin>(ACLContributor.CHANGE_APPOINTMENTS, Messages.TagesView_shortenTermin){

            public Termin getTargetedObject() {
                return (Termin)ElexisEventDispatcher.getSelected(Termin.class);
            }

            public void doRun(Termin element) {
                element.setDurationInMinutes(element.getDurationInMinutes() >> 1);
                ElexisEventDispatcher.reload(Termin.class);
            }
        };
        this.terminVerlaengernAction = new LockRequestingRestrictedAction<Termin>(ACLContributor.CHANGE_APPOINTMENTS, Messages.TagesView_enlargeTermin){

            public Termin getTargetedObject() {
                return (Termin)ElexisEventDispatcher.getSelected(Termin.class);
            }

            public void doRun(Termin t) {
                BaseAgendaView.this.agenda.setActDate(t.getDay());
                Termin n = Plannables.getFollowingTermin(BaseAgendaView.this.agenda.getActResource(), BaseAgendaView.this.agenda.getActDate(), t);
                if (n != null) {
                    t.setEndTime(n.getStartTime());
                    ElexisEventDispatcher.reload(Termin.class);
                }
            }
        };
        this.newTerminAction = new RestrictedAction(ACLContributor.CHANGE_DAYSETTINGS, Messages.TagesView_newTermin){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_createNewTermin);
            }

            public void doRun() {
                TerminDialog dlg = new TerminDialog(null);
                dlg.open();
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.newTerminForAction = new Action("Neuer Termin f\u00fcr..."){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText("Dialog zum Ausw\u00e4hlen eines Kontakts f\u00fcr den Termin \u00f6ffnen");
            }

            public void run() {
                KontaktSelektor ksl = new KontaktSelektor(BaseAgendaView.this.getSite().getShell(), Kontakt.class, "Terminvergabe", "Bitte w\u00e4hlen Sie aus, wer einen Termin braucht", Kontakt.DEFAULT_SORT);
                IPlannable sel = BaseAgendaView.this.getSelection();
                TerminDialog dlg = new TerminDialog(null);
                dlg.setCollisionErrorLevel(TerminDialog.CollisionErrorLevel.WARNING);
                dlg.open();
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.printAction = new Action(Messages.BaseAgendaView_printDayList){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseAgendaView_printListOfDay);
            }

            public void run() {
                IPlannable[] liste = Plannables.loadDay(BaseAgendaView.this.agenda.getActResource(), BaseAgendaView.this.agenda.getActDate());
                TerminListeDruckenDialog dlg = new TerminListeDruckenDialog(BaseAgendaView.this.getViewSite().getShell(), liste);
                dlg.open();
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.printPatientAction = new Action(Messages.BaseAgendaView_printPatAppointments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseAgendaView_printFutureAppsOfSelectedPatient);
            }

            public void run() {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient != null) {
                    Query qbe = new Query(Termin.class);
                    qbe.add("Wer", "=", patient.getId());
                    qbe.add("deleted", "<>", "1");
                    qbe.add("Tag", ">=", new TimeTool().toString(9));
                    qbe.orderBy(false, new String[]{"Tag", "Beginn"});
                    List list = qbe.execute();
                    if (list != null) {
                        boolean directPrint = CoreHub.localCfg.get("agenda/print/appointmentcard_directprint", false);
                        TermineDruckenDialog dlg = new TermineDruckenDialog(BaseAgendaView.this.getViewSite().getShell(), list.toArray(new Termin[0]));
                        if (directPrint) {
                            dlg.setBlockOnOpen(false);
                            dlg.open();
                            if (dlg.doPrint()) {
                                dlg.close();
                            } else {
                                SWTHelper.alert((String)Messages.BaseAgendaView_errorWhileprinting, (String)Messages.BaseAgendaView_errorHappendPrinting);
                            }
                        } else {
                            dlg.setBlockOnOpen(true);
                            dlg.open();
                        }
                    }
                }
            }
        };
        this.exportAction = new Action(Messages.BaseAgendaView_exportAgenda){
            {
                this.setToolTipText(Messages.BaseAgendaView_exportAppointsments);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doExport(BaseAgendaView.this.agenda.getActDate(), BaseAgendaView.this.agenda.getActDate(), BaseAgendaView.this.agenda.getActResource());
            }
        };
        this.importAction = new Action(Messages.BaseAgendaView_importAgenda){
            {
                this.setToolTipText(Messages.BaseAgendaView_importFromIcal);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doImport(BaseAgendaView.this.agenda.getActResource());
            }
        };
        this.bereichMenu = new Action(Messages.TagesView_bereich, 4){
            Menu mine;
            {
                this.setToolTipText(Messages.TagesView_selectBereich);
                this.setMenuCreator(BaseAgendaView.this.bmc);
            }
        };
        this.mgr = this.getViewSite().getActionBars().getMenuManager();
        this.mgr.add(this.bereichMenu);
        this.mgr.add(this.dayLimitsAction);
        this.mgr.add(this.newViewAction);
        this.mgr.add(this.exportAction);
        this.mgr.add(this.importAction);
        this.mgr.add(this.printAction);
        this.mgr.add(this.printPatientAction);
    }

    @Override
    public void bereichSelectionEvent(String bereich) {
        this.setPartName("Agenda " + bereich);
        ElexisEventDispatcher.reload(Termin.class);
        this.eeli_termin.catchElexisEvent(new ElexisEvent(null, Termin.class, 8));
    }

    class AgendaContentProvider
    implements IStructuredContentProvider {
        AgendaContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (CoreHub.acl.request(ACLContributor.DISPLAY_APPOINTMENTS)) {
                String resource = BaseAgendaView.this.agenda.getActResource();
                TimeTool date = BaseAgendaView.this.agenda.getActDate();
                TerminUtil.updateBoundaries(resource, date);
                return Plannables.loadDay(resource, date);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SelectionListener
    implements ISelectionChangedListener {
        StructuredViewer sv;

        SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (sel == null || sel.isEmpty()) {
                ElexisEventDispatcher.clearSelection(Termin.class);
            } else {
                Object o = sel.getFirstElement();
                if (o instanceof Termin) {
                    BaseAgendaView.this.setTermin((Termin)o);
                } else if (o instanceof Termin.Free) {
                    ElexisEventDispatcher.clearSelection(Termin.class);
                }
            }
        }
    }
}

