/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.TagesNachricht;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.views.BaseAgendaView;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class AgendaGross
extends BaseAgendaView {
    public static final String ID = "ch.elexis.agenda.largeview";
    public static final String CFG_VERTRELATION = "vertrelation";
    private static final String SEPARATOR = ",";
    private static final int[] DEFAULT_COLUMN_WIDTHS = new int[]{60, 60, 105, 80, 300, 200};
    DateTime calendar;
    Composite cButtons;
    Text dayMessage;
    Text terminDetail;
    Label lbDetails;
    Label lbDayString;
    private int[] sashWeights = null;
    private SashForm sash;
    private static Button[] bChange;
    private static final String[] columnTitles;

    static {
        columnTitles = new String[]{"von", "bis", "Typ", "Status", "Personalien", "Grund"};
    }

    public AgendaGross() {
        BereichSelectionHandler.addBereichSelectionListener(this);
    }

    @Override
    public void create(Composite parent) {
        int[] nArray;
        parent.setLayout((Layout)new GridLayout());
        this.cButtons = new Composite(parent, 2048);
        RowLayout rl = new RowLayout();
        this.cButtons.setLayout((Layout)rl);
        this.cButtons.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.sash = new SashForm(parent, 256);
        this.sash.setLayout((Layout)new GridLayout());
        this.sash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        String[] bereiche = CoreHub.globalCfg.get("agenda/bereiche", Messages.TagesView_14).split(SEPARATOR);
        ChangeBereichAdapter chb = new ChangeBereichAdapter();
        bChange = new Button[bereiche.length];
        int i = 0;
        while (i < bereiche.length) {
            AgendaGross.bChange[i] = new Button(this.cButtons, 16);
            bChange[i].setText(bereiche[i]);
            bChange[i].addSelectionListener((SelectionListener)chb);
            if (bereiche[i].equals(this.agenda.getActResource())) {
                bChange[i].setSelection(true);
            }
            ++i;
        }
        Composite ret = new Composite((Composite)this.sash, 0);
        Composite right = new Composite((Composite)this.sash, 2048);
        ret.setLayout((Layout)new GridLayout());
        right.setLayout((Layout)new GridLayout());
        right.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv = new TableViewer(ret, 65540);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.calendar = new DateTime(right, 1024);
        this.calendar.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.calendar.setDate(this.agenda.getActDate().get(1), this.agenda.getActDate().get(2), this.agenda.getActDate().get(5));
        Button bToday = new Button(right, 8);
        bToday.setText(Messages.AgendaGross_today);
        bToday.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        bToday.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TimeTool dat = new TimeTool();
                AgendaGross.this.agenda.setActDate(dat);
                AgendaGross.this.calendar.setDate(dat.get(1), dat.get(2), dat.get(5));
                AgendaGross.this.updateDate();
            }
        });
        this.dayMessage = SWTHelper.createText((Composite)right, (int)4, (int)512);
        GridData gd = (GridData)this.dayMessage.getLayoutData();
        gd.widthHint = this.calendar.computeSize((int)-1, (int)-1).x;
        this.dayMessage.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                String tx = AgendaGross.this.dayMessage.getText();
                TagesNachricht tn = TagesNachricht.load(AgendaGross.this.agenda.getActDate());
                if (tn.exists()) {
                    tn.setLangtext(tx);
                } else {
                    tn = new TagesNachricht(AgendaGross.this.agenda.getActDate(), " - ", tx);
                }
            }
        });
        this.terminDetail = SWTHelper.createText((Composite)right, (int)5, (int)0);
        this.terminDetail.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.lbDetails = new Label(right, 64);
        this.lbDetails.setText("-");
        this.lbDetails.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.lbDayString = new Label(ret, 0);
        this.tv.setLabelProvider((IBaseLabelProvider)new AgendaLabelProvider());
        Table table = this.tv.getTable();
        int[] columnWidths = this.loadColumnWidths();
        int i2 = 0;
        while (i2 < columnTitles.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(columnTitles[i2]);
            tc.setWidth(columnWidths[i2]);
            ++i2;
        }
        table.setHeaderVisible(true);
        this.makePrivateActions();
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LocalDate localDate = LocalDate.of(AgendaGross.this.calendar.getYear(), AgendaGross.this.calendar.getMonth() + 1, AgendaGross.this.calendar.getDay());
                AgendaGross.this.agenda.setActDate(new TimeTool(localDate));
                AgendaGross.this.updateDate();
            }
        });
        if (this.sashWeights == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 70;
            nArray = nArray2;
            nArray2[1] = 30;
        } else {
            nArray = this.sashWeights;
        }
        this.sash.setWeights(nArray);
        this.tv.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AgendaGross.this.saveColumnSizes();
            }
        });
        this.initialize();
    }

    protected void initialize() {
        this.setDayMessage();
    }

    protected void setDayMessage() {
        TagesNachricht tn = TagesNachricht.load(this.agenda.getActDate());
        this.lbDayString.setText("");
        this.dayMessage.setText("");
        if (tn.exists()) {
            this.lbDayString.setText(tn.getZeile());
            this.dayMessage.setText(tn.getLangtext());
        }
    }

    protected void updateDate() {
        this.setDayMessage();
        this.tv.refresh();
        this.tv.getTable().getColumn(0).pack();
    }

    private void saveColumnSizes() {
        if (CoreHub.userCfg.get("agenda/big/savecolumnwidth", true)) {
            TableColumn[] columns;
            StringBuilder sb = new StringBuilder();
            TableColumn[] tableColumnArray = columns = this.tv.getTable().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                sb.append(tc.getWidth());
                sb.append(SEPARATOR);
                ++n2;
            }
            CoreHub.userCfg.set("agenda/big/columnwidth", sb.toString());
        }
    }

    private int[] loadColumnWidths() {
        int[] colWidth = DEFAULT_COLUMN_WIDTHS;
        if (CoreHub.userCfg.get("agenda/big/savecolumnwidth", true)) {
            String defaultColWidths = Arrays.toString(DEFAULT_COLUMN_WIDTHS).replace("[", "").replace("]", "");
            String userColWidths = CoreHub.userCfg.get("agenda/big/columnwidth", defaultColWidths);
            String[] widthStrings = userColWidths.split(SEPARATOR);
            int i = 0;
            while (i < widthStrings.length) {
                colWidth[i] = Integer.parseInt(widthStrings[i].trim());
                ++i;
            }
        }
        return colWidth;
    }

    @Override
    public void setTermin(Termin t) {
        Kontakt pat = t.getKontakt();
        StringBuilder sb = new StringBuilder(200);
        TimeSpan ts = t.getTimeSpan();
        sb.append(ts.from.toString(3)).append("-").append(ts.until.toString(3)).append(" ");
        if (t.isRecurringDate()) {
            sb.append(new SerienTermin(t).getRootTermin().getPersonalia());
        } else {
            sb.append(t.getPersonalia());
        }
        sb.append("\n(").append(t.getType()).append(SEPARATOR).append(t.getStatus()).append(")\n--------\n").append(t.getGrund());
        this.terminDetail.setText(sb.toString());
        sb.setLength(0);
        sb.append(StringTool.unNull((String)t.get("ErstelltVon"))).append("/").append(t.getCreateTime().toString(0));
        this.lbDetails.setText(sb.toString());
        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)t);
        if (pat != null) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)pat);
        }
    }

    private void makePrivateActions() {
        this.newViewAction = new Action(Messages.AgendaGross_newWindow){

            public void run() {
                try {
                    AgendaGross.this.getViewSite().getPage().showView(AgendaGross.ID, StringTool.unique((String)"Agenda"), 2);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
    }

    @Override
    public void bereichSelectionEvent(String bereich) {
        super.bereichSelectionEvent(bereich);
        Button[] buttonArray = bChange;
        int n = bChange.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            if (!b.isDisposed()) {
                if (b.getText().equalsIgnoreCase(bereich)) {
                    b.setSelection(true);
                } else {
                    b.setSelection(false);
                }
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        int[] w = this.sash.getWeights();
        memento.putString(CFG_VERTRELATION, String.valueOf(Integer.toString(w[0])) + SEPARATOR + Integer.toString(w[1]));
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento == null) {
            this.sashWeights = new int[]{70, 30};
        } else {
            String state = memento.getString(CFG_VERTRELATION);
            if (state == null) {
                state = "70,30";
            }
            String[] sw = state.split(SEPARATOR);
            this.sashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
        }
        super.init(site, memento);
    }

    private class AgendaLabelProvider
    extends LabelProvider
    implements ITableColorProvider,
    ITableLabelProvider {
        private AgendaLabelProvider() {
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable p = (IPlannable)element;
                if (columnIndex == 3) {
                    return Plannables.getStatusColor(p);
                }
                return Plannables.getTypColor(p);
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable p = (IPlannable)element;
                if (columnIndex == 3) {
                    return SWTHelper.getContrast((Color)Plannables.getStatusColor(p));
                }
                return SWTHelper.getContrast((Color)Plannables.getTypColor(p));
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IPlannable ip;
            if (columnIndex != 4) {
                return null;
            }
            if (element instanceof IPlannable && (ip = (IPlannable)element).isRecurringDate()) {
                return UiDesk.getImage((String)"ch.elexis.agenda.series");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IPlannable) {
                IPlannable ip = (IPlannable)element;
                switch (columnIndex) {
                    case 0: {
                        return Plannables.getStartTimeAsString(ip);
                    }
                    case 1: {
                        return Plannables.getEndTimeAsString(ip);
                    }
                    case 2: {
                        return ip.getType();
                    }
                    case 3: {
                        return ip.getStatus();
                    }
                    case 4: {
                        return ip.isRecurringDate() ? new SerienTermin(ip).getRootTermin().getTitle() : ip.getTitle();
                    }
                    case 5: {
                        if (ip instanceof Termin) {
                            String[] tokens;
                            Termin termin = (Termin)ip;
                            String grund = termin.getGrund();
                            if (grund != null && (tokens = grund.split("[\r\n]+")).length > 0) {
                                grund = tokens[0];
                            }
                            return grund == null ? "" : grund;
                        }
                        return "";
                    }
                }
            }
            return "?";
        }
    }

    private class ChangeBereichAdapter
    extends SelectionAdapter {
        private ChangeBereichAdapter() {
        }

        public void widgetSelected(SelectionEvent ev) {
            Button source = (Button)ev.getSource();
            String bereich = source.getText();
            AgendaGross.this.setBereich(bereich);
            AgendaGross.this.tv.refresh();
        }
    }
}

