/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui.week;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.ui.BaseView;
import ch.elexis.agenda.ui.IAgendaLayout;
import ch.elexis.agenda.ui.TerminLabel;
import ch.elexis.agenda.ui.week.AgendaWeek;
import ch.elexis.agenda.ui.week.ColumnHeader;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Query;
import ch.elexis.dialogs.TerminDialog;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ProportionalSheet
extends Composite
implements IAgendaLayout {
    static final int LEFT_OFFSET_DEFAULT = 20;
    static final int PADDING_DEFAULT = 5;
    int left_offset;
    int padding;
    private AgendaWeek view;
    private MenuManager contextMenuManager;
    private List<TerminLabel> tlabels;
    private double ppm;
    private int sheetHeight;
    private String[] resources;
    private int textWidth;
    private double sheetWidth;
    private double widthPerColumn;

    public ProportionalSheet(Composite parent, AgendaWeek v) {
        super(parent, 262144);
        this.view = v;
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProportionalSheet.this.layout();
                ProportionalSheet.this.recalc();
            }
        });
        this.addPaintListener(new TimePainter());
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String startOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
                int sodtHours = Integer.parseInt(startOfDayTimeInMinutes.substring(0, 2));
                int sodtMinutes = Integer.parseInt(startOfDayTimeInMinutes.substring(2));
                int minute = (int)Math.round((double)e.y / ProportionalSheet.this.ppm);
                TimeTool tt = new TimeTool(Activator.getDefault().getActDate());
                int hour = minute / 60;
                minute -= 60 * hour;
                int raster = 15;
                minute = (minute + (raster >> 1)) / raster * raster;
                tt.set(9, 0);
                tt.set(10, hour + sodtHours);
                tt.set(12, minute + sodtMinutes);
                TerminDialog dlg = new TerminDialog(null);
                dlg.create();
                dlg.setTime(tt);
                if (dlg.open() == 0) {
                    ProportionalSheet.this.refresh();
                }
            }

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }
        });
        this.left_offset = 20;
        this.padding = 5;
    }

    private boolean isBetween(int x, double lower, double upper) {
        int y = (int)Math.round(lower);
        int z = (int)Math.round(upper);
        return x >= y && x <= z;
    }

    @Override
    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void clear() {
        while (this.tlabels != null && this.tlabels.size() > 0) {
            this.tlabels.remove(0).dispose();
        }
        this.recalc();
    }

    synchronized void refresh() {
        String[] days = this.view.getDisplayedDays();
        Query qbe = new Query(Termin.class);
        qbe.add("BeiWem", "=", Activator.getDefault().getActResource());
        qbe.startGroup();
        String[] stringArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            String date = stringArray[n2];
            qbe.add("Tag", "=", date);
            qbe.or();
            ++n2;
        }
        qbe.endGroup();
        List apps = qbe.execute();
        if (this.tlabels != null) {
            for (TerminLabel terminLabel : this.tlabels) {
                terminLabel.dispose();
            }
            this.tlabels.clear();
        } else {
            this.tlabels = new LinkedList<TerminLabel>();
        }
        for (Termin termin : apps) {
            String dStart = termin.getDay();
            int idx = StringTool.getIndex((String[])days, (String)dStart);
            if (idx == -1) continue;
            TerminLabel terminLabel = new TerminLabel(this);
            terminLabel.set(termin, idx);
            this.tlabels.add(terminLabel);
        }
        TerminLabel.checkAllCollisions(this.tlabels);
        this.recalc();
    }

    void recalc() {
        if (this.tlabels != null) {
            this.ppm = BaseView.getPixelPerMinute();
            String startOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
            int sodtHours = Integer.parseInt(startOfDayTimeInMinutes.substring(0, 2));
            int sodtMinutes = Integer.parseInt(startOfDayTimeInMinutes.substring(2));
            int sodtM = sodtHours * 60;
            String endOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
            int eodtHours = Integer.parseInt(endOfDayTimeInMinutes.substring(0, 2));
            int eodtMinutes = Integer.parseInt(endOfDayTimeInMinutes.substring(2));
            int eodtM = eodtHours * 60;
            this.sheetHeight = (int)Math.round(this.ppm * (double)((eodtM += eodtMinutes) - (sodtM += sodtMinutes)));
            ScrolledComposite sc = (ScrolledComposite)this.getParent();
            Point mySize = this.getSize();
            if ((double)mySize.x > 0.0) {
                if (mySize.y != this.sheetHeight) {
                    this.setSize(mySize.x, this.sheetHeight);
                    sc.setMinSize(this.getSize());
                }
                ScrollBar bar = sc.getVerticalBar();
                int barWidth = 14;
                if (bar != null) {
                    barWidth = bar.getSize().x;
                }
                this.resources = this.view.getDisplayedDays();
                int count = this.resources.length;
                Point textSize = SWTHelper.getStringBounds((Composite)this, (String)"88:88");
                this.textWidth = textSize.x;
                this.left_offset = this.textWidth + 2;
                this.sheetWidth = mySize.x - 2 * this.left_offset - barWidth;
                this.widthPerColumn = this.sheetWidth / (double)count;
                ColumnHeader header = this.view.getHeader();
                header.recalc(this.widthPerColumn, this.left_offset, this.padding, textSize.y);
                for (TerminLabel l : this.tlabels) {
                    l.refresh();
                }
                sc.layout();
            }
        }
    }

    @Override
    public double getPixelPerMinute() {
        return this.ppm;
    }

    @Override
    public double getWidthPerColumn() {
        return this.widthPerColumn;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public int getLeftOffset() {
        return this.left_offset;
    }

    @Override
    public Composite getComposite() {
        return this;
    }

    class TimePainter
    implements PaintListener {
        TimePainter() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.fillRectangle(e.x, e.y, e.width, e.height);
            int y = 0;
            TimeTool runner = new TimeTool();
            String dayStartsAt = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
            runner.set(dayStartsAt);
            String dayEndsAt = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
            TimeTool limit = new TimeTool(dayEndsAt);
            Point textSize = gc.textExtent("88:88");
            int textwidth = textSize.x;
            int quarter = (int)Math.round(15.0 * BaseView.getPixelPerMinute());
            int w = ProportionalSheet.this.getSize().x - 5;
            int left = 0;
            int right = w - textwidth;
            while (runner.isBefore(limit)) {
                gc.drawLine(left, y, w, y);
                String time = runner.toString(3);
                gc.drawText(time, 0, y + 1);
                gc.drawText(time, right, y + 1);
                gc.drawLine(textwidth - 3, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 3, y);
                gc.drawLine(textwidth - 6, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 6, y);
                gc.drawLine(textwidth - 3, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 3, y);
                y += quarter;
                runner.addHours(1);
            }
        }
    }
}

