/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui.week;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.ui.week.AgendaWeek;
import ch.elexis.agenda.ui.week.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ColumnHeader
extends Composite {
    AgendaWeek view;
    static final String IMG_PERSONS_NAME = "ch.elexis.agenda/personen";
    static final String IMG_PERSONS_PATH = "icons/personen.png";
    ImageHyperlink ihRes;

    public ColumnHeader(Composite parent, AgendaWeek aw) {
        super(parent, 0);
        this.view = aw;
        if (UiDesk.getImage((String)IMG_PERSONS_NAME) == null) {
            UiDesk.getImageRegistry().put(IMG_PERSONS_NAME, Activator.getImageDescriptor(IMG_PERSONS_PATH));
        }
        this.ihRes = new ImageHyperlink((Composite)this, 0);
        this.ihRes.setImage(UiDesk.getImage((String)IMG_PERSONS_NAME));
        this.ihRes.setToolTipText(Messages.ColumnHeader_selectDaysToDisplay);
        this.ihRes.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new SelectDaysDlg().open();
            }
        });
    }

    void recalc(double widthPerColumn, int left_offset, int padding, int textSize) {
        GridData gd = (GridData)this.getLayoutData();
        gd.heightHint = textSize + 2;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                c.dispose();
            }
            ++n2;
        }
        Point bSize = this.ihRes.computeSize(-1, -1);
        this.ihRes.setBounds(0, 0, bSize.x, bSize.y);
        String[] labels = this.view.getDisplayedDays();
        int count = labels.length;
        int i = 0;
        while (i < count) {
            int lx = left_offset + (int)Math.round((double)i * (widthPerColumn + (double)padding));
            Label l = new Label((Composite)this, 0);
            TimeTool tt = new TimeTool(labels[i]);
            StringBuilder sb = new StringBuilder(tt.toString(12));
            sb.append(", ").append(tt.toString(4));
            String coltext = sb.toString();
            Point extend = SWTHelper.getStringBounds((Composite)this, (String)coltext);
            if ((double)extend.x > widthPerColumn) {
                coltext = coltext.substring(0, coltext.length() - 4);
                extend = SWTHelper.getStringBounds((Composite)this, (String)coltext);
                if ((double)extend.x > widthPerColumn) {
                    coltext = coltext.substring(0, 2);
                }
            }
            l.setText(coltext);
            int outer = (int)Math.round(widthPerColumn);
            int inner = l.computeSize((int)-1, (int)-1).x;
            int off = (outer - inner) / 2;
            l.setBounds(lx += off, 0, inner, textSize + 2);
            ++i;
        }
    }

    class SelectDaysDlg
    extends TitleAreaDialog {
        SelectDaysDlg() {
            super(ColumnHeader.this.getShell());
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ret.setLayout((Layout)new GridLayout());
            String resources = CoreHub.localCfg.get("agenda/wochenanzeige/tagezeigen", StringTool.join((String[])TimeTool.Wochentage, (String)","));
            String[] daysSelected = resources.split(",");
            TimeTool.DAYS[] dAYSArray = TimeTool.DAYS.values();
            int n = dAYSArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeTool.DAYS day = dAYSArray[n2];
                Button b = new Button(ret, 32);
                b.setText(day.fullName);
                b.setSelection(false);
                b.setData((Object)day.numericDayValue);
                String[] stringArray = daysSelected;
                int n3 = daysSelected.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray[n4];
                    if (string.toLowerCase().equalsIgnoreCase(day.fullName.toLowerCase())) {
                        b.setSelection(true);
                    }
                    ++n4;
                }
                ++n2;
            }
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.ColumnHeader_configureDisplay);
            this.setTitle(Messages.ColumnHeader_displayWeekdays);
            this.setMessage(Messages.ColumnHeader_pleaseSelectWeekdays);
        }

        protected void okPressed() {
            Composite dlg = (Composite)this.getDialogArea();
            String[] res = TimeTool.Wochentage;
            ArrayList<String> sel = new ArrayList<String>(res.length);
            Control[] controlArray = dlg.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Button && ((Button)c).getSelection()) {
                    int dayValue = (Integer)((Button)c).getData();
                    sel.add(TimeTool.DAYS.valueOf((int)dayValue).fullName);
                }
                ++n2;
            }
            ColumnHeader.this.view.clear();
            CoreHub.localCfg.set("agenda/wochenanzeige/tagezeigen", StringTool.join(sel, (String)","));
            ColumnHeader.this.view.refresh();
            super.okPressed();
        }
    }
}

