/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui.week;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.ui.BaseView;
import ch.elexis.agenda.ui.week.ColumnHeader;
import ch.elexis.agenda.ui.week.Messages;
import ch.elexis.agenda.ui.week.ProportionalSheet;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AgendaWeek
extends BaseView {
    private IAction weekFwdAction;
    private IAction weekBackAction;
    private IAction showCalendarAction;
    private ProportionalSheet sheet;
    private ColumnHeader header;

    public ColumnHeader getHeader() {
        return this.header;
    }

    @Override
    protected void create(Composite parent) {
        this.makePrivateActions();
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        wrapper.setLayout((Layout)new GridLayout());
        this.header = new ColumnHeader(wrapper, this);
        this.header.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        ScrolledComposite bounding = new ScrolledComposite(wrapper, 512);
        bounding.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.sheet = new ProportionalSheet((Composite)bounding, this);
        bounding.setContent((Control)this.sheet);
        bounding.setMinSize(this.sheet.computeSize(-1, -1));
        bounding.setExpandHorizontal(true);
        bounding.setExpandVertical(true);
        TimeTool tt = new TimeTool();
        String[] stringArray = this.getDisplayedDays();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            tt.set(s);
            this.checkDay(null, tt);
            ++n2;
        }
    }

    void clear() {
        this.sheet.clear();
    }

    @Override
    protected IPlannable getSelection() {
        return null;
    }

    @Override
    protected void refresh() {
        TimeTool ttMonday = this.agenda.getActDate();
        ttMonday.set(7, 2);
        StringBuilder sb = new StringBuilder(ttMonday.toString(4));
        ttMonday.addDays(6);
        sb.append("-").append(ttMonday.toString(4));
        this.showCalendarAction.setText(sb.toString());
        this.sheet.refresh();
    }

    public void setFocus() {
        this.refresh();
    }

    public String[] getDisplayedDays() {
        TimeTool ttMonday = Activator.getDefault().getActDate();
        ttMonday.set(7, 2);
        ttMonday.chop(3);
        String resources = CoreHub.localCfg.get("agenda/wochenanzeige/tagezeigen", StringTool.join((String[])TimeTool.Wochentage, (String)","));
        if (resources == null) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>(resources.length());
        TimeTool.DAYS[] dAYSArray = TimeTool.DAYS.values();
        int n = dAYSArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeTool.DAYS wd = dAYSArray[n2];
            if (resources.indexOf(wd.fullName) != -1) {
                ret.add(ttMonday.toString(9));
            }
            ttMonday.addDays(1);
            ++n2;
        }
        return ret.toArray(new String[0]);
    }

    private void makePrivateActions() {
        this.weekFwdAction = new Action(Messages.AgendaWeek_weekForward){
            {
                this.setToolTipText(Messages.AgendaWeek_showNextWeek);
                this.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
            }

            public void run() {
                AgendaWeek.this.agenda.addDays(7);
                TimeTool tt = new TimeTool();
                String[] stringArray = AgendaWeek.this.getDisplayedDays();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    tt.set(s);
                    AgendaWeek.this.checkDay(null, tt);
                    ++n2;
                }
                AgendaWeek.this.refresh();
            }
        };
        this.weekBackAction = new Action(Messages.AgendaWeek_weekBackward){
            {
                this.setToolTipText(Messages.AgendaWeek_showPreviousWeek);
                this.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
            }

            public void run() {
                AgendaWeek.this.agenda.addDays(-7);
                TimeTool tt = new TimeTool();
                String[] stringArray = AgendaWeek.this.getDisplayedDays();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    tt.set(s);
                    AgendaWeek.this.checkDay(null, tt);
                    ++n2;
                }
                AgendaWeek.this.refresh();
            }
        };
        this.showCalendarAction = new Action(Messages.AgendaWeek_selectWeek){
            {
                this.setToolTipText(Messages.AgendaWeek_showCalendarToSelect);
            }

            public void run() {
                DateSelectorDialog dsl = new DateSelectorDialog(AgendaWeek.this.getViewSite().getShell(), AgendaWeek.this.agenda.getActDate());
                if (dsl.open() == 0) {
                    AgendaWeek.this.agenda.setActDate(dsl.getSelectedDate());
                    TimeTool tt = new TimeTool();
                    String[] stringArray = AgendaWeek.this.getDisplayedDays();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        tt.set(s);
                        AgendaWeek.this.checkDay(null, tt);
                        ++n2;
                    }
                    AgendaWeek.this.refresh();
                }
            }
        };
        Action zoomAction = new Action(Messages.AgendaWeek_zoom, 4){
            Menu mine;
            {
                this.setToolTipText(Messages.AgendaWeek_setZoomFactor);
                this.setImageDescriptor(Activator.getImageDescriptor("icons/zoom.png"));
                this.setMenuCreator(new IMenuCreator(){

                    public void dispose() {
                        mine.dispose();
                    }

                    public Menu getMenu(Control parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        return mine;
                    }

                    public Menu getMenu(Menu parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        return mine;
                    }
                });
            }

            private void fillMenu() {
                String currentFactorString = CoreHub.localCfg.get("agenda/proportional/pixelperminute", "0.4");
                int currentFactor = (int)(Float.parseFloat(currentFactorString) * 100.0f);
                String[] stringArray = new String[]{"40", "60", "80", "100", "120", "140", "160", "200", "300"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    MenuItem it = new MenuItem(this.mine, 16);
                    it.setText(String.valueOf(s) + "%");
                    it.setData((Object)s);
                    it.setSelection(Integer.parseInt(s) == currentFactor);
                    it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MenuItem mi = (MenuItem)e.getSource();
                            int scale = Integer.parseInt(mi.getText().split("%")[0]);
                            double factor = (double)scale / 100.0;
                            CoreHub.localCfg.set("agenda/proportional/pixelperminute", Double.toString(factor));
                            AgendaWeek.this.sheet.recalc();
                        }
                    });
                    ++n2;
                }
            }
        };
        IToolBarManager tmr = this.getViewSite().getActionBars().getToolBarManager();
        tmr.add((IContributionItem)new Separator());
        tmr.add(this.weekBackAction);
        tmr.add(this.showCalendarAction);
        tmr.add(this.weekFwdAction);
        tmr.add((IContributionItem)new Separator());
        tmr.add((IAction)zoomAction);
    }
}

