/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.agenda.ui.provider.TerminListSorter;
import ch.elexis.agenda.ui.provider.TerminListWidgetProvider;
import ch.elexis.agenda.ui.provider.TermineLabelProvider;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultContentProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.dialogs.TerminDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class TerminListeView
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.agenda.Terminliste";
    ScrolledForm form;
    CommonViewer cv = new CommonViewer();
    LockRequestingRestrictedAction<Termin> terminAendernAction;
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 48){

        public void runInUi(ElexisEvent ev) {
            if (ev.getType() == 16) {
                TerminListeView.this.updateSelection((Patient)ev.getObject());
            } else if (ev.getType() == 32) {
                TerminListeView.this.form.setText(Messages.TerminListView_noPatientSelected);
            }
        }
    };
    private ElexisEventListener eeli_term = new ElexisUiEventListenerImpl(Termin.class, 4){

        public void runInUi(ElexisEvent ev) {
            if (TerminListeView.this.cv != null) {
                TerminListeView.this.cv.notify(CommonViewer.Message.update);
            }
        }
    };

    public TerminListeView() {
        this.terminAendernAction = new LockRequestingRestrictedAction<Termin>(ACLContributor.CHANGE_APPOINTMENTS, ch.elexis.agenda.Messages.TagesView_changeTermin){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(ch.elexis.agenda.Messages.TagesView_changeThisTermin);
            }

            public Termin getTargetedObject() {
                return (Termin)ElexisEventDispatcher.getSelected(Termin.class);
            }

            public void doRun(final Termin element) {
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)element, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        TerminDialog dlg = new TerminDialog(element);
                        dlg.open();
                    }
                });
                if (TerminListeView.this.cv != null) {
                    TerminListeView.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new DefaultContentProvider(this.cv, Termin.class){

            public Object[] getElements(Object inputElement) {
                Patient p = ElexisEventDispatcher.getSelectedPatient();
                Query qbe = new Query(Termin.class);
                if (p == null) {
                    qbe.add("Wer", "=", "--");
                } else {
                    qbe.add("Wer", "=", p.getId());
                    qbe.orderBy(false, new String[]{"Tag"});
                }
                return qbe.execute().toArray();
            }
        }, (LabelProvider)new TermineLabelProvider(), (ViewerConfigurer.WidgetProvider)new TerminListWidgetProvider());
        this.cv.create(vc, body, 0, (Object)this);
        this.cv.getConfigurer().getContentProvider().startListening();
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                TerminListeView.this.terminAendernAction.run();
            }
        });
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    public void activation(boolean mode) {
        if (mode) {
            this.updateSelection(ElexisEventDispatcher.getSelectedPatient());
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_term});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_term});
        }
    }

    private void updateSelection(Patient patient) {
        if (patient == null) {
            this.form.setText(Messages.TerminListView_noPatientSelected);
        } else {
            this.form.setText(patient.getLabel());
            this.cv.notify(CommonViewer.Message.update);
        }
    }

    public void sort(int sortDirection) {
        TerminListSorter sorter = new TerminListSorter();
        sorter.setDirection(sortDirection);
        this.cv.getViewerWidget().setSorter((ViewerSorter)sorter);
    }
}

