/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.actions.AgendaActions;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.series.ui.SerienTerminDialog;
import ch.elexis.agenda.ui.IAgendaLayout;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.dialogs.TerminDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TerminLabel
extends Composite {
    private Label lbl;
    private Termin t;
    private SerienTermin serienTermin;
    private int column;
    private Composite state;
    private int originalFontHeightPixel;
    private int originalFontHeightPoint;
    private FontData lblFontData;
    IAgendaLayout ial;
    Activator agenda = Activator.getDefault();
    private IAction terminKuerzenAction;
    private IAction terminVerlaengernAction;
    private IAction terminAendernAction;
    private GC lblGc;
    private List<TerminLabel> overLapped;
    private static HashMap<Integer, Font> fontMap = new HashMap();

    public TerminLabel(IAgendaLayout al) {
        super(al.getComposite(), 2048);
        this.ial = al;
        this.makeActions();
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        this.setLayout((Layout)gl);
        this.lbl = new Label((Composite)this, 64);
        this.lblGc = new GC((Drawable)this.lbl);
        this.lblFontData = this.lbl.getFont().getFontData()[0];
        this.originalFontHeightPoint = this.lblFontData.getHeight();
        this.originalFontHeightPixel = this.lblGc.getFontMetrics().getHeight();
        this.lblGc.dispose();
        this.state = new Composite((Composite)this, 0);
        this.state.setLayoutData((Object)new GridData());
        this.lbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TerminLabel.this.agenda.setActDate(TerminLabel.this.getTermin().getDay());
                TerminLabel.this.agenda.setActResource(TerminLabel.this.getTermin().getBereich());
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)TerminLabel.this.getTermin(), (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        if (TerminLabel.this.getTermin().isRecurringDate()) {
                            new SerienTerminDialog(UiDesk.getTopShell(), new SerienTermin(TerminLabel.this.getTermin())).open();
                        } else {
                            new TerminDialog(TerminLabel.this.getTermin()).open();
                        }
                    }
                });
            }

            public void mouseUp(MouseEvent e) {
                TerminLabel.this.agenda.dispatchTermin(TerminLabel.this.getTermin());
                super.mouseUp(e);
            }

            public void mouseDown(MouseEvent e) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)TerminLabel.this.getTermin().getKontakt());
            }
        });
        new PersistentObjectDragSource((Control)this.lbl, new PersistentObjectDragSource.ISelectionRenderer(){

            public List<PersistentObject> getSelection() {
                ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>();
                ret.add(TerminLabel.this.getTermin());
                return ret;
            }
        }){

            public void dragFinished(DragSourceEvent event) {
                TerminLabel.this.lbl.getParent().dispose();
                if (TerminLabel.this.getTermin() != null && TerminLabel.this.getTermin().equals(PersistentObjectDragSource.getDraggedObject())) {
                    3.setDraggedObject(null);
                }
            }
        };
        new TerminLabelMenu();
    }

    public void dispose() {
        if (this.getTermin() != null && this.getTermin().equals(PersistentObjectDragSource.getDraggedObject()) && this.isVisible()) {
            this.setVisible(false);
        } else {
            super.dispose();
        }
    }

    public void set(Termin tf, int col) {
        this.t = tf;
        this.serienTermin = this.getTermin().isRecurringDate() ? new SerienTermin(this.getTermin()) : null;
        this.column = col;
    }

    public TerminLabel(IAgendaLayout parent, Termin trm, int col) {
        this(parent);
        this.set(trm, col);
    }

    public int getColumn() {
        return this.column;
    }

    public Termin getTermin() {
        return this.t;
    }

    public void updateActions() {
        boolean canChangeAppointments = CoreHub.acl.request(ACLContributor.CHANGE_APPOINTMENTS);
        this.terminKuerzenAction.setEnabled(canChangeAppointments);
        this.terminVerlaengernAction.setEnabled(canChangeAppointments);
        this.terminAendernAction.setEnabled(canChangeAppointments);
    }

    public void refresh() {
        int diffPixel;
        int diffPoint;
        Termin appointment;
        Termin rootAppointment = appointment = this.getTermin();
        if (this.serienTermin != null) {
            rootAppointment = this.serienTermin.getRootTermin();
        }
        if (this.overLapped != null) {
            this.setBackground(this.getDisplay().getSystemColor(3));
        }
        Color back = Plannables.getTypColor(appointment);
        this.lbl.setBackground(back);
        this.lbl.setForeground(SWTHelper.getContrast((Color)back));
        StringBuilder sb = new StringBuilder();
        sb.append(appointment.isRecurringDate() ? "Terminserie\n" : "");
        sb.append(appointment.getLabel()).append("\n").append(appointment.getGrund());
        sb.append("\n--------\n").append(appointment.getStatusHistoryDesc());
        String grund = rootAppointment.getGrund();
        if (grund != null && !grund.isEmpty()) {
            this.lbl.setText(String.valueOf(rootAppointment.getTitle()) + ", " + grund);
        } else {
            this.lbl.setText(rootAppointment.getTitle());
        }
        this.lbl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.lbl.setToolTipText(sb.toString());
        int lx = this.ial.getLeftOffset() + (int)Math.round((double)this.getColumn() * (this.ial.getWidthPerColumn() + (double)this.ial.getPadding()));
        String startOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
        int sodtHours = Integer.parseInt(startOfDayTimeInMinutes.substring(0, 2));
        int sodtMinutes = Integer.parseInt(startOfDayTimeInMinutes.substring(2));
        int sodtM = sodtHours * 60;
        sodtM += sodtMinutes;
        String endOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
        int eodtHours = Integer.parseInt(endOfDayTimeInMinutes.substring(0, 2));
        int eodtMinutes = Integer.parseInt(endOfDayTimeInMinutes.substring(2));
        int eodtM = eodtHours * 60;
        eodtM += eodtMinutes;
        if (appointment.getBeginn() < sodtM && appointment.getBeginn() + appointment.getDauer() < sodtM) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        if (appointment.getBeginn() > eodtM && appointment.getBeginn() + appointment.getDauer() > eodtM) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        int ly = 0;
        int lh = 0;
        if (appointment.getBeginn() < sodtM) {
            ly = (int)Math.round((double)appointment.getBeginn() * this.ial.getPixelPerMinute());
            int diff = appointment.getDauer() - sodtM < 0 ? appointment.getDauer() : appointment.getDauer() - sodtM;
            lh = (int)Math.round((double)(diff += appointment.getBeginn() + diff > eodtM ? appointment.getBeginn() + diff - eodtM : 0) * this.ial.getPixelPerMinute());
        } else {
            int startMinute = appointment.getBeginn() - sodtM;
            ly = (int)Math.round((double)startMinute * this.ial.getPixelPerMinute());
            int ends = appointment.getBeginn() + appointment.getDauer();
            int heigthDiff = ends - eodtM;
            if (heigthDiff < 0) {
                heigthDiff = 0;
            }
            lh = (int)Math.round((double)(appointment.getDauer() - heigthDiff) * this.ial.getPixelPerMinute());
        }
        int lw = (int)Math.round(this.ial.getWidthPerColumn());
        int newHeight = this.originalFontHeightPoint;
        if (this.originalFontHeightPixel >= lh && (newHeight = this.originalFontHeightPoint - ((diffPoint = (diffPixel = this.originalFontHeightPixel - lh) * 72 / Display.getCurrent().getDPI().y) + 1)) <= 0) {
            newHeight = this.originalFontHeightPoint;
        }
        this.lblFontData.setHeight(newHeight);
        this.lbl.setFont(this.getLabelFont(this.lblFontData));
        this.setBounds(lx, ly, lw, lh);
        GridData gd = (GridData)this.state.getLayoutData();
        gd.minimumWidth = 10;
        gd.widthHint = 10;
        gd.heightHint = lh;
        this.state.setBackground(Plannables.getStatusColor(appointment));
        this.state.setToolTipText(appointment.getStatus());
        if (this.lbl.getMenu() == null) {
            this.lbl.setMenu(this.ial.getContextMenuManager().createContextMenu((Control)this.lbl));
        }
        this.layout();
    }

    private Font getLabelFont(FontData fontData) {
        Font font = fontMap.get(fontData.getHeight());
        if (font == null) {
            font = new Font((Device)UiDesk.getDisplay(), fontData);
            fontMap.put(fontData.getHeight(), font);
        }
        return font;
    }

    private void makeActions() {
        this.terminAendernAction = new Action(Messages.TagesView_changeTermin){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_changeThisTermin);
            }

            public void run() {
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)TerminLabel.this.getTermin(), (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        (this).TerminLabel.this.agenda.setActResource(TerminLabel.this.getTermin().getBereich());
                        TerminDialog dlg = new TerminDialog(TerminLabel.this.getTermin());
                        dlg.open();
                    }
                });
                TerminLabel.this.refresh();
            }
        };
        this.terminKuerzenAction = new Action(Messages.TagesView_shortenTermin){

            public void run() {
                if (TerminLabel.this.getTermin() != null) {
                    AcquireLockBlockingUi.aquireAndRun((IPersistentObject)TerminLabel.this.getTermin(), (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            TerminLabel.this.getTermin().setDurationInMinutes(TerminLabel.this.getTermin().getDurationInMinutes() >> 1);
                        }
                    });
                    ElexisEventDispatcher.update((PersistentObject)TerminLabel.this.getTermin());
                }
            }
        };
        this.terminVerlaengernAction = new Action(Messages.TagesView_enlargeTermin){

            public void run() {
                if (TerminLabel.this.getTermin() != null) {
                    AcquireLockBlockingUi.aquireAndRun((IPersistentObject)TerminLabel.this.getTermin(), (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            (this).TerminLabel.this.agenda.setActDate(TerminLabel.this.getTermin().getDay());
                            Termin n = Plannables.getFollowingTermin((this).TerminLabel.this.agenda.getActResource(), (this).TerminLabel.this.agenda.getActDate(), TerminLabel.this.getTermin());
                            if (n != null) {
                                TerminLabel.this.getTermin().setEndTime(n.getStartTime());
                            }
                        }
                    });
                    TerminLabel.this.refresh();
                }
            }
        };
    }

    public static void checkAllCollisions(List<TerminLabel> tlabels) {
        tlabels.parallelStream().forEach(terminLabel -> terminLabel.checkCollision(tlabels));
    }

    private void checkCollision(List<TerminLabel> tlabels) {
        String checkBereich = this.getTermin().getBereich();
        Termin termin = this.getTermin();
        for (TerminLabel otherLabel : tlabels) {
            Termin otherTermin = otherLabel.getTermin();
            if (otherLabel == this || !otherTermin.getBereich().equals(checkBereich) || !Plannables.isOverlapped(termin, otherTermin)) continue;
            this.addOverlapped(otherLabel);
        }
    }

    private void addOverlapped(TerminLabel otherLabel) {
        if (this.overLapped == null) {
            this.overLapped = new ArrayList<TerminLabel>();
        }
        this.overLapped.add(otherLabel);
    }

    class TerminLabelMenu {
        TerminLabelMenu() {
            MenuManager contextMenuManager = new MenuManager();
            contextMenuManager.add(AgendaActions.getTerminStatusAction());
            contextMenuManager.add(TerminLabel.this.terminKuerzenAction);
            contextMenuManager.add(TerminLabel.this.terminVerlaengernAction);
            contextMenuManager.add(TerminLabel.this.terminAendernAction);
            contextMenuManager.add(AgendaActions.getDelTerminAction());
            TerminLabel.this.lbl.setMenu(contextMenuManager.createContextMenu((Control)TerminLabel.this.lbl));
        }
    }
}

