/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.ui.AgendaParallel;
import ch.elexis.agenda.ui.ColumnHeader;
import ch.elexis.agenda.ui.IAgendaLayout;
import ch.elexis.agenda.ui.TerminLabel;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.dialogs.TerminDialog;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public class ProportionalSheet
extends Composite
implements IAgendaLayout {
    static final int LEFT_OFFSET_DEFAULT = 20;
    static final int PADDING_DEFAULT = 5;
    private int left_offset;
    private int padding;
    private AgendaParallel view;
    private MenuManager contextMenuManager;
    private List<TerminLabel> tlabels;
    private double ppm;
    private int sheetHeight;
    private String[] resources;
    private int textWidth;
    private double sheetWidth;
    private double widthPerColumn;
    private boolean ctrlKeyDown = false;

    private TimeTool setTerminTo(int x, int y) {
        String resource = "";
        int i = 0;
        while (i < this.resources.length) {
            double lower = (double)this.left_offset + (double)i * (this.widthPerColumn + (double)this.padding);
            double upper = lower + this.widthPerColumn;
            if (this.isBetween(x, lower, upper)) {
                resource = this.resources[i];
                break;
            }
            ++i;
        }
        String startOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
        int dayStartHour = Integer.parseInt(startOfDayTimeInMinutes.substring(0, 2));
        int minute = (int)Math.round((double)y / this.ppm);
        TimeTool tt = new TimeTool(Activator.getDefault().getActDate());
        int hour = minute / 60;
        minute -= 60 * hour;
        int raster = 5;
        minute = (minute + (raster >> 1)) / raster * raster;
        tt.set(9, 0);
        tt.set(10, dayStartHour + hour);
        tt.set(12, minute);
        if (resource.length() > 0) {
            Activator.getDefault().setActResource(resource);
        }
        return tt;
    }

    public ProportionalSheet(Composite parent, AgendaParallel v) {
        super(parent, 262144);
        this.view = v;
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProportionalSheet.this.layout();
                ProportionalSheet.this.recalc();
            }
        });
        this.addPaintListener(new TimePainter());
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimeTool tt = ProportionalSheet.this.setTerminTo(e.x, e.y);
                TerminDialog dlg = new TerminDialog(null);
                dlg.create();
                dlg.setTime(tt);
                if (dlg.open() == 0) {
                    ProportionalSheet.this.refresh();
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144) {
                    ProportionalSheet.this.ctrlKeyDown = true;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144) {
                    ProportionalSheet.this.ctrlKeyDown = false;
                }
            }
        });
        this.left_offset = 20;
        this.padding = 5;
        new PersistentObjectDropTarget((Control)this, new PersistentObjectDropTarget.IReceiver(){

            public boolean accept(PersistentObject o) {
                return true;
            }

            public void dropped(PersistentObject o, DropTargetEvent e) {
                Point pt = Display.getCurrent().map(null, (Control)ProportionalSheet.this, e.x, e.y);
                final TimeTool tt = ProportionalSheet.this.setTerminTo(pt.x, pt.y);
                if (o instanceof Termin) {
                    final Termin t = (Termin)o;
                    if (Termin.overlaps(Activator.getDefault().getActResource(), tt, t.getDauer(), t.getId())) {
                        SWTHelper.showInfo((String)"Termin Kollision", (String)"Termine \u00fcberschneiden sich");
                    } else if (ProportionalSheet.this.ctrlKeyDown) {
                        ProportionalSheet.this.ctrlKeyDown = false;
                        final Termin tCopy = (Termin)t.clone();
                        if (t.isRecurringDate() && t.getKontakt() == null) {
                            tCopy.setKontakt(new SerienTermin(t).getRootTermin().getKontakt());
                        }
                        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)tCopy, (ILockHandler)new ILockHandler(){

                            public void lockFailed() {
                                tCopy.delete();
                            }

                            public void lockAcquired() {
                                tCopy.setStartTime(tt);
                                tCopy.setBereich(Activator.getDefault().getActResource());
                            }
                        });
                    } else {
                        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)t, (ILockHandler)new ILockHandler(){

                            public void lockFailed() {
                            }

                            public void lockAcquired() {
                                t.setStartTime(tt);
                                t.setBereich(Activator.getDefault().getActResource());
                            }
                        });
                    }
                    ProportionalSheet.this.refresh();
                }
            }
        });
    }

    private boolean isBetween(int x, double lower, double upper) {
        int y = (int)Math.round(lower);
        int z = (int)Math.round(upper);
        return x >= y && x <= z;
    }

    public boolean setFocus() {
        this.ctrlKeyDown = false;
        return super.setFocus();
    }

    @Override
    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void clear() {
        while (this.tlabels != null && this.tlabels.size() > 0) {
            this.tlabels.remove(0).dispose();
        }
        this.recalc();
    }

    synchronized void refresh() {
        String[] resnames = this.view.getDisplayedResources();
        Query qbe = new Query(Termin.class, "AGNTERMINE", false, new String[]{"linkgroup", "Dauer", "Beginn", "Tag", "Grund", "Wer", "deleted", "Status", "Typ", "BeiWem", "StatusHistory"});
        String day = Activator.getDefault().getActDate().toString(9);
        qbe.add("Tag", "=", day);
        qbe.startGroup();
        String[] stringArray = resnames;
        int n = resnames.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            qbe.add("BeiWem", "=", n3);
            qbe.or();
            ++n2;
        }
        qbe.endGroup();
        List apps = qbe.execute();
        if (this.tlabels != null) {
            for (TerminLabel terminLabel : this.tlabels) {
                terminLabel.dispose();
            }
            this.tlabels.clear();
        } else {
            this.tlabels = new LinkedList<TerminLabel>();
        }
        if (!this.isDisposed()) {
            for (Termin termin : apps) {
                String m = termin.getBereich();
                int idx = StringTool.getIndex((String[])resnames, (String)m);
                if (idx == -1) continue;
                TerminLabel terminLabel = new TerminLabel(this);
                terminLabel.set(termin, idx);
                this.tlabels.add(terminLabel);
            }
            TerminLabel.checkAllCollisions(this.tlabels);
            this.recalc();
        }
    }

    void recalc() {
        if (this.tlabels != null) {
            this.ppm = AgendaParallel.getPixelPerMinute();
            String startOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
            int sodtHours = Integer.parseInt(startOfDayTimeInMinutes.substring(0, 2));
            int sodtMinutes = Integer.parseInt(startOfDayTimeInMinutes.substring(2));
            int sodtM = sodtHours * 60;
            String endOfDayTimeInMinutes = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
            int eodtHours = Integer.parseInt(endOfDayTimeInMinutes.substring(0, 2));
            int eodtMinutes = Integer.parseInt(endOfDayTimeInMinutes.substring(2));
            int eodtM = eodtHours * 60;
            this.sheetHeight = (int)Math.round(this.ppm * (double)((eodtM += eodtMinutes) - (sodtM += sodtMinutes)));
            ScrolledComposite sc = (ScrolledComposite)this.getParent();
            Point mySize = this.getSize();
            if ((double)mySize.x > 0.0) {
                if (mySize.y != this.sheetHeight) {
                    this.setSize(mySize.x, this.sheetHeight);
                    sc.setMinSize(this.getSize());
                }
                ScrollBar bar = sc.getVerticalBar();
                int barWidth = 14;
                if (bar != null) {
                    barWidth = bar.getSize().x;
                }
                this.resources = this.view.getDisplayedResources();
                int count = this.resources.length;
                Point textSize = SWTHelper.getStringBounds((Composite)this, (String)"88:88");
                this.textWidth = textSize.x;
                this.left_offset = this.textWidth + 2;
                this.sheetWidth = mySize.x - 2 * this.left_offset - barWidth;
                this.widthPerColumn = this.sheetWidth / (double)count;
                ColumnHeader header = this.view.getHeader();
                header.recalc(this.widthPerColumn, this.left_offset, this.padding, textSize.y);
                for (TerminLabel l : this.tlabels) {
                    l.refresh();
                }
                sc.layout();
            }
        }
    }

    @Override
    public double getPixelPerMinute() {
        return this.ppm;
    }

    @Override
    public double getWidthPerColumn() {
        return this.widthPerColumn;
    }

    @Override
    public int getLeftOffset() {
        return this.left_offset;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    private void addCurrentTimeline(GC gc, String dayStartsAt) {
        int sodtHours = Integer.parseInt(dayStartsAt.substring(0, 2));
        int sodtMinutes = Integer.parseInt(dayStartsAt.substring(2));
        int sodtM = sodtHours * 60;
        int w = this.getSize().x - 5;
        int y = 0;
        Calendar c = Calendar.getInstance();
        int minuteOfDay = c.get(11) * 60 + c.get(12);
        if (minuteOfDay < (sodtM += sodtMinutes)) {
            y = (int)this.getPixelPerMinute();
        } else {
            int startMinute = minuteOfDay - sodtM;
            y = (int)Math.round((double)startMinute * this.getPixelPerMinute());
        }
        gc.setForeground(UiDesk.getColor((String)"rot"));
        gc.drawLine(this.getLeftOffset() - 5, y, w, y);
        gc.setForeground(UiDesk.getColor((String)"schwarz"));
    }

    @Override
    public Composite getComposite() {
        return this;
    }

    class TimePainter
    implements PaintListener {
        TimePainter() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.fillRectangle(e.x, e.y, e.width, e.height);
            int y = 0;
            TimeTool runner = new TimeTool();
            String dayStartsAt = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
            runner.set(dayStartsAt);
            String dayEndsAt = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
            TimeTool limit = new TimeTool(dayEndsAt);
            Point textSize = gc.textExtent("88:88");
            int textwidth = textSize.x;
            int quarter = (int)Math.round(15.0 * AgendaParallel.getPixelPerMinute());
            int w = ProportionalSheet.this.getSize().x - 5;
            int left = 0;
            int right = w - textwidth;
            while (runner.isBefore(limit)) {
                gc.drawLine(left, y, w, y);
                String time = runner.toString(3);
                gc.drawText(time, 0, y + 1);
                gc.drawText(time, right, y + 1);
                gc.drawLine(textwidth - 3, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 3, y);
                gc.drawLine(textwidth - 6, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 6, y);
                gc.drawLine(textwidth - 3, y += quarter, textwidth, y);
                gc.drawLine(right, y, right + 3, y);
                y += quarter;
                runner.addHours(1);
            }
            ProportionalSheet.this.addCurrentTimeline(gc, dayStartsAt);
        }
    }
}

