/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.ui.AgendaParallel;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ColumnHeader
extends Composite {
    AgendaParallel view;
    static final String IMG_PERSONS_NAME = "ch.elexis.agenda/personen";
    static final String IMG_PERSONS_PATH = "icons/personen.png";
    ImageHyperlink ihRes;

    ColumnHeader(Composite parent, AgendaParallel v) {
        super(parent, 0);
        this.view = v;
        if (UiDesk.getImage((String)IMG_PERSONS_NAME) == null) {
            UiDesk.getImageRegistry().put(IMG_PERSONS_NAME, Activator.getImageDescriptor(IMG_PERSONS_PATH));
        }
        this.ihRes = new ImageHyperlink((Composite)this, 0);
        this.ihRes.setImage(UiDesk.getImage((String)IMG_PERSONS_NAME));
        this.ihRes.setToolTipText(Messages.ColumnHeader_selectMandatorToShow);
        this.ihRes.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new SelectResourceDlg().open();
            }
        });
    }

    void recalc(double widthPerColumn, int left_offset, int padding, int textSize) {
        GridData gd = (GridData)this.getLayoutData();
        gd.heightHint = textSize + 2;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                c.dispose();
            }
            ++n2;
        }
        Point bSize = this.ihRes.computeSize(-1, -1);
        this.ihRes.setBounds(0, 0, bSize.x, bSize.y);
        String[] labels = this.view.getDisplayedResources();
        int count = labels.length;
        int i = 0;
        while (i < count) {
            int lx = left_offset + (int)Math.round((double)i * (widthPerColumn + (double)padding));
            Label l = new Label((Composite)this, 0);
            l.setText(labels[i]);
            int outer = (int)Math.round(widthPerColumn);
            int inner = l.computeSize((int)-1, (int)-1).x;
            int off = (outer - inner) / 2;
            l.setBounds(lx += off, 0, inner, textSize + 2);
            ++i;
        }
    }

    class SelectResourceDlg
    extends TitleAreaDialog {
        public SelectResourceDlg() {
            super(ColumnHeader.this.getShell());
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            String[] displayed = ColumnHeader.this.view.getDisplayedResources();
            String[] stringArray = Activator.getDefault().getResources();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                Button b = new Button(ret, 32);
                b.setText(r);
                if (StringTool.getIndex((String[])displayed, (String)r) != -1) {
                    b.setSelection(true);
                }
                b.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                ++n2;
            }
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.ColumnHeader_Mandantors);
            this.setTitle(Messages.ColumnHeader_mandatorsForParallelView);
            this.setMessage(Messages.ColumnHeader_selectMandators);
        }

        protected void okPressed() {
            Composite dlg = (Composite)this.getDialogArea();
            String[] res = Activator.getDefault().getResources();
            ArrayList<String> sel = new ArrayList<String>(res.length);
            Control[] controlArray = dlg.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Button && ((Button)c).getSelection()) {
                    sel.add(((Button)c).getText());
                }
                ++n2;
            }
            ColumnHeader.this.view.clear();
            CoreHub.localCfg.set("agenda/proportional/bereichezeigen", StringTool.join(sel, (String)","));
            ColumnHeader.this.view.refresh();
            super.okPressed();
        }
    }
}

