/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.actions.AgendaActions;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.data.ICalTransfer;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.data.TerminUtil;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.dialogs.TerminDialog;
import ch.elexis.dialogs.TerminListeDruckenDialog;
import ch.elexis.dialogs.TermineDruckenDialog;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class BaseView
extends ViewPart
implements Heartbeat.HeartListener,
IActivationListener {
    private static final String DEFAULT_PIXEL_PER_MINUTE = "1.0";
    public IAction newTerminAction;
    public IAction blockAction;
    public IAction dayLimitsAction;
    public IAction newViewAction;
    public IAction printAction;
    public IAction exportAction;
    public IAction importAction;
    public IAction printPatientAction;
    public IAction todayAction;
    public IAction refreshAction;
    MenuManager menu = new MenuManager();
    protected Activator agenda = Activator.getDefault();
    private final ElexisEventListener eeli_termin = new ElexisUiEventListenerImpl(Termin.class, 8){

        public void runInUi(ElexisEvent ev) {
            BaseView.this.internalRefresh();
        }
    };
    private final ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            BaseView.this.updateActions();
            BaseView.this.agenda.setActResource(CoreHub.userCfg.get("agenda/bereich", BaseView.this.agenda.getActResource()));
        }
    };

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.create(parent);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.internalRefresh();
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    protected abstract void create(Composite var1);

    protected abstract void refresh();

    protected abstract IPlannable getSelection();

    private void internalRefresh() {
        if (CoreHub.acl.request(ACLContributor.DISPLAY_APPOINTMENTS)) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BaseView.this.refresh();
                }
            });
        }
    }

    protected void checkDay(String resource, TimeTool date) {
        if (date == null) {
            date = this.agenda.getActDate();
        }
        if (resource == null) {
            resource = this.agenda.getActResource();
        }
        TerminUtil.updateBoundaries(resource, date);
    }

    protected void updateActions() {
        this.dayLimitsAction.setEnabled(CoreHub.acl.request(ACLContributor.CHANGE_DAYSETTINGS));
        boolean canChangeAppointments = CoreHub.acl.request(ACLContributor.CHANGE_APPOINTMENTS);
        this.newTerminAction.setEnabled(canChangeAppointments);
        AgendaActions.updateActions();
        this.internalRefresh();
    }

    public void heartbeat() {
        this.internalRefresh();
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_termin, this.eeli_user});
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_termin, this.eeli_user});
        }
    }

    public static double getPixelPerMinute() {
        String ppm = CoreHub.localCfg.get("agenda/proportional/pixelperminute", DEFAULT_PIXEL_PER_MINUTE);
        try {
            double ret = Double.parseDouble(ppm);
            return ret;
        }
        catch (NumberFormatException ne) {
            CoreHub.localCfg.set("agenda/proportional/pixelperminute", DEFAULT_PIXEL_PER_MINUTE);
            return Double.parseDouble(DEFAULT_PIXEL_PER_MINUTE);
        }
    }

    protected void makeActions() {
        this.dayLimitsAction = new Action(Messages.BaseView_dayLimits){

            public void run() {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command cmd = commandService.getCommand("org.eclipse.ui.window.preferences");
                try {
                    HashMap<String, String> hm = new HashMap<String, String>();
                    hm.put("preferencePageId", "ch.elexis.agenda.tageseinteilung");
                    ExecutionEvent ev = new ExecutionEvent(cmd, hm, null, null);
                    cmd.executeWithChecks(ev);
                }
                catch (Exception exception) {
                    Status status = new Status(2, "ch.elexis.agenda", "Error opening preference page ch.elexis.agenda.tageseinteilung", (Throwable)exception);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
                BaseView.this.refresh();
            }
        };
        this.blockAction = new Action(Messages.TagesView_lockPeriod){

            public void run() {
                IPlannable p = BaseView.this.getSelection();
                if (p != null && p instanceof Termin.Free) {
                    new Termin(BaseView.this.agenda.getActResource(), BaseView.this.agenda.getActDate().toString(9), p.getStartMinute(), p.getDurationInMinutes() + p.getStartMinute(), Termin.typReserviert(), Termin.statusLeer());
                    ElexisEventDispatcher.reload(Termin.class);
                }
            }
        };
        this.newTerminAction = new Action(Messages.TagesView_newTermin){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_createNewTermin);
            }

            public void run() {
                new TerminDialog(null).open();
                BaseView.this.internalRefresh();
            }
        };
        this.printAction = new Action(Messages.BaseView_printDayPaapintments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseView_printAPpointmentsOfSelectedDay);
            }

            public void run() {
                IPlannable[] liste = Plannables.loadDay(BaseView.this.agenda.getActResource(), BaseView.this.agenda.getActDate());
                new TerminListeDruckenDialog(BaseView.this.getViewSite().getShell(), liste).open();
                BaseView.this.internalRefresh();
            }
        };
        this.printPatientAction = new Action(Messages.BaseView_printAppointments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseView_printFutureAppointmentsOfSelectedPatient);
            }

            public void run() {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient != null) {
                    Query qbe = new Query(Termin.class);
                    qbe.add("Wer", "=", patient.getId());
                    qbe.add("deleted", "<>", "1");
                    qbe.add("Tag", ">=", new TimeTool().toString(9));
                    qbe.orderBy(false, new String[]{"Tag", "Beginn"});
                    List list = qbe.execute();
                    if (list != null) {
                        boolean directPrint = CoreHub.localCfg.get("agenda/print/appointmentcard_directprint", false);
                        TermineDruckenDialog dlg = new TermineDruckenDialog(BaseView.this.getViewSite().getShell(), list.toArray(new Termin[0]));
                        if (directPrint) {
                            dlg.setBlockOnOpen(false);
                            dlg.open();
                            if (dlg.doPrint()) {
                                dlg.close();
                            } else {
                                SWTHelper.alert((String)Messages.BaseView_errorWhilePrinting, (String)Messages.BaseView_errorHappendPrinting);
                            }
                        } else {
                            dlg.setBlockOnOpen(true);
                            dlg.open();
                        }
                    }
                }
            }
        };
        this.exportAction = new Action(Messages.BaseView_exportAgenda){
            {
                this.setToolTipText(Messages.BaseView_exportAppojntmentsOfMandator);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doExport(BaseView.this.agenda.getActDate(), BaseView.this.agenda.getActDate(), BaseView.this.agenda.getActResource());
            }
        };
        this.importAction = new Action(Messages.BaseView_importAgenda){
            {
                this.setToolTipText(Messages.BaseView_importFromICal);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doImport(BaseView.this.agenda.getActResource());
            }
        };
        this.todayAction = new Action(Messages.BaseView_today){
            {
                this.setToolTipText(Messages.BaseView_showToday);
                this.setImageDescriptor(Activator.getImageDescriptor("icons/calendar_view_day.png"));
            }

            public void run() {
                BaseView.this.agenda.setActDate(new TimeTool());
                BaseView.this.internalRefresh();
            }
        };
        this.refreshAction = new Action(Messages.BaseView_refresh){
            {
                this.setToolTipText(Messages.BaseView_refresh);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                BaseView.this.internalRefresh();
            }
        };
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add(this.dayLimitsAction);
        mgr.add(this.exportAction);
        mgr.add(this.importAction);
        mgr.add(this.printAction);
        mgr.add(this.printPatientAction);
        IToolBarManager tmr = this.getViewSite().getActionBars().getToolBarManager();
        tmr.add(this.refreshAction);
        tmr.add(this.todayAction);
    }
}

