/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.ui.BaseView;
import ch.elexis.agenda.ui.ColumnHeader;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.agenda.ui.ProportionalSheet;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AgendaParallel
extends BaseView {
    private IAction dayFwdAction;
    private IAction dayBackAction;
    private IAction showCalendarAction;
    private ProportionalSheet sheet;
    private ColumnHeader header;
    private Composite wrapper;

    public ColumnHeader getHeader() {
        return this.header;
    }

    @Override
    protected void create(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        this.wrapper.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.wrapper.setLayout((Layout)new GridLayout());
        this.header = new ColumnHeader(this.wrapper, this);
        this.header.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        ScrolledComposite bounding = new ScrolledComposite(this.wrapper, 512);
        bounding.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.sheet = new ProportionalSheet((Composite)bounding, this);
        bounding.setContent((Control)this.sheet);
        bounding.setMinSize(this.sheet.computeSize(-1, -1));
        bounding.setExpandHorizontal(true);
        bounding.setExpandVertical(true);
        this.makePrivateActions();
        String[] stringArray = this.getDisplayedResources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.checkDay(s, null);
            ++n2;
        }
        this.refresh();
    }

    public void setFocus() {
        this.sheet.setFocus();
    }

    @Override
    protected IPlannable getSelection() {
        return null;
    }

    public String[] getDisplayedResources() {
        String resources = CoreHub.localCfg.get("agenda/proportional/bereichezeigen", StringTool.join((String[])this.agenda.getResources(), (String)","));
        if (resources == null) {
            return new String[0];
        }
        return resources.split(",");
    }

    void clear() {
        this.sheet.clear();
    }

    @Override
    protected void refresh() {
        this.showCalendarAction.setText(String.valueOf(this.agenda.getActDate().toString(12)) + ", " + this.agenda.getActDate().toString(4));
        this.sheet.refresh();
        this.wrapper.layout();
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }

    private void makePrivateActions() {
        this.dayFwdAction = new Action(Messages.AgendaParallel_dayForward){
            {
                this.setToolTipText(Messages.AgendaParallel_showNextDay);
                this.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
            }

            public void run() {
                AgendaParallel.this.agenda.addDays(1);
                String[] stringArray = AgendaParallel.this.getDisplayedResources();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    AgendaParallel.this.checkDay(s, null);
                    ++n2;
                }
                AgendaParallel.this.refresh();
            }
        };
        this.dayBackAction = new Action(Messages.AgendaParallel_dayBack){
            {
                this.setToolTipText(Messages.AgendaParallel_showPreviousDay);
                this.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
            }

            public void run() {
                AgendaParallel.this.agenda.addDays(-1);
                String[] stringArray = AgendaParallel.this.getDisplayedResources();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    AgendaParallel.this.checkDay(s, null);
                    ++n2;
                }
                AgendaParallel.this.refresh();
            }
        };
        this.showCalendarAction = new Action(Messages.AgendaParallel_selectDay){
            {
                this.setToolTipText(Messages.AgendaParallel_showCalendarForSelcetion);
            }

            public void run() {
                DateSelectorDialog dsl = new DateSelectorDialog(AgendaParallel.this.getViewSite().getShell(), AgendaParallel.this.agenda.getActDate());
                if (dsl.open() == 0) {
                    AgendaParallel.this.agenda.setActDate(dsl.getSelectedDate());
                    String[] stringArray = AgendaParallel.this.getDisplayedResources();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        AgendaParallel.this.checkDay(s, null);
                        ++n2;
                    }
                    AgendaParallel.this.refresh();
                }
            }
        };
        Action zoomAction = new Action(Messages.AgendaParallel_zoom, 4){
            Menu mine;
            {
                this.setToolTipText(Messages.AgendaParallel_setZoomFactor);
                this.setImageDescriptor(Activator.getImageDescriptor("icons/zoom.png"));
                this.setMenuCreator(new IMenuCreator(){

                    public void dispose() {
                        mine.dispose();
                    }

                    public Menu getMenu(Control parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        return mine;
                    }

                    public Menu getMenu(Menu parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        return mine;
                    }
                });
            }

            private void fillMenu() {
                String currentFactorString = CoreHub.localCfg.get("agenda/proportional/pixelperminute", "0.4");
                int currentFactor = (int)(Float.parseFloat(currentFactorString) * 100.0f);
                String[] stringArray = new String[]{"40", "60", "80", "100", "120", "140", "160", "200", "300", "400", "500"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    MenuItem it = new MenuItem(this.mine, 16);
                    it.setText(String.valueOf(s) + "%");
                    it.setData((Object)s);
                    it.setSelection(Integer.parseInt(s) == currentFactor);
                    it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MenuItem mi = (MenuItem)e.getSource();
                            int scale = Integer.parseInt((String)mi.getData());
                            double factor = (double)scale / 100.0;
                            CoreHub.localCfg.set("agenda/proportional/pixelperminute", Double.toString(factor));
                            AgendaParallel.this.sheet.recalc();
                        }
                    });
                    ++n2;
                }
            }
        };
        IToolBarManager tmr = this.getViewSite().getActionBars().getToolBarManager();
        tmr.add((IContributionItem)new Separator());
        tmr.add(this.dayBackAction);
        tmr.add(this.showCalendarAction);
        tmr.add(this.dayFwdAction);
        tmr.add((IContributionItem)new Separator());
        tmr.add((IAction)zoomAction);
        tmr.add((IContributionItem)new Separator("agenda_right"));
    }
}

