/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.series.ui;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.EndingType;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.agenda.series.SeriesType;
import ch.elexis.agenda.series.ui.Messages;
import ch.elexis.agenda.series.ui.composite.MonthlySeriesComposite;
import ch.elexis.agenda.series.ui.composite.WeeklySeriesComposite;
import ch.elexis.agenda.series.ui.composite.YearlySeriesComposite;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;

public class SerienTerminDialog
extends TitleAreaDialog {
    private static final int DAYS_OF_WEEK = 7;
    private static final int APPLY = 0;
    private static final int CANCEL = 2;
    private DataBindingContext m_bindingContext;
    private Text txtEndsAfterNOccurences;
    private Group groupData;
    private Text txtReason;
    private Text txtContact;
    private SerienTermin serienTermin;
    private DateTime dateTimeBegin;
    private DateTime dateTimeEnd;
    private DateTime dateTimeBeginOfSeries;
    private Button btnEndsAfter;
    private Button btnEndsOn;
    private CTabFolder tabFolderSeriesPattern;
    private WeeklySeriesComposite wsc;
    private MonthlySeriesComposite msc;
    private YearlySeriesComposite ysc;
    private DateTime dateEndsOn;
    private Combo comboArea;
    private Spinner durationSpinner;
    private int result;
    private boolean noedit;

    public SerienTerminDialog(Shell parentShell, SerienTermin serienTermin) {
        super(parentShell);
        this.serienTermin = serienTermin;
        if (this.serienTermin == null) {
            this.noedit = false;
            this.serienTermin = new SerienTermin();
        } else {
            this.noedit = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitleImage(ResourceManager.getPluginImage("ch.elexis.agenda", "icons/recurringDate.png"));
        if (this.noedit) {
            this.setMessage(Messages.SerienTerminDialog_this_message_show);
        } else {
            this.setMessage(Messages.SerienTerminDialog_this_message_create);
        }
        Group grpTermin = new Group(area, 0);
        grpTermin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpTermin.setLayout((Layout)new GridLayout(6, false));
        grpTermin.setText(Messages.SerienTerminDialog_grpTermin_text);
        Label lblBeginn = new Label((Composite)grpTermin, 0);
        lblBeginn.setText(Messages.SerienTerminDialog_lblBeginn_text);
        this.dateTimeBegin = new DateTime((Composite)grpTermin, 34944);
        this.dateTimeBegin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerienTerminDialog.this.updateSpinner();
            }
        });
        Label lblEnde = new Label((Composite)grpTermin, 0);
        lblEnde.setText(Messages.SerienTerminDialog_lblEnde_text);
        this.dateTimeEnd = new DateTime((Composite)grpTermin, 34944);
        this.dateTimeEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerienTerminDialog.this.updateSpinner();
            }
        });
        Label lblDauer = new Label((Composite)grpTermin, 0);
        lblDauer.setText(Messages.SerienTerminDialog_lblDauer_text);
        this.durationSpinner = new Spinner((Composite)grpTermin, 0);
        this.durationSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.durationSpinner.setMinimum(5);
        this.durationSpinner.setMaximum(1440);
        this.durationSpinner.setIncrement(5);
        this.durationSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = SerienTerminDialog.this.durationSpinner.getSelection();
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(11, SerienTerminDialog.this.dateTimeBegin.getHours());
                cal.set(12, SerienTerminDialog.this.dateTimeBegin.getMinutes());
                cal.add(12, value);
                SerienTerminDialog.this.dateTimeEnd.setHours(cal.get(11));
                SerienTerminDialog.this.dateTimeEnd.setMinutes(cal.get(12));
            }
        });
        Group grpSerienmuster = new Group(area, 0);
        grpSerienmuster.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpSerienmuster.setLayout((Layout)new GridLayout(1, false));
        grpSerienmuster.setText(Messages.SerienTerminDialog_grpSerienmuster_text);
        this.tabFolderSeriesPattern = new CTabFolder((Composite)grpSerienmuster, 2048);
        this.tabFolderSeriesPattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tabFolderSeriesPattern.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.tabFolderSeriesPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerienTerminDialog.this.serienTermin.setSeriesType((SeriesType)((Object)e.item.getData()));
            }
        });
        CTabItem tbtmDaily = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmDaily.setText(Messages.SerienTerminDialog_tbtmDaily_text);
        tbtmDaily.setData((Object)SeriesType.DAILY);
        Label lblNoConfigurationNecessary = new Label((Composite)this.tabFolderSeriesPattern, 0);
        tbtmDaily.setControl((Control)lblNoConfigurationNecessary);
        lblNoConfigurationNecessary.setText(Messages.SerienTerminDialog_lblNoConfigurationNecessary_text);
        CTabItem tbtmWeekly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmWeekly.setText(Messages.SerienTerminDialog_tbtmWeekly_text);
        this.wsc = new WeeklySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmWeekly.setControl((Control)this.wsc);
        tbtmWeekly.setData((Object)SeriesType.WEEKLY);
        CTabItem tbtmMonthly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmMonthly.setText(Messages.SerienTerminDialog_tbtmMonthly_text);
        this.msc = new MonthlySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmMonthly.setControl((Control)this.msc);
        new Label((Composite)this.msc, 0);
        tbtmMonthly.setData((Object)SeriesType.MONTHLY);
        CTabItem tbtmYearly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmYearly.setText(Messages.SerienTerminDialog_tbtmYearly_text);
        this.ysc = new YearlySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmYearly.setControl((Control)this.ysc);
        tbtmYearly.setData((Object)SeriesType.YEARLY);
        Group grpSeriendauer = new Group(area, 0);
        grpSeriendauer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpSeriendauer.setLayout((Layout)new GridLayout(3, false));
        grpSeriendauer.setText(Messages.SerienTerminDialog_grpSeriendauer_text);
        Label beginOfSeries = new Label((Composite)grpSeriendauer, 0);
        beginOfSeries.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        beginOfSeries.setText(Messages.SerienTerminDialog_beginOfSeries_text);
        this.dateTimeBeginOfSeries = new DateTime((Composite)grpSeriendauer, 268437508);
        this.dateTimeBeginOfSeries.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.dateTimeBeginOfSeries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeTool tt = new TimeTool(SerienTerminDialog.this.serienTermin.getSeriesStartDate());
                SerienTerminDialog.this.wsc.setWeekNumberLabel(tt.get(3), tt.get(1));
                super.widgetSelected(e);
            }
        });
        Composite composite = new Composite((Composite)grpSeriendauer, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout composite_layout = new GridLayout(2, false);
        composite_layout.marginHeight = 0;
        composite_layout.marginWidth = 0;
        composite.setLayout((Layout)composite_layout);
        this.btnEndsAfter = new Button(composite, 16);
        this.btnEndsAfter.setText(Messages.SerienTerminDialog_btnEndsAfter_text);
        this.btnEndsAfter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerienTerminDialog.this.serienTermin.setEndingType(EndingType.AFTER_N_OCCURENCES);
            }
        });
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout composite_1_layout = new GridLayout(2, false);
        composite_1_layout.marginHeight = 0;
        composite_1_layout.marginWidth = 0;
        composite_1.setLayout((Layout)composite_1_layout);
        this.txtEndsAfterNOccurences = new Text(composite_1, 2048);
        this.txtEndsAfterNOccurences.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNewLabel = new Label(composite_1, 0);
        lblNewLabel.setText(Messages.SerienTerminDialog_lblNewLabel_text);
        this.btnEndsOn = new Button(composite, 16);
        this.btnEndsOn.setText(Messages.SerienTerminDialog_btnEndsOn_text);
        this.btnEndsOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerienTerminDialog.this.serienTermin.setEndingType(EndingType.ON_SPECIFIC_DATE);
            }
        });
        this.dateEndsOn = new DateTime(composite, 2048);
        this.groupData = new Group(area, 0);
        this.groupData.setText(Messages.SerienTerminDialog_groupData_text);
        this.groupData.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.groupData.setLayout((Layout)new GridLayout(4, false));
        this.txtReason = new Text((Composite)this.groupData, 2048);
        this.txtReason.setMessage(Messages.SerienTerminDialog_txtReason_message);
        this.txtReason.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Link linkCustomText = new Link((Composite)this.groupData, 0);
        linkCustomText.setText(Messages.SerienTerminDialog_linkCustomText_text);
        linkCustomText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inp = new InputDialog(SerienTerminDialog.this.getShell(), "Enter Text", "Enter Text/Name for the appointment", "", null);
                if (inp.open() == 0) {
                    SerienTerminDialog.this.txtContact.setText(inp.getValue());
                    SerienTerminDialog.this.serienTermin.setContact(null);
                }
            }
        });
        Link linkSelectContact = new Link((Composite)this.groupData, 0);
        linkSelectContact.setText(Messages.SerienTerminDialog_linkSelectContact_text);
        linkSelectContact.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(SerienTerminDialog.this.getShell(), Kontakt.class, "Datum zuordnen", "Please select the contact the date is assigned to", Kontakt.DEFAULT_SORT);
                if (ksl.open() == 0) {
                    SerienTerminDialog.this.serienTermin.setContact((Kontakt)ksl.getSelection());
                    if (SerienTerminDialog.this.serienTermin.getContact() != null) {
                        SerienTerminDialog.this.txtContact.setText(SerienTerminDialog.this.serienTermin.getContact().getLabel());
                    }
                }
            }
        });
        Label lblArea = new Label((Composite)this.groupData, 0);
        lblArea.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblArea.setText(Messages.SerienTerminDialog_lblArea_text);
        this.comboArea = new Combo((Composite)this.groupData, 0);
        this.comboArea.setItems(Activator.getDefault().getResources());
        this.comboArea.setText(Activator.getDefault().getActResource());
        this.comboArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.getDefault().setActResource(SerienTerminDialog.this.comboArea.getText());
            }
        });
        this.txtContact = new Text((Composite)this.groupData, 2048);
        this.txtContact.setMessage(Messages.SerienTerminDialog_txtContact_message);
        this.txtContact.setEditable(false);
        this.txtContact.setTextLimit(80);
        this.txtContact.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.m_bindingContext = this.initDataBindings();
        this.initDialog();
        if (this.noedit) {
            this.disableAll((Control)area);
        }
        return area;
    }

    private void disableAll(Control widget) {
        if (widget instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)widget;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.disableAll(control);
                ++n2;
            }
            composite.setEnabled(false);
        } else if (widget instanceof Control) {
            widget.setEnabled(false);
        }
    }

    private void initDialog() {
        if (this.serienTermin.getContact() != null) {
            this.setTitle(this.serienTermin.getContact().getLabel());
            this.txtContact.setText(this.serienTermin.getContact().getLabel());
        } else {
            this.setTitle("Kein Kontakt ausgew\u00e4hlt.");
            this.txtContact.setText(this.serienTermin.getFreeText());
        }
        switch (this.serienTermin.getSeriesType()) {
            case DAILY: {
                this.tabFolderSeriesPattern.setSelection(0);
                break;
            }
            case WEEKLY: {
                this.tabFolderSeriesPattern.setSelection(1);
                String[] pattern = this.serienTermin.getSeriesPatternString().split(",");
                this.wsc.getTxtWeekDistance().setText(pattern[0]);
                if (pattern.length > 1) {
                    int i = 0;
                    while (i < pattern[1].length()) {
                        char c = pattern[1].charAt(i);
                        this.wsc.getWeekdays()[Character.getNumericValue(c)].setSelection(true);
                        ++i;
                    }
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.serienTermin.getSeriesStartDate());
                this.wsc.setWeekNumberLabel(cal.get(3), cal.get(1));
                break;
            }
            case MONTHLY: {
                this.tabFolderSeriesPattern.setSelection(2);
                this.msc.setDay(Integer.parseInt(this.serienTermin.getSeriesPatternString()));
                break;
            }
            case YEARLY: {
                this.tabFolderSeriesPattern.setSelection(3);
                this.ysc.setDay(Integer.parseInt(this.serienTermin.getSeriesPatternString().substring(0, 2)));
                this.ysc.setMonth(Integer.parseInt(this.serienTermin.getSeriesPatternString().substring(2, 4)));
                break;
            }
        }
        switch (this.serienTermin.getEndingType()) {
            case AFTER_N_OCCURENCES: {
                this.btnEndsAfter.setSelection(true);
                this.txtEndsAfterNOccurences.setText(this.serienTermin.getEndingPatternString());
                break;
            }
            case ON_SPECIFIC_DATE: {
                this.btnEndsOn.setSelection(true);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.serienTermin.getEndsOnDate());
                this.dateEndsOn.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
                break;
            }
        }
        this.updateSpinner();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        Button button = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        button.setText(Messages.SerienTerminDialog_other_text);
        Button button_1 = this.createButton(parent, 6, "remove series", false);
        button_1.setText(Messages.SerienTerminDialog_other_text_1);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        switch (buttonId) {
            case 0: {
                if (this.noedit) {
                    this.close();
                    break;
                }
                if (this.result != 0) break;
                this.serienTermin.persist();
                this.close();
                break;
            }
            case 6: {
                this.cancelEntry();
                break;
            }
        }
        ElexisEventDispatcher.reload(Termin.class);
    }

    private void cancelEntry() {
        this.serienTermin.delete(false);
        this.setReturnCode(6);
        this.close();
    }

    protected void okPressed() {
        if (!this.noedit) {
            switch (this.serienTermin.getSeriesType()) {
                case DAILY: {
                    switch (this.serienTermin.getEndingType()) {
                        case AFTER_N_OCCURENCES: {
                            this.serienTermin.setSeriesPatternString(this.txtEndsAfterNOccurences.getText());
                            break;
                        }
                        case ON_SPECIFIC_DATE: {
                            this.serienTermin.setSeriesPatternString(SerienTermin.dateFormat.format(this.serienTermin.getEndsOnDate()));
                        }
                    }
                    break;
                }
                case WEEKLY: {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.valueOf(this.wsc.getTxtWeekDistance().getText()) + ",");
                    int i = 1;
                    while (i < 8) {
                        if (this.wsc.getWeekdays()[i].getSelection()) {
                            sb.append(i);
                        }
                        ++i;
                    }
                    this.serienTermin.setSeriesPatternString(sb.toString());
                    break;
                }
                case MONTHLY: {
                    this.serienTermin.setSeriesPatternString(String.valueOf(this.msc.getDay()));
                    break;
                }
                case YEARLY: {
                    this.serienTermin.setSeriesPatternString(String.valueOf(SerienTermin.decimalFormat.format(this.ysc.getDay())) + SerienTermin.decimalFormat.format(this.ysc.getMonth()));
                    break;
                }
            }
            if (this.serienTermin.getContact() == null) {
                this.serienTermin.setFreeText(this.txtContact.getText());
            }
            if (this.serienTermin.collidesWithLockTimes()) {
                MessageDialog collisionDialog = new MessageDialog(this.getShell(), Messages.SerienTerminDialog_dlgLockTimesConflict, this.getTitleImageLabel().getImage(), Messages.SerienTerminDialog_dlgLockTimesSeriesConflict, 4, new String[]{Messages.SerienTerminDialog_dlgBtnApplyAnyway, Messages.SerienTerminDialog_dlgBtnChange, Messages.SerienTerminDialog_dlgBtnCancel}, 0);
                this.result = collisionDialog.open();
            } else {
                this.result = 0;
                super.okPressed();
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeSelectionDateTimeBeginObserveWidget = WidgetProperties.selection().observe((Widget)this.dateTimeBegin);
        IObservableValue beginTimeSerienTerminObserveValue = PojoProperties.value((String)"beginTime").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeBeginObserveWidget, beginTimeSerienTerminObserveValue, null, null);
        ISWTObservableValue observeSelectionDateTimeEndObserveWidget = WidgetProperties.selection().observe((Widget)this.dateTimeEnd);
        IObservableValue endTimeSerienTerminObserveValue = PojoProperties.value((String)"endTime").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeEndObserveWidget, endTimeSerienTerminObserveValue, null, null);
        ISWTObservableValue observeSelectionDateTimeBeginOfSeriesObserveWidget = WidgetProperties.selection().observe((Widget)this.dateTimeBeginOfSeries);
        IObservableValue seriesStartDateSerienTerminObserveValue = PojoProperties.value((String)"seriesStartDate").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeBeginOfSeriesObserveWidget, seriesStartDateSerienTerminObserveValue, null, null);
        ISWTObservableValue observeTextTxtReasonObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtReason);
        IObservableValue reasonSerienTerminObserveValue = PojoProperties.value((String)"reason").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeTextTxtReasonObserveWidget, reasonSerienTerminObserveValue, null, null);
        ISWTObservableValue observeSelectionDateEndsOnObserveWidget = WidgetProperties.selection().observe((Widget)this.dateEndsOn);
        IObservableValue endsOnDateSerienTerminObserveValue = PojoProperties.value((String)"endsOnDate").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeSelectionDateEndsOnObserveWidget, endsOnDateSerienTerminObserveValue, null, null);
        ISWTObservableValue observeTextTxtEndsAfterNOccurencesObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEndsAfterNOccurences);
        IObservableValue endsAfterNDatesSerienTerminObserveValue = PojoProperties.value((String)"endsAfterNDates").observe((Object)this.serienTermin);
        bindingContext.bindValue((IObservableValue)observeTextTxtEndsAfterNOccurencesObserveWidget, endsAfterNDatesSerienTerminObserveValue, null, null);
        return bindingContext;
    }

    private void updateSpinner() {
        int startTime;
        int endTime = this.dateTimeEnd.getHours() * 60 + this.dateTimeEnd.getMinutes();
        int result = endTime - (startTime = this.dateTimeBegin.getHours() * 60 + this.dateTimeBegin.getMinutes());
        if (result < 0) {
            result = 0;
        }
        this.durationSpinner.setSelection(result);
    }

    public SerienTermin getSerienTermin() {
        return this.serienTermin;
    }
}

