/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.series;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.EndingType;
import ch.elexis.agenda.series.SeriesType;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.elexis.data.User;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerienTermin {
    public static DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
    public static DateFormat timeFormat = new SimpleDateFormat("HHmm");
    public static DecimalFormat decimalFormat = new DecimalFormat("00");
    private Date beginTime;
    private Date endTime;
    private Date seriesStartDate;
    private Date endsOnDate;
    private String endsAfterNDates;
    private SeriesType seriesType;
    private EndingType endingType;
    private String seriesPatternString;
    private String endingPatternString;
    private Kontakt contact;
    private String freeText;
    private String reason;
    private String groupId;
    private Termin rootTermin;
    public static final long SECOND_MILLIS = 1000L;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long YEAR_MILLIS = 31536000000L;
    private static Logger logger = LoggerFactory.getLogger(SerienTermin.class);

    public SerienTermin() {
        this.beginTime = new Date();
        Calendar endTimeCalendar = Calendar.getInstance();
        endTimeCalendar.add(12, 30);
        this.endTime = endTimeCalendar.getTime();
        GregorianCalendar startDateMidnight = new GregorianCalendar();
        startDateMidnight.set(11, 0);
        startDateMidnight.set(12, 0);
        startDateMidnight.set(13, 0);
        startDateMidnight.set(14, 0);
        this.seriesStartDate = startDateMidnight.getTime();
        this.seriesType = SeriesType.WEEKLY;
        this.seriesPatternString = "1,2";
        this.endingType = EndingType.ON_SPECIFIC_DATE;
        Calendar nextWeek = Calendar.getInstance();
        nextWeek.add(6, 7);
        this.endsOnDate = nextWeek.getTime();
        this.contact = ElexisEventDispatcher.getSelectedPatient();
        if (this.contact == null) {
            this.freeText = "";
        }
    }

    public SerienTermin(IPlannable pl) {
        Termin t = (Termin)pl;
        this.groupId = t.get("linkgroup");
        this.rootTermin = Termin.load(this.groupId);
        this.contact = this.rootTermin.getKontakt();
        if (this.contact == null) {
            this.setFreeText(this.rootTermin.get("Wer"));
        }
        this.reason = this.rootTermin.getGrund();
        this.parseSerienTerminConfigurationString(this.rootTermin.get("Extension"));
    }

    private void parseSerienTerminConfigurationString(String serienTerminConfigurationString) {
        String[] terms = serienTerminConfigurationString.split(";");
        String[] termin = terms[0].split(",");
        SimpleDateFormat timeDf = new SimpleDateFormat("HHmm");
        SimpleDateFormat dateDf = new SimpleDateFormat("ddMMyyyy");
        try {
            this.beginTime = timeDf.parse(termin[0]);
            this.endTime = timeDf.parse(termin[1]);
            this.seriesStartDate = dateDf.parse(terms[3]);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
        }
        char seriesTypeCharacter = terms[1].toUpperCase().charAt(0);
        this.setSeriesType(SeriesType.getForCharacter(seriesTypeCharacter));
        this.seriesPatternString = terms[2];
        char endingTypeCharacter = terms[4].toUpperCase().charAt(0);
        this.endingType = EndingType.getForCharacter(endingTypeCharacter);
        this.endingPatternString = terms[5];
        switch (this.endingType) {
            case ON_SPECIFIC_DATE: {
                try {
                    this.endsOnDate = dateDf.parse(this.endingPatternString);
                }
                catch (Exception e) {
                    logger.error("unexpected exception", (Throwable)e);
                }
                break;
            }
            case AFTER_N_OCCURENCES: {
                this.endsAfterNDates = this.endingPatternString;
                break;
            }
        }
    }

    public void persist() {
        if (this.groupId != null) {
            this.delete(false);
        }
        this.createRootDate();
        this.createSubSequentDates();
    }

    public void delete(boolean askForConfirmation) {
        this.rootTermin.delete(askForConfirmation);
    }

    private void createSubSequentDates() {
        TimeTool dateIncrementer = this.rootTermin.getStartTime();
        int occurences = 0;
        TimeTool endingDate = null;
        if (this.endingType.equals((Object)EndingType.AFTER_N_OCCURENCES)) {
            occurences = Integer.parseInt(this.endsAfterNDates) - 1;
        } else {
            endingDate = new TimeTool(this.endsOnDate);
        }
        switch (this.seriesType) {
            case DAILY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    occurences = dateIncrementer.daysTo(endingDate) + 1;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(6, 1);
                    this.writeSubsequentDateEntry(dateIncrementer);
                    ++i;
                }
                break;
            }
            case WEEKLY: {
                String[] separatedSeriesPattern = this.getSeriesPatternString().split(",");
                int weekStepSize = Integer.parseInt(separatedSeriesPattern[0]);
                System.out.println("week step size =" + weekStepSize);
                int i = 1;
                while (i < separatedSeriesPattern[1].length()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dateIncrementer.getTime());
                    int dayValue = Integer.parseInt(String.valueOf(separatedSeriesPattern[1].charAt(i)));
                    cal.set(7, dayValue);
                    this.writeSubsequentDateEntry(new TimeTool(cal.getTime()));
                    ++i;
                }
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    long milisecondsDiff = 0L;
                    if (endingDate != null) {
                        milisecondsDiff = endingDate.getTime().getTime() - dateIncrementer.getTime().getTime();
                    }
                    int days = (int)(milisecondsDiff / 86400000L);
                    int weeks = days / 7;
                    occurences = weeks / weekStepSize;
                }
                i = 0;
                while (i < occurences) {
                    dateIncrementer.add(3, weekStepSize);
                    int j = 0;
                    while (j < separatedSeriesPattern[1].length()) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(dateIncrementer.getTime());
                        int dayValue = Integer.parseInt(String.valueOf(separatedSeriesPattern[1].charAt(j)));
                        cal.set(7, dayValue);
                        this.writeSubsequentDateEntry(new TimeTool(cal.getTime()));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case MONTHLY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    occurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(2, 1);
                    this.writeSubsequentDateEntry(dateIncrementer);
                    ++i;
                }
                break;
            }
            case YEARLY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    int monthOccurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                    occurences = monthOccurences / 12;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(1, 1);
                    this.writeSubsequentDateEntry(dateIncrementer);
                    ++i;
                }
                break;
            }
        }
    }

    private void writeSubsequentDateEntry(TimeTool dateIncrementer) {
        TimeTool endTime = new TimeTool(dateIncrementer);
        endTime.addMinutes(this.getAppointmentDuration());
        TimeSpan ts = new TimeSpan(dateIncrementer, endTime);
        Termin t = new Termin(Activator.getDefault().getActResource(), ts, "series");
        t.set("linkgroup", this.groupId);
        System.out.println("writing subsequent date entry " + endTime.dump());
    }

    private void createRootDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(this.seriesStartDate);
        cal.add(10, this.beginTime.getHours());
        cal.add(12, this.beginTime.getMinutes());
        TimeTool startTime = this.getRootTerminStartTime(cal);
        TimeTool endTime = new TimeTool(startTime);
        endTime.addMinutes(this.getAppointmentDuration());
        TimeSpan ts = new TimeSpan(startTime, endTime);
        this.rootTermin = new Termin(Activator.getDefault().getActResource(), ts, "series");
        this.groupId = this.rootTermin.getId();
        this.rootTermin.set("linkgroup", this.groupId);
        if (this.contact != null) {
            this.rootTermin.setKontakt(this.contact);
        } else {
            this.rootTermin.set("Wer", this.getFreeText());
        }
        this.rootTermin.setGrund(this.reason);
        this.rootTermin.set("ErstelltVon", ElexisEventDispatcher.getSelected(User.class).getLabel());
        this.rootTermin.set("Extension", this.toString());
    }

    private TimeTool getRootTerminStartTime(Calendar cal) {
        TimeTool tt = new TimeTool(cal.getTime());
        switch (this.seriesType) {
            case DAILY: {
                return tt;
            }
            case WEEKLY: {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(cal.getTime());
                int firstDay = Integer.parseInt(String.valueOf(this.getSeriesPatternString().split(",")[1].charAt(0)));
                cal2.set(7, firstDay);
                TimeTool ret = new TimeTool(cal2.getTime());
                return ret;
            }
            case MONTHLY: {
                int monthDay = Integer.parseInt(this.seriesPatternString);
                Calendar calendarMonth = Calendar.getInstance();
                calendarMonth.clear();
                calendarMonth.set(1, tt.get(1));
                if (tt.get(5) <= monthDay) {
                    calendarMonth.set(2, tt.get(2));
                } else {
                    calendarMonth.set(2, tt.get(2));
                    calendarMonth.add(2, 1);
                }
                calendarMonth.set(5, monthDay);
                return new TimeTool(calendarMonth.getTime());
            }
            case YEARLY: {
                Calendar targetCal = Calendar.getInstance();
                targetCal.clear();
                targetCal.set(1, tt.get(1));
                int day = Integer.parseInt(this.seriesPatternString.substring(0, 2));
                int month = Integer.parseInt(this.seriesPatternString.substring(2, 4));
                targetCal.set(5, day);
                targetCal.set(2, month - 1);
                TimeTool target = new TimeTool(targetCal.getTime());
                if (tt.isBefore(target)) {
                    return target;
                }
                target.add(1, 1);
                return target;
            }
        }
        return tt;
    }

    public boolean collidesWithLockTimes() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(this.seriesStartDate);
        cal.add(10, this.beginTime.getHours());
        cal.add(12, this.beginTime.getMinutes());
        TimeTool startTime = this.getRootTerminStartTime(cal);
        TimeTool endTime = new TimeTool(startTime);
        endTime.addMinutes(this.getAppointmentDuration());
        TimeSpan ts = new TimeSpan(startTime, endTime);
        this.rootTermin = new Termin(Activator.getDefault().getActResource(), ts, "series");
        TimeTool dateIncrementer = this.rootTermin.getStartTime();
        List<TimeTool> seriesTimesList = this.getAllTimesOfSeries(dateIncrementer);
        String bereich = Activator.getDefault().getActResource();
        for (TimeTool sTime : seriesTimesList) {
            TimeTool eTime = new TimeTool(sTime);
            eTime.addMinutes(this.getAppointmentDuration());
            TimeSpan span = new TimeSpan(sTime, eTime);
            Query qbe = new Query(Termin.class);
            qbe.add("Typ", "=", Messages.Termin_range_locked);
            qbe.add("Tag", "=", sTime.toString(9));
            qbe.add("BeiWem", "=", bereich);
            qbe.add("deleted", "=", "0");
            List locks = qbe.execute();
            for (Termin lockTermin : locks) {
                TimeSpan lockSpan = lockTermin.getTimeSpan();
                if (lockSpan.overlap(span) == null) continue;
                this.rootTermin.delete(false);
                return true;
            }
        }
        this.rootTermin.delete(false);
        return false;
    }

    private List<TimeTool> getAllTimesOfSeries(TimeTool dateIncrementer) {
        ArrayList<TimeTool> seriesTimesList = new ArrayList<TimeTool>();
        int occurences = 0;
        TimeTool endingDate = null;
        if (this.endingType.equals((Object)EndingType.AFTER_N_OCCURENCES)) {
            occurences = Integer.parseInt(this.endsAfterNDates) - 1;
        } else {
            endingDate = new TimeTool(this.endsOnDate);
        }
        switch (this.seriesType) {
            case DAILY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    occurences = dateIncrementer.daysTo(endingDate) + 1;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(6, 1);
                    seriesTimesList.add(dateIncrementer);
                    ++i;
                }
                break;
            }
            case WEEKLY: {
                String[] seriesPattern = this.getSeriesPatternString().split(",");
                int weekStepSize = Integer.parseInt(seriesPattern[0]);
                int i = 1;
                while (i < seriesPattern[1].length()) {
                    Calendar calWeekOne = Calendar.getInstance();
                    calWeekOne.setTime(dateIncrementer.getTime());
                    int dayValue = Integer.parseInt(String.valueOf(seriesPattern[1].charAt(i)));
                    calWeekOne.set(7, dayValue);
                    seriesTimesList.add(new TimeTool(calWeekOne.getTime()));
                    ++i;
                }
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    long milisecondsDiff = 0L;
                    if (endingDate != null) {
                        milisecondsDiff = endingDate.getTime().getTime() - dateIncrementer.getTime().getTime();
                    }
                    int days = (int)(milisecondsDiff / 86400000L);
                    int weeks = days / 7;
                    occurences = weeks / weekStepSize;
                }
                i = 0;
                while (i < occurences) {
                    dateIncrementer.add(3, weekStepSize);
                    int j = 0;
                    while (j < seriesPattern[1].length()) {
                        Calendar calSub = Calendar.getInstance();
                        calSub.setTime(dateIncrementer.getTime());
                        int dayValue = Integer.parseInt(String.valueOf(seriesPattern[1].charAt(j)));
                        calSub.set(7, dayValue);
                        seriesTimesList.add(new TimeTool(calSub.getTime()));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case MONTHLY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    occurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(2, 1);
                    seriesTimesList.add(dateIncrementer);
                    ++i;
                }
                break;
            }
            case YEARLY: {
                if (this.endingType.equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    int monthOccurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                    occurences = monthOccurences / 12;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(1, 1);
                    seriesTimesList.add(dateIncrementer);
                    ++i;
                }
                break;
            }
        }
        return seriesTimesList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            SimpleDateFormat timeDf = new SimpleDateFormat("HHmm");
            SimpleDateFormat dateDf = new SimpleDateFormat("ddMMyyyy");
            sb.append(timeDf.format(this.beginTime));
            sb.append(",");
            sb.append(timeDf.format(this.endTime));
            sb.append(";");
            sb.append(this.getSeriesType().getSeriesTypeCharacter());
            sb.append(";");
            sb.append(this.seriesPatternString);
            sb.append(";");
            sb.append(dateDf.format(this.seriesStartDate));
            sb.append(";");
            sb.append(this.endingType.getEndingTypeChar());
            sb.append(";");
            switch (this.getEndingType()) {
                case AFTER_N_OCCURENCES: {
                    sb.append(this.endsAfterNDates);
                    break;
                }
                case ON_SPECIFIC_DATE: {
                    sb.append(dateDf.format(this.endsOnDate));
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            sb.append("incomplete configuration string: " + npe.getMessage());
        }
        return sb.toString();
    }

    public int getAppointmentDuration() {
        int result = (int)(this.endTime.getTime() / 60000L - this.beginTime.getTime() / 60000L);
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getSeriesStartDate() {
        return this.seriesStartDate;
    }

    public void setSeriesStartDate(Date seriesStartDate) {
        this.seriesStartDate = seriesStartDate;
    }

    public EndingType getEndingType() {
        return this.endingType;
    }

    public void setEndingType(EndingType endingType) {
        this.endingType = endingType;
    }

    public String getSeriesPatternString() {
        return this.seriesPatternString;
    }

    public void setSeriesPatternString(String seriesPatternString) {
        this.seriesPatternString = seriesPatternString;
    }

    public String getEndingPatternString() {
        return this.endingPatternString;
    }

    public void setEndingPatternString(String endingPatternString) {
        this.endingPatternString = endingPatternString;
    }

    public Kontakt getContact() {
        return this.contact;
    }

    public void setContact(Kontakt contact) {
        this.contact = contact;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public SeriesType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(SeriesType seriesType) {
        this.seriesType = seriesType;
    }

    public Date getEndsOnDate() {
        return this.endsOnDate;
    }

    public void setEndsOnDate(Date endsOnDate) {
        this.endsOnDate = endsOnDate;
    }

    public String getEndsAfterNDates() {
        return this.endsAfterNDates;
    }

    public void setEndsAfterNDates(String endsAfterNDates) {
        this.endsAfterNDates = endsAfterNDates;
    }

    public Termin getRootTermin() {
        return this.rootTermin;
    }

    public String getFreeText() {
        return this.freeText;
    }

    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }
}

