/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.preferences;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.Hashtable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Zeitvorgaben
extends PreferencePage
implements IWorkbenchPreferencePage {
    Table table;
    TableColumn[] cols;
    TableItem[] rows;
    TableCursor cursor;
    ControlEditor editor;
    String[] bereiche;

    public Zeitvorgaben() {
        super(Messages.Zeitvorgaben_timePrefs);
    }

    protected Control createContents(Composite parent) {
        Composite check = new Composite(parent, 2048);
        check.setLayout((Layout)new GridLayout());
        this.bereiche = CoreHub.globalCfg.get("agenda/bereiche", Messages.Zeitvorgaben_praxis).split(",");
        this.table = new Table(check, 66304);
        this.cols = new TableColumn[this.bereiche.length + 1];
        this.cols[0] = new TableColumn(this.table, 0);
        this.cols[0].setText(Messages.Zeitvorgaben_terminTypes);
        this.cols[0].setWidth(70);
        this.cursor = new TableCursor(this.table, 0);
        this.editor = new ControlEditor((Composite)this.cursor);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Zeitvorgaben.this.table.setSelection(new TableItem[]{Zeitvorgaben.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = Zeitvorgaben.this.cursor.getRow();
                int column = Zeitvorgaben.this.cursor.getColumn();
                Zeitvorgaben.this.doEdit(row.getText(column));
            }
        });
        this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character > '0') {
                    StringBuilder sb = new StringBuilder();
                    sb.append(e.character);
                    Zeitvorgaben.this.doEdit(sb.toString());
                }
            }
        });
        int i = 1;
        String[] stringArray = this.bereiche;
        int n = this.bereiche.length;
        int n2 = 0;
        while (n2 < n) {
            String bereich = stringArray[n2];
            this.cols[i] = new TableColumn(this.table, 0);
            this.cols[i].setWidth(70);
            this.cols[i++].setText(bereich);
            ++n2;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableItem t0 = new TableItem(this.table, 0);
        String[] stringArray2 = Termin.TerminTypes;
        int n3 = Termin.TerminTypes.length;
        n = 0;
        while (n < n3) {
            String typ = stringArray2[n];
            if (!typ.equals(Termin.typFrei()) && !typ.equals(Termin.typReserviert())) {
                TableItem it = new TableItem(this.table, 0);
                it.setText(0, typ);
                i = 1;
                String[] stringArray3 = this.bereiche;
                int n4 = this.bereiche.length;
                int n5 = 0;
                while (n5 < n4) {
                    String bereich = stringArray3[n5];
                    Hashtable<String, String> map = Plannables.getTimePrefFor(bereich);
                    String tStd = map.get("std");
                    String tTyp = map.get(typ);
                    t0.setText(i, tStd);
                    if (tTyp == null) {
                        tTyp = tStd;
                    }
                    it.setText(i++, tTyp);
                    ++n5;
                }
            }
            ++n;
        }
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return check;
    }

    public void init(IWorkbench workbench) {
    }

    private void doEdit(String inp) {
        final Text text = new Text((Composite)this.cursor, 2048);
        text.setText(inp);
        text.setSelection(inp.length());
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.keyCode == 0x1000002) {
                    TableItem it = Zeitvorgaben.this.cursor.getRow();
                    int idx = Zeitvorgaben.this.cursor.getColumn();
                    String ntext = text.getText();
                    it.setText(idx, text.getText());
                    Hashtable<String, String> map = Plannables.getTimePrefFor(Zeitvorgaben.this.cols[idx].getText());
                    String typ = it.getText(0);
                    if (typ == null || typ.isEmpty()) {
                        typ = "std";
                    }
                    map.put(typ, ntext);
                    Plannables.setTimePrefFor(Zeitvorgaben.this.cols[idx].getText(), map);
                    text.dispose();
                }
                if (e.character == '\u001b') {
                    text.dispose();
                }
            }
        });
        this.editor.setEditor((Control)text);
        text.setFocus();
    }
}

