/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.preferences;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.util.TermineLockedTimesUpdater;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class Tageseinteilung
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text tMo;
    Text tDi;
    Text tMi;
    Text tDo;
    Text tFr;
    Text tSa;
    Text tSo;
    int actBereich = 0;
    String[] bereiche = CoreHub.globalCfg.get("agenda/bereiche", Messages.Tageseinteilung_praxis).split(",");
    private Composite compositeDayBorders;
    private Text sodt;
    private Text eodt;
    private ComboViewer comboViewerDayEditSelector;
    private Button btnEditValuesFor;
    private Label lblChangedValuesAre;
    private DateTime dateTimeStartingFrom;
    private Button btnApplyEdit;
    private Composite compositeEditStarting;
    private TimeTool.DAYS editSelection;
    private Text editSelectionText;
    private Color originalBackgroundColor;

    public Tageseinteilung() {
        super(Messages.Tageseinteilung_dayPlanning);
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        new Label(ret, 0).setText(Messages.Tageseinteilung_enterPeriods);
        final Combo cbBereich = new Combo(ret, 12);
        cbBereich.setItems(this.bereiche);
        Composite grid = new Composite(ret, 2048);
        grid.setLayout((Layout)new GridLayout(7, true));
        grid.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(grid, 0x1000000).setText(Messages.Tageseinteilung_mo);
        new Label(grid, 0x1000000).setText(Messages.Tageseinteilung_tu);
        new Label(grid, 0x1000000).setText(Messages.Tageseinteilung_we);
        new Label(grid, 0x1000000).setText(Messages.Tageseinteilung_th);
        new Label(grid, 0).setText(Messages.Tageseinteilung_fr);
        new Label(grid, 0).setText(Messages.Tageseinteilung_sa);
        new Label(grid, 0).setText(Messages.Tageseinteilung_so);
        this.tMo = new Text(grid, 2050);
        this.tMo.setEnabled(false);
        this.tMo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.originalBackgroundColor = this.tMo.getBackground();
        this.tDi = new Text(grid, 2050);
        this.tDi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tDi.setEnabled(false);
        this.tMi = new Text(grid, 2050);
        this.tMi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tMi.setEnabled(false);
        this.tDo = new Text(grid, 2050);
        this.tDo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tDo.setEnabled(false);
        this.tFr = new Text(grid, 2050);
        this.tFr.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tFr.setEnabled(false);
        this.tSa = new Text(grid, 2050);
        this.tSa.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tSa.setEnabled(false);
        this.tSo = new Text(grid, 2050);
        this.tSo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tSo.setEnabled(false);
        cbBereich.select(this.actBereich);
        Composite editDayComposite = new Composite(grid, 0);
        editDayComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)7, (boolean)true, (int)1, (boolean)false));
        editDayComposite.setLayout((Layout)new GridLayout(3, false));
        this.btnEditValuesFor = new Button(editDayComposite, 0);
        this.btnEditValuesFor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text[] days;
                StructuredSelection ss = (StructuredSelection)Tageseinteilung.this.comboViewerDayEditSelector.getSelection();
                Tageseinteilung.this.editSelection = (TimeTool.DAYS)ss.getFirstElement();
                if (Tageseinteilung.this.editSelection == null) {
                    return;
                }
                Text[] textArray = days = new Text[]{Tageseinteilung.this.tMo, Tageseinteilung.this.tDi, Tageseinteilung.this.tMi, Tageseinteilung.this.tDo, Tageseinteilung.this.tFr, Tageseinteilung.this.tSa, Tageseinteilung.this.tSo};
                int n = days.length;
                int n2 = 0;
                while (n2 < n) {
                    Text text = textArray[n2];
                    text.setEnabled(false);
                    text.setBackground(Tageseinteilung.this.originalBackgroundColor);
                    ++n2;
                }
                switch (Tageseinteilung.this.editSelection) {
                    case MONDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tMo;
                        break;
                    }
                    case TUESDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tDi;
                        break;
                    }
                    case FRIDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tFr;
                        break;
                    }
                    case SATURDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tSa;
                        break;
                    }
                    case SUNDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tSo;
                        break;
                    }
                    case THURSDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tDo;
                        break;
                    }
                    case WEDNESDAY: {
                        Tageseinteilung.this.editSelectionText = Tageseinteilung.this.tMi;
                        break;
                    }
                }
                Tageseinteilung.this.editSelectionText.setEnabled(true);
                Tageseinteilung.this.editSelectionText.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(7));
                Tageseinteilung.this.btnApplyEdit.setEnabled(true);
                Tageseinteilung.this.dateTimeStartingFrom.setEnabled(true);
                Tageseinteilung.this.editSelectionText.setFocus();
            }
        });
        this.btnEditValuesFor.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnEditValuesFor.setText(Messages.Tageseinteilung_lblEditValuesFor_text);
        this.comboViewerDayEditSelector = new ComboViewer(editDayComposite, 0);
        Combo comboDayEditSelector = this.comboViewerDayEditSelector.getCombo();
        comboDayEditSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeEditStarting = new Composite(editDayComposite, 0);
        this.compositeEditStarting.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeEditStarting = new GridLayout(3, false);
        gl_compositeEditStarting.verticalSpacing = 0;
        gl_compositeEditStarting.marginHeight = 0;
        this.compositeEditStarting.setLayout((Layout)gl_compositeEditStarting);
        this.lblChangedValuesAre = new Label(this.compositeEditStarting, 0);
        this.lblChangedValuesAre.setText(Messages.Tageseinteilung_lblChangedValuesAre_text);
        this.dateTimeStartingFrom = new DateTime(this.compositeEditStarting, 2048);
        TimeTool tomorrow = new TimeTool();
        tomorrow.addDays(1);
        this.dateTimeStartingFrom.setDate(tomorrow.get(1), tomorrow.get(2), tomorrow.get(5));
        this.dateTimeStartingFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tageseinteilung.this.setErrorMessage(null);
                DateTime dt = (DateTime)e.getSource();
                int day = Tageseinteilung.this.dateTimeStartingFrom.getDay();
                int month = Tageseinteilung.this.dateTimeStartingFrom.getMonth();
                int year = Tageseinteilung.this.dateTimeStartingFrom.getYear();
                String timeString = String.valueOf(String.format("%02d", day)) + "." + String.format("%02d", month + 1) + "." + String.format("%04d", year);
                TimeTool tt = new TimeTool(timeString);
                if (tt.isBefore(new TimeTool())) {
                    Tageseinteilung.this.setErrorMessage(Messages.Tageseinteilung_no_past_Date);
                    TimeTool tomorrow = new TimeTool();
                    tomorrow.addDays(1);
                    Tageseinteilung.this.dateTimeStartingFrom.setDate(tomorrow.get(1), tomorrow.get(2), tomorrow.get(5));
                }
            }
        });
        this.dateTimeStartingFrom.setEnabled(false);
        this.btnApplyEdit = new Button(this.compositeEditStarting, 0);
        this.btnApplyEdit.setText(Messages.Tageseinteilung_btnNewButton_text);
        this.btnApplyEdit.setEnabled(false);
        this.btnApplyEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int day = Tageseinteilung.this.dateTimeStartingFrom.getDay();
                int month = Tageseinteilung.this.dateTimeStartingFrom.getMonth();
                int year = Tageseinteilung.this.dateTimeStartingFrom.getYear();
                String timeString = String.valueOf(String.format("%02d", day)) + "." + String.format("%02d", month + 1) + "." + String.format("%04d", year);
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(UiDesk.getTopShell());
                TermineLockedTimesUpdater irp = new TermineLockedTimesUpdater(new TimeTool(timeString), Tageseinteilung.this.editSelection, Tageseinteilung.this.editSelectionText.getText(), Termin.TerminBereiche[Tageseinteilung.this.actBereich]);
                try {
                    pmd.run(false, false, (IRunnableWithProgress)irp);
                    Tageseinteilung.this.editSelectionText.setBackground(Tageseinteilung.this.originalBackgroundColor);
                    Tageseinteilung.this.editSelectionText.setEnabled(false);
                }
                catch (InvocationTargetException e1) {
                    Status status = new Status(2, "ch.elexis.agenda", "Execution Error", (Throwable)e1);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
                catch (InterruptedException e1) {
                    Status status = new Status(2, "ch.elexis.agenda", "Execution Error", (Throwable)e1);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
                Tageseinteilung.this.dateTimeStartingFrom.setEnabled(false);
                Tageseinteilung.this.btnApplyEdit.setEnabled(false);
            }
        });
        this.comboViewerDayEditSelector.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerDayEditSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeTool.DAYS day = (TimeTool.DAYS)element;
                return day.fullName;
            }
        });
        TimeTool.DAYS[] days = TimeTool.DAYS.values();
        this.comboViewerDayEditSelector.setInput((Object)days);
        this.comboViewerDayEditSelector.setSelection((ISelection)new StructuredSelection((Object)days[0]));
        this.compositeDayBorders = new Composite(ret, 0);
        this.compositeDayBorders.setLayout((Layout)new GridLayout(2, false));
        Composite compositeStart = new Composite(this.compositeDayBorders, 0);
        compositeStart.setLayout((Layout)new GridLayout(3, false));
        Label btnDayStartHourIsSet = new Label(compositeStart, 32);
        btnDayStartHourIsSet.setText(Messages.Tageseinteilung_btnCheckButton_text);
        this.sodt = new Text(compositeStart, 2048);
        this.sodt.setTextLimit(4);
        Label lblHours = new Label(compositeStart, 0);
        lblHours.setText(Messages.Tageseinteilung_lblHours_text);
        Composite compositeEnd = new Composite(this.compositeDayBorders, 0);
        compositeEnd.setLayout((Layout)new GridLayout(3, false));
        Label btnEndStartHourIsSet = new Label(compositeEnd, 32);
        btnEndStartHourIsSet.setText(Messages.Tageseinteilung_btnCheckButton_text_1);
        this.eodt = new Text(compositeEnd, 2048);
        this.eodt.setTextLimit(4);
        Label lblHours_1 = new Label(compositeEnd, 0);
        lblHours_1.setText(Messages.Tageseinteilung_lblHours_1_text);
        this.reload();
        cbBereich.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = cbBereich.getSelectionIndex();
                if (idx != -1) {
                    Tageseinteilung.this.save();
                    Tageseinteilung.this.actBereich = idx;
                    Tageseinteilung.this.reload();
                }
            }
        });
        return ret;
    }

    void reload() {
        Hashtable<String, String> map = Plannables.getDayPrefFor(this.bereiche[this.actBereich]);
        String p = map.get(Messages.Tageseinteilung_mo);
        this.tMo.setText(p == null ? "0000-0800\n1800-2359" : p);
        p = map.get(Messages.Tageseinteilung_tu);
        this.tDi.setText(p == null ? "0000-0800\n1800-2359" : p);
        p = map.get(Messages.Tageseinteilung_we);
        this.tMi.setText(p == null ? "0000-0800\n1800-2359" : p);
        p = map.get(Messages.Tageseinteilung_th);
        this.tDo.setText(p == null ? "0000-0800\n1800-2359" : p);
        p = map.get(Messages.Tageseinteilung_fr);
        this.tFr.setText(p == null ? "0000-0800\n1800-2359" : p);
        p = map.get(Messages.Tageseinteilung_sa);
        this.tSa.setText(p == null ? "0000-0800\n1200-2359" : p);
        p = map.get(Messages.Tageseinteilung_su);
        this.tSo.setText(p == null ? "0000-2359" : p);
        String sodtString = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
        this.sodt.setText(sodtString);
        String eodtString = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
        this.eodt.setText(eodtString);
    }

    void save() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put(Messages.Tageseinteilung_mo, this.tMo.getText());
        map.put(Messages.Tageseinteilung_tu, this.tDi.getText());
        map.put(Messages.Tageseinteilung_we, this.tMi.getText());
        map.put(Messages.Tageseinteilung_th, this.tDo.getText());
        map.put(Messages.Tageseinteilung_fr, this.tFr.getText());
        map.put(Messages.Tageseinteilung_sa, this.tSa.getText());
        map.put(Messages.Tageseinteilung_su, this.tSo.getText());
        Plannables.setDayPrefFor(this.bereiche[this.actBereich], map);
        CoreHub.globalCfg.set("agenda/beginnStundeTagesdarstellung", this.sodt.getText());
        CoreHub.globalCfg.set("agenda/endStundeTagesdarstellung", this.eodt.getText());
        CoreHub.globalCfg.flush();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.save();
        super.performApply();
    }

    public boolean performOk() {
        this.save();
        return super.performOk();
    }
}

