/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.preferences;

import ch.elexis.agenda.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.AddStringEntryAction;
import ch.elexis.core.ui.actions.MoveEntryWithinListAction;
import ch.elexis.core.ui.actions.RemoveSelectedEntriesAction;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.provider.ILocalizedEnumLabelProvider;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AgendaDefinitionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);
    private Link linkAreaTypeValue;
    private ListViewer listViewerArea;
    private ListViewer listViewerAppointmentTypes;
    private ListViewer listViewerAppointmentStatus;
    private List<String> areas;
    private List<String> appointmentTypes;
    private List<String> appointmentStatus;
    private Button btnAvoidDoubleBooking;
    private ComboViewer comboViewerAreaType;

    public AgendaDefinitionPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)this.prefs);
        this.setDescription(Messages.AgendaDefinitionen_defForAgenda);
        this.areas = new ArrayList<String>(CoreHub.globalCfg.getAsList("agenda/bereiche"));
        this.appointmentTypes = new ArrayList<String>(CoreHub.globalCfg.getAsList("agenda/TerminTypen"));
        this.appointmentStatus = new ArrayList<String>(CoreHub.globalCfg.getAsList("agenda/TerminStatus"));
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite compAreas = new Composite(container, 0);
        compAreas.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compAreas.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(compAreas, 0);
        lblNewLabel.setText(Messages.AgendaDefinitionen_shortCutsForBer);
        new Label(compAreas, 0);
        this.listViewerArea = new ListViewer(compAreas, 2560);
        this.listViewerArea.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerArea.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.listViewerArea.addSelectionChangedListener(sc -> {
            String type = CoreHub.globalCfg.get("agenda/bereich/" + sc.getStructuredSelection().getFirstElement() + "/type", null);
            if (type != null && type.startsWith(AreaType.CONTACT.name())) {
                Kontakt contact = Kontakt.load((String)type.substring(AreaType.CONTACT.name().length() + 1));
                this.comboViewerAreaType.setSelection((ISelection)new StructuredSelection((Object)AreaType.CONTACT));
                this.linkAreaTypeValue.setText("<a>" + contact.getLabel() + "</a>");
                return;
            }
            this.comboViewerAreaType.setSelection((ISelection)new StructuredSelection((Object)AreaType.GENERIC));
            this.linkAreaTypeValue.setText("");
        });
        org.eclipse.swt.widgets.List listArea = this.listViewerArea.getList();
        GridData gd_listArea = new GridData(4, 4, true, false, 1, 1);
        gd_listArea.heightHint = 80;
        listArea.setLayoutData((Object)gd_listArea);
        MenuManager listAreaMenuManager = new MenuManager();
        listAreaMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerArea, this.areas, true));
        listAreaMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerArea, this.areas, false));
        listAreaMenuManager.add((IContributionItem)new Separator());
        listAreaMenuManager.add((IAction)new AddStringEntryAction((StructuredViewer)this.listViewerArea, this.areas));
        listAreaMenuManager.add((IAction)new RemoveSelectedEntriesAction((StructuredViewer)this.listViewerArea, this.areas));
        Menu menu = listAreaMenuManager.createContextMenu((Control)listArea);
        listArea.setMenu(menu);
        Composite compositeAreaType = new Composite(compAreas, 0);
        compositeAreaType.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_compositeAreaType = new GridLayout(1, false);
        gl_compositeAreaType.horizontalSpacing = 0;
        gl_compositeAreaType.marginWidth = 0;
        gl_compositeAreaType.verticalSpacing = 0;
        gl_compositeAreaType.marginHeight = 0;
        compositeAreaType.setLayout((Layout)gl_compositeAreaType);
        Label lblAreaTypeLabel = new Label(compositeAreaType, 0);
        lblAreaTypeLabel.setBounds(0, 0, 59, 14);
        lblAreaTypeLabel.setText(Messages.AgendaDefinitionen_areaTypeLabel);
        this.comboViewerAreaType = new ComboViewer(compositeAreaType, 0);
        Combo comboAreaType = this.comboViewerAreaType.getCombo();
        comboAreaType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        comboAreaType.setSize(198, 22);
        this.comboViewerAreaType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerAreaType.setLabelProvider((IBaseLabelProvider)new ILocalizedEnumLabelProvider());
        this.comboViewerAreaType.setInput((Object)AreaType.values());
        this.comboViewerAreaType.setSelection((ISelection)new StructuredSelection((Object)AreaType.GENERIC));
        this.comboViewerAreaType.addSelectionChangedListener(sc -> {
            if (AreaType.CONTACT.equals(this.comboViewerAreaType.getStructuredSelection().getFirstElement())) {
                if (this.linkAreaTypeValue.getText().length() == 0) {
                    this.linkAreaTypeValue.setText("<a>select</a>");
                }
            } else {
                this.linkAreaTypeValue.setText("");
            }
        });
        MouseAdapter contactSelectorMouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                KontaktSelektor ks;
                int retVal;
                if (AreaType.CONTACT.equals(AgendaDefinitionPreferencePage.this.comboViewerAreaType.getStructuredSelection().getFirstElement()) && (retVal = (ks = new KontaktSelektor(UiDesk.getTopShell(), Anwender.class, "Bitte Kontakt ausw\u00e4hlen", "Selektieren Sie den zugeordneten Kontakt", null)).open()) == 0) {
                    String area = (String)AgendaDefinitionPreferencePage.this.listViewerArea.getStructuredSelection().getFirstElement();
                    Anwender anwender = (Anwender)ks.getSelection();
                    AgendaDefinitionPreferencePage.this.setAreaType(area, AreaType.CONTACT, anwender.getId());
                    AgendaDefinitionPreferencePage.this.linkAreaTypeValue.setText("<a>" + anwender.getLabel() + "</a>");
                }
            }
        };
        this.linkAreaTypeValue = new Link(compositeAreaType, 0);
        this.linkAreaTypeValue.addMouseListener((MouseListener)contactSelectorMouseListener);
        this.linkAreaTypeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.linkAreaTypeValue.setSize(59, 14);
        Composite compAppointmentTypes = new Composite(container, 0);
        compAppointmentTypes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compAppointmentTypes.setLayout((Layout)new GridLayout(1, false));
        Label lblLblappointmenttypestitle = new Label(compAppointmentTypes, 0);
        lblLblappointmenttypestitle.setText(Messages.AgendaDefinitionen_enterTypes);
        this.listViewerAppointmentTypes = new ListViewer(compAppointmentTypes, 2560);
        org.eclipse.swt.widgets.List listAppointmentTypes = this.listViewerAppointmentTypes.getList();
        GridData gd_listAppointmentTypes = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_listAppointmentTypes.heightHint = 60;
        listAppointmentTypes.setLayoutData((Object)gd_listAppointmentTypes);
        this.listViewerAppointmentTypes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerAppointmentTypes.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        MenuManager listViewerAppointmentTypesMenuManager = new MenuManager();
        listViewerAppointmentTypesMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerAppointmentTypes, this.appointmentTypes, true));
        listViewerAppointmentTypesMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerAppointmentTypes, this.appointmentTypes, false));
        listViewerAppointmentTypesMenuManager.add((IContributionItem)new Separator());
        listViewerAppointmentTypesMenuManager.add((IAction)new AddStringEntryAction((StructuredViewer)this.listViewerAppointmentTypes, this.appointmentTypes));
        listViewerAppointmentTypesMenuManager.add((IAction)new RemoveSelectedEntriesAction((StructuredViewer)this.listViewerAppointmentTypes, this.appointmentTypes));
        Menu listViewerAppointmentTypesmenu = listViewerAppointmentTypesMenuManager.createContextMenu((Control)listAppointmentTypes);
        listAppointmentTypes.setMenu(listViewerAppointmentTypesmenu);
        Composite compAppointmentStatus = new Composite(container, 0);
        compAppointmentStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compAppointmentStatus.setLayout((Layout)new GridLayout(1, false));
        Label lblAppointmenStatusTitle = new Label(compAppointmentStatus, 0);
        lblAppointmenStatusTitle.setText(Messages.AgendaDefinitionen_states);
        this.listViewerAppointmentStatus = new ListViewer(compAppointmentStatus, 2560);
        org.eclipse.swt.widgets.List listAppointmentStatus = this.listViewerAppointmentStatus.getList();
        GridData gd_listAppointmentStatus = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_listAppointmentStatus.heightHint = 60;
        listAppointmentStatus.setLayoutData((Object)gd_listAppointmentStatus);
        this.listViewerAppointmentStatus.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerAppointmentStatus.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        MenuManager listViewerAppointmentStatusMenuManager = new MenuManager();
        listViewerAppointmentStatusMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerAppointmentStatus, this.appointmentStatus, true));
        listViewerAppointmentStatusMenuManager.add((IAction)new MoveEntryWithinListAction((StructuredViewer)this.listViewerAppointmentStatus, this.appointmentStatus, false));
        listViewerAppointmentStatusMenuManager.add((IContributionItem)new Separator());
        listViewerAppointmentStatusMenuManager.add((IAction)new AddStringEntryAction((StructuredViewer)this.listViewerAppointmentStatus, this.appointmentStatus));
        listViewerAppointmentStatusMenuManager.add((IAction)new RemoveSelectedEntriesAction((StructuredViewer)this.listViewerAppointmentStatus, this.appointmentStatus));
        Menu listViewerAppointmentStatusmenu = listViewerAppointmentStatusMenuManager.createContextMenu((Control)listAppointmentStatus);
        listAppointmentStatus.setMenu(listViewerAppointmentStatusmenu);
        Label separator = new Label(container, 258);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalSpan = 3;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.verticalIndent = 0;
        separator.setLayoutData((Object)separatorGridData);
        this.btnAvoidDoubleBooking = new Button(container, 32);
        this.btnAvoidDoubleBooking.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.btnAvoidDoubleBooking.setText(Messages.AgendaDefinitionen_AvoidPatientDoubleBooking);
        this.btnAvoidDoubleBooking.setSelection(CoreHub.localCfg.get("agenda/patient/doppelteTerminvergabeVermeiden", false));
        this.refresh();
        return container;
    }

    private void setAreaType(String area, AreaType areaType, String value) {
        String key = "agenda/bereich/" + area + "/type";
        switch (areaType) {
            case CONTACT: {
                CoreHub.globalCfg.set(key, String.valueOf(areaType.name()) + "/" + value);
                break;
            }
            default: {
                CoreHub.globalCfg.remove(key);
            }
        }
    }

    private void refresh() {
        this.listViewerArea.setInput(this.areas);
        this.listViewerAppointmentTypes.setInput(this.appointmentTypes);
        this.listViewerAppointmentStatus.setInput(this.appointmentStatus);
    }

    protected void performApply() {
        CoreHub.globalCfg.setAsList("agenda/bereiche", this.areas);
        CoreHub.globalCfg.setAsList("agenda/TerminTypen", this.appointmentTypes);
        CoreHub.globalCfg.setAsList("agenda/TerminStatus", this.appointmentStatus);
        CoreHub.localCfg.set("agenda/patient/doppelteTerminvergabeVermeiden", this.btnAvoidDoubleBooking.getSelection());
        CoreHub.localCfg.flush();
        CoreHub.globalCfg.flush();
        super.performApply();
    }

    public void init(IWorkbench workbench) {
    }
}

