/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.actions;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.preferences.CorePreferenceInitializer;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Synchronizer {
    private static final Logger log = LoggerFactory.getLogger(Synchronizer.class);
    JdbcLink sync;
    int lastSync;
    static boolean pingPause = false;
    private Hashtable<String, String> map;
    Activator agenda;
    Query<Patient> qPat = new Query(Patient.class);

    public Synchronizer() {
        if (CoreHub.globalCfg.get("agenda/sync/enabled", false)) {
            String base = CorePreferenceInitializer.getDefaultDBPath();
            String typ = CoreHub.globalCfg.get("agenda/sync/db_type", "hsqldb");
            String connect = CoreHub.globalCfg.get("agenda/sync/db_connect", "jdbc:hsqldb:" + base + "/db");
            String dbhost = CoreHub.globalCfg.get("agenda/sync/db_host", "localhost");
            this.sync = typ.equalsIgnoreCase("mysql") ? JdbcLink.createMySqlLink((String)dbhost, (String)connect) : (typ.equalsIgnoreCase("postgresql") ? JdbcLink.createPostgreSQLLink((String)dbhost, (String)connect) : (typ.equalsIgnoreCase("odbc") ? JdbcLink.createODBCLink((String)dbhost) : null));
            if (this.sync != null) {
                if (!this.sync.connect(CoreHub.globalCfg.get("agenda/sync/db_user", "sa"), CoreHub.globalCfg.get("agenda/sync/db_pwd", ""))) {
                    log.warn(String.valueOf(Messages.Synchronizer_connctNotSuccessful) + this.sync.lastErrorString);
                    this.sync = null;
                } else {
                    this.map = Synchronizer.getBereichMapping();
                }
            }
        }
        Termin.load("1");
        this.lastSync = TimeTool.getTimeInSeconds();
    }

    public static void pause(boolean p) {
        pingPause = p;
    }

    public void doSync() {
        block15: {
            if (pingPause) {
                return;
            }
            pingPause = true;
            if (this.sync != null) {
                JdbcLink.Stm stmOther = this.sync.getStatement();
                JdbcLink.Stm stmMine = PersistentObject.getConnection().getStatement();
                StringBuilder sql = new StringBuilder(200);
                sql.append("SELECT * FROM agnTermine WHERE deleted='0' AND Tag=").append(JdbcLink.wrap((String)this.agenda.getActDate().toString(9))).append(" AND BeiWem=").append(JdbcLink.wrap((String)this.map.get(this.agenda.getActResource())));
                try {
                    try {
                        ResultSet res = stmOther.query(sql.toString());
                        while (res.next()) {
                            int von = res.getInt("Beginn");
                            int dauer = res.getInt("Dauer");
                            int bis = von + dauer;
                            int d = res.getInt("deleted");
                            String id = res.getString("ID");
                            Termin t = Termin.load(id);
                            if (t == null || t.state() < 3) {
                                if (d != 0) continue;
                                if (t == null || t.state() < 2) {
                                    t = new Termin(id, this.agenda.getActResource(), res.getString("Tag"), von, bis, res.getString("TerminTyp"), res.getString("TerminStatus"));
                                }
                                this.setTermin(t, res);
                                continue;
                            }
                            if (d != 0) {
                                t.delete();
                                continue;
                            }
                            int lasteditSeconds = res.getInt("lastedit");
                            int lasteditMinutes = lasteditSeconds / 60;
                            int my_lasteditMinutes = t.getLastedit();
                            if (my_lasteditMinutes >= lasteditMinutes) continue;
                            t.set(new String[]{"Tag", "Typ", "Status", "Beginn", "Dauer", "BeiWem", "lastedit"}, new String[]{res.getString("Tag"), res.getString("TerminTyp"), res.getString("TerminStatus"), Integer.toString(von), Integer.toString(dauer), this.agenda.getActResource(), Integer.toString(lasteditMinutes)});
                            this.setTermin(t, res);
                        }
                        res.close();
                        sql.setLength(0);
                        sql.append("SELECT * FROM AGNTERMINE WHERE deleted='0' AND Tag=").append(JdbcLink.wrap((String)this.agenda.getActDate().toString(9))).append(" AND Bereich=").append(JdbcLink.wrap((String)this.agenda.getActResource()));
                        res = stmMine.query(sql.toString());
                        PreparedStatement psInsert = this.sync.getConnection().prepareStatement("INSERT INTO agnTermine (Tag, Beginn, Dauer, BeiWem, PatID, Personalien, Grund, TerminTyp, TerminStatus , Angelegt, Lastedit, ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);");
                        PreparedStatement psUpdate = this.sync.getConnection().prepareStatement("UPDATE agnTermine SET Tag=?,Beginn=?,Dauer=?,BeiWem=?,PatID=?,Personalien=?,Grund=?,TerminTyp=?,TerminStatus=?,Angelegt=?,Lastedit=? WHERE ID=?");
                        while (res.next()) {
                            PreparedStatement ps;
                            int myLasteditMinutes = res.getInt("lastedit");
                            int myLasteditSeconds = myLasteditMinutes * 60;
                            int otherLastSeconds = stmOther.queryInt("SELECT lastedit FROM agnTermine WHERE ID='" + res.getString("ID") + "'");
                            int otherLastMinutes = otherLastSeconds / 60;
                            if (otherLastSeconds == -1) {
                                ps = psInsert;
                                ps.setInt(10, Integer.parseInt(Termin.createTimeStamp()));
                            } else {
                                if (myLasteditMinutes <= otherLastMinutes) continue;
                                ps = psUpdate;
                                ps.setInt(10, res.getInt("Angelegt"));
                            }
                            String mandant = this.map.get(res.getString("Bereich"));
                            if (mandant == null) continue;
                            ps.setString(1, res.getString("Tag"));
                            ps.setInt(2, res.getInt("Beginn"));
                            ps.setInt(3, res.getInt("Dauer"));
                            ps.setString(4, mandant);
                            String pers = res.getString("PatID");
                            Patient pat = Patient.load((String)pers);
                            int nr = 0;
                            if (pat.state() > 1) {
                                nr = Integer.parseInt(pat.getPatCode());
                                pers = pat.getLabel();
                            }
                            ps.setInt(5, nr);
                            ps.setString(6, pers);
                            ps.setString(7, res.getString("Grund"));
                            ps.setString(8, res.getString("TerminTyp"));
                            ps.setString(9, res.getString("TerminStatus"));
                            ps.setInt(11, myLasteditSeconds);
                            ps.setString(12, res.getString("ID"));
                            ps.execute();
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        this.sync.releaseStatement(stmOther);
                        PersistentObject.getConnection().releaseStatement(stmMine);
                        pingPause = false;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    this.sync.releaseStatement(stmOther);
                    PersistentObject.getConnection().releaseStatement(stmMine);
                    pingPause = false;
                    throw throwable;
                }
                this.sync.releaseStatement(stmOther);
                PersistentObject.getConnection().releaseStatement(stmMine);
                pingPause = false;
            }
        }
        this.lastSync = TimeTool.getTimeInSeconds();
        pingPause = false;
        ElexisEventDispatcher.reload(Termin.class);
    }

    private void setTermin(Termin t, ResultSet res) throws SQLException {
        t.set("Grund", res.getString("Grund"));
        String pers = res.getString("Personalien");
        String[] px = Termin.findID(pers);
        px[1] = px[1].replaceFirst("\\([mw]\\)", "");
        this.qPat.clear();
        List list = this.qPat.queryFields(new String[]{"Name", "Vorname", "Geburtsdatum"}, px, true);
        if (list == null || list.size() != 1) {
            t.set("Wer", pers);
        } else {
            t.set("Wer", ((PersistentObject)list.get(0)).getId());
        }
    }

    public static Hashtable<String, String> getBereichMapping() {
        Hashtable ret = StringTool.foldStrings((String)CoreHub.globalCfg.get("agenda/sync/mapping", null));
        if (ret == null) {
            ret = new Hashtable();
        }
        return ret;
    }

    public static void setBereichMapping(Hashtable<String, String> map) {
        CoreHub.globalCfg.set("agenda/sync/mapping", StringTool.flattenStrings(map));
    }
}

