/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.actions;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.acl.ACLContributor;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AgendaActions {
    private static LockRequestingRestrictedAction<Termin> delTerminAction;
    private static IAction terminStatusAction;

    public static void updateActions() {
        AgendaActions.getTerminStatusAction().setEnabled(CoreHub.acl.request(ACLContributor.USE_AGENDA));
        ((RestrictedAction)AgendaActions.getDelTerminAction()).reflectRight();
    }

    public static IAction getDelTerminAction() {
        if (delTerminAction == null) {
            AgendaActions.makeActions();
        }
        return delTerminAction;
    }

    public static IAction getTerminStatusAction() {
        if (terminStatusAction == null) {
            AgendaActions.makeActions();
        }
        return terminStatusAction;
    }

    private static void makeActions() {
        delTerminAction = new LockRequestingRestrictedAction<Termin>(ACLContributor.DELETE_APPOINTMENTS, Messages.AgendaActions_deleteDate){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.AgendaActions_deleteDate);
            }

            public Termin getTargetedObject() {
                return (Termin)ElexisEventDispatcher.getSelected(Termin.class);
            }

            public void doRun(Termin element) {
                element.delete();
                ElexisEventDispatcher.reload(Termin.class);
            }
        };
        terminStatusAction = new Action(Messages.AgendaActions_state, 4){
            Menu mine = null;
            Listener showListener = null;
            {
                this.setMenuCreator(new IMenuCreator(){

                    public void dispose() {
                        if (mine != null) {
                            this.removeShowListener();
                            mine.dispose();
                        }
                    }

                    public Menu getMenu(Control parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        this.addShowListener();
                        return mine;
                    }

                    public Menu getMenu(Menu parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        this.addShowListener();
                        return mine;
                    }

                    private void removeShowListener() {
                        if (mine != null && showListener != null) {
                            mine.removeListener(22, showListener);
                        }
                    }

                    private void addShowListener() {
                        if (mine != null) {
                            this.removeShowListener();
                            showListener = new Listener(){

                                public void handleEvent(Event event) {
                                    String actTerminStatus;
                                    Menu menu = (Menu)event.widget;
                                    Termin actTermin = (Termin)ElexisEventDispatcher.getSelected(Termin.class);
                                    if (actTermin != null && (actTerminStatus = actTermin.getStatus()) != null) {
                                        MenuItem[] menuItemArray = menu.getItems();
                                        int n = menuItemArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            MenuItem menuItem = menuItemArray[n2];
                                            menuItem.setSelection(StringUtils.equals((String)actTerminStatus, (String)menuItem.getText()));
                                            ++n2;
                                        }
                                    }
                                }
                            };
                            mine.addListener(22, showListener);
                        }
                    }
                });
            }

            void fillMenu() {
                String[] stringArray = Termin.TerminStatus;
                int n = Termin.TerminStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    MenuItem it = new MenuItem(this.mine, 32);
                    it.setText(t);
                    it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(final SelectionEvent e) {
                            final Termin act = (Termin)ElexisEventDispatcher.getSelected(Termin.class);
                            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)act, (ILockHandler)new ILockHandler(){

                                public void lockFailed() {
                                }

                                public void lockAcquired() {
                                    MenuItem it = (MenuItem)e.getSource();
                                    act.setStatus(it.getText());
                                    ElexisEventDispatcher.reload(Termin.class);
                                }
                            });
                        }
                    });
                    ++n2;
                }
            }
        };
    }
}

