/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.actions;

import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "ch.elexis.agenda";
    private static Activator plugin;
    public static final String IMG_HOME = "ch.elexis.agenda.home";
    public static final String IMG_RECURRING_DATE = "ch.elexis.agenda.series";
    private String actResource;
    private TimeTool actDate;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UiDesk.getImageRegistry().put(IMG_HOME, Activator.getImageDescriptor("icons/calendar_view_day.png"));
        UiDesk.getImageRegistry().put(IMG_RECURRING_DATE, Activator.getImageDescriptor("icons/arrow-repeat.png"));
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public String[] getResources() {
        return CoreHub.globalCfg.get("agenda/bereiche", Messages.TagesView_14).split(",");
    }

    public String getActResource() {
        if (this.actResource == null) {
            this.actResource = Activator.getDefault().getResources()[0];
        }
        return this.actResource;
    }

    public void setActResource(String resname) {
        this.actResource = resname;
        CoreHub.userCfg.set("agenda/bereich", resname);
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                BereichSelectionHandler.updateListeners();
            }
        });
    }

    public TimeTool getActDate() {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        return new TimeTool(this.actDate);
    }

    public void setActDate(String date) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.set(date);
    }

    public void setActDate(TimeTool date) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.set(date);
    }

    public TimeTool addDays(int day) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.addDays(day);
        return new TimeTool(this.actDate);
    }

    public void dispatchTermin(Termin termin) {
        Kontakt contact = null;
        if (termin.isRecurringDate()) {
            Termin rootTermin = Termin.load(termin.get("linkgroup"));
            if (rootTermin != null && rootTermin.exists()) {
                contact = rootTermin.getKontakt();
            }
        } else {
            contact = termin.getKontakt();
        }
        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)termin);
        if (contact != null) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)contact);
        }
    }
}

