/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.elexis.CDACHServicesClient;
import ch.docbox.elexis.CertificateConfigDialog;
import ch.docbox.elexis.Messages;
import ch.docbox.model.CdaMessage;
import ch.docbox.model.DocboxContact;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.docbox.ws.cdachservices.CDACHServices_Service;
import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.docbox.ws.client.WsClientConfig;
import ch.elexis.docbox.ws.client.WsClientUtil;
import ch.rgw.io.Settings;
import ch.swissmedicalsuite.HCardBrowser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class UserDocboxPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String oldSha1Password;
    private String oldLoginId;
    private StringFieldEditor loginIdFieldEditor;
    private StringFieldEditor passwordFieldEditor;
    private StringFieldEditor secretkeyFieldEditor;
    private StringFieldEditor proxyPortFieldEditor;
    private StringFieldEditor proxyHostFieldEditor;
    private DirectoryFieldEditor directoryFieldEditor;
    private DirectoryFieldEditor directoryhCardEditor;
    private Button buttonAgendaSettingsPerUser;
    private Combo agendaBereichCombo;
    private Button buttonGetAppointmentsEmergencyService;
    private Button buttonGetAppointmentsPharmaVisits;
    private Button buttonGetAppointmentsTerminvereinbarung;
    private Button buttonConfigureCert;
    private Button buttonUseHCard;
    private Button buttonUseProxy;
    private Button buttonClearDocboxInbox;
    private String[] bereiche;
    private static boolean showSha1SecretKey = true;
    protected static Log log = Log.get((String)"UserDocboxPreferences");
    public static final String ID = "ch.docbox.elexis.UserDocboxPreferences";
    public static final String USR_DEFDOCBOXPATHFILES = "docbox/pathfiles";
    public static final String USR_DEFDOCBOXPATHHCARDAPI = "docbox/pathhcardapi";
    public static final String USR_AGENDASETTINGSPERUSER = "docbox/agendasettingsperuser";
    public static final String USR_USEHCARD = "docbox/usefmhcard";
    public static final String USR_GETAPPOINTMENTSEMERGENCYSERVICE = "docbox/getappointmentsemergencyservice";
    public static final String USR_GETAPPOINTMENTSPHARMAVISITS = "docbox/getappointmentspharmavisits";
    public static final String USR_GETAPPOINTMENTSTERMINVEREINBARUNG = "docbox/getappointmentsterminvereinbarung";
    public static final String USR_APPOINTMENTSBEREICH = "docbox/getappointmentsbereich";
    public static final String USR_ISDOCBOXTEST = "docbox/isdocboxtest";
    public static final String USR_UPDATEDOCTORDIRECTORY = "docbox/updatedoctordirectory";
    public static final String USR_USEPROXY = "docbox/useproxy";
    public static final String USR_PROXYHOST = "docbox/proxyhost";
    public static final String USR_PROXYPORT = "docbox/proxyport";
    public boolean oldAppointmentsEmergencyService;
    public boolean oldAppointmentsPharmaVisits;
    public boolean oldAppointmentsTerminvereinbarung;
    public String oldAppointmentsBereich;
    public boolean oldIsDocboxTest;
    public boolean oldUseHCard;
    public boolean oldUseProxy;
    public String oldSecretKey;
    public String proxyPort;
    public String proxyHost;
    public String oldProxyPort;
    public String oldProxyHost;
    public static final String NOPASSWORD = "***NONE***";

    public static boolean isDocboxTest() {
        return UserDocboxPreferences.getDocboxLoginID(true) != null && UserDocboxPreferences.getDocboxLoginID(true).startsWith(WsClientConfig.TESTLOGINIDPREFIX);
    }

    public static String getSSOSignature(String ts) {
        String username = UserDocboxPreferences.getDocboxLoginID(false);
        String sha1Password = UserDocboxPreferences.getSha1DocboxPassword();
        String sha1SecretKey = UserDocboxPreferences.getSha1DocboxSecretKey();
        String message = String.valueOf(username) + ":" + ts + ":" + sha1Password;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(sha1SecretKey.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(message.getBytes("UTF-8"));
            byte[] base64 = Base64.encodeBase64((byte[])rawHmac);
            return new String(base64);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public UserDocboxPreferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.mandantCfg));
        this.setDescription(Messages.UserDocboxPreferences_Description);
        this.bereiche = Termin.TerminBereiche;
    }

    protected void createFieldEditors() {
        this.oldSha1Password = UserDocboxPreferences.getSha1DocboxPassword();
        this.oldLoginId = UserDocboxPreferences.getDocboxLoginID(true);
        this.oldAppointmentsEmergencyService = UserDocboxPreferences.isAppointmentsEmergencyService();
        this.oldAppointmentsPharmaVisits = UserDocboxPreferences.isAppointmentsPharmaVisits();
        this.oldAppointmentsTerminvereinbarung = UserDocboxPreferences.isAppointmentsTerminvereinbarung();
        this.oldAppointmentsBereich = UserDocboxPreferences.getAppointmentsBereich();
        this.oldUseHCard = UserDocboxPreferences.useHCard();
        this.oldUseProxy = UserDocboxPreferences.useProxy();
        this.oldProxyHost = UserDocboxPreferences.getProxyHost();
        this.oldProxyPort = UserDocboxPreferences.getProxyPort();
        this.oldSecretKey = UserDocboxPreferences.getSha1DocboxSecretKey();
        boolean enableForMandant = CoreHub.acl.request(AccessControlDefaults.ACL_USERS);
        this.loginIdFieldEditor = new StringFieldEditor("docbox/loginid", Messages.UserDocboxPreferences_LoginId, this.getFieldEditorParent());
        this.addField((FieldEditor)this.loginIdFieldEditor);
        this.loginIdFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.passwordFieldEditor = new StringFieldEditor("docbox/password", Messages.UserDocboxPreferences_Password, this.getFieldEditorParent());
        this.passwordFieldEditor.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
        this.passwordFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.addField((FieldEditor)this.passwordFieldEditor);
        if (showSha1SecretKey) {
            this.secretkeyFieldEditor = new StringFieldEditor("docbox/secretkey", Messages.UserDocboxPreferences_SecretKey, this.getFieldEditorParent());
            this.secretkeyFieldEditor.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
            this.secretkeyFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
            this.addField((FieldEditor)this.secretkeyFieldEditor);
        }
        this.buttonConfigureCert = new Button(this.getFieldEditorParent(), 8);
        this.buttonConfigureCert.setText("Zertifikat konfigurieren");
        this.buttonConfigureCert.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        this.buttonConfigureCert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateConfigDialog dlg = new CertificateConfigDialog(UserDocboxPreferences.this.getShell());
                dlg.open();
            }
        });
        if (WsClientUtil.isMedelexisCertAvailable()) {
            this.buttonConfigureCert.setEnabled(false);
        }
        this.buttonUseHCard = new Button(this.getFieldEditorParent(), 32);
        this.buttonUseHCard.setText(Messages.UserDocboxPreferences_UseHCard);
        this.buttonUseHCard.setSelection(UserDocboxPreferences.useHCard());
        this.buttonUseHCard.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        this.buttonUseHCard.setEnabled(enableForMandant);
        this.directoryhCardEditor = new DirectoryFieldEditor(USR_DEFDOCBOXPATHHCARDAPI, Messages.UserDocboxPreferences_PathHCardAPI, this.getFieldEditorParent());
        this.directoryhCardEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.addField((FieldEditor)this.directoryhCardEditor);
        this.buttonUseProxy = new Button(this.getFieldEditorParent(), 32);
        this.buttonUseProxy.setText(Messages.UserDocboxPreferences_UseProxy);
        this.buttonUseProxy.setSelection(UserDocboxPreferences.useProxy());
        this.buttonUseProxy.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        this.buttonUseProxy.setEnabled(enableForMandant);
        this.proxyHostFieldEditor = new StringFieldEditor(USR_PROXYHOST, Messages.UserDocboxPreferences_UseProxyHost, this.getFieldEditorParent());
        this.addField((FieldEditor)this.proxyHostFieldEditor);
        this.proxyHostFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        this.proxyPortFieldEditor = new StringFieldEditor(USR_PROXYPORT, Messages.UserDocboxPreferences_UseProxyPort, this.getFieldEditorParent());
        this.addField((FieldEditor)this.proxyPortFieldEditor);
        this.proxyPortFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Button docboxConnectionTestButton = new Button(this.getFieldEditorParent(), 8);
        docboxConnectionTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String sha1Password = UserDocboxPreferences.this.passwordFieldEditor.getStringValue().equals(UserDocboxPreferences.this.oldSha1Password) ? UserDocboxPreferences.this.oldSha1Password : CDACHServicesClient.getSHA1(UserDocboxPreferences.this.passwordFieldEditor.getStringValue());
                CoreHub.mandantCfg.set("docbox/loginid", UserDocboxPreferences.this.loginIdFieldEditor.getStringValue());
                CoreHub.mandantCfg.set("docbox/password", sha1Password);
                if (showSha1SecretKey && UserDocboxPreferences.this.secretkeyFieldEditor != null) {
                    CoreHub.mandantCfg.set("docbox/secretkey", UserDocboxPreferences.this.secretkeyFieldEditor.getStringValue());
                }
                UserDocboxPreferences.setUseHCard(UserDocboxPreferences.this.buttonUseHCard.getSelection());
                UserDocboxPreferences.setUseProxy(UserDocboxPreferences.this.buttonUseProxy.getSelection());
                UserDocboxPreferences.setProxyHost(UserDocboxPreferences.this.proxyHostFieldEditor.getStringValue());
                UserDocboxPreferences.setProxyPort(UserDocboxPreferences.this.proxyPortFieldEditor.getStringValue());
                if (UserDocboxPreferences.getSha1DocboxSecretKey() == null || "".equals(UserDocboxPreferences.getSha1DocboxSecretKey())) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
                    box.setText(Messages.UserDocboxPreferences_NoSecretKeyTitle);
                    box.setMessage(Messages.UserDocboxPreferences_NoSecretKey);
                    box.open();
                } else {
                    Holder message = new Holder();
                    boolean isOk = UserDocboxPreferences.this.performConnectionTest((Holder<String>)message);
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), isOk ? 16 : 1);
                    box.setText(Messages.UserDocboxPreferences_ConnectionTestWithDocbox);
                    box.setMessage((String)message.value);
                    box.open();
                }
            }
        });
        docboxConnectionTestButton.setText(Messages.UserDocboxPreferences_ConnectionTest);
        docboxConnectionTestButton.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.directoryFieldEditor = new DirectoryFieldEditor(USR_DEFDOCBOXPATHFILES, Messages.UserDocboxPreferences_PathFiles, this.getFieldEditorParent());
        this.addField((FieldEditor)this.directoryFieldEditor);
        this.directoryFieldEditor.setEnabled(enableForMandant, this.getFieldEditorParent());
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        if (UserDocboxPreferences.hasAgendaPlugin() && enableForMandant) {
            this.buttonAgendaSettingsPerUser = new Button(this.getFieldEditorParent(), 32);
            this.buttonAgendaSettingsPerUser.setText(Messages.UserDocboxPreferences_AgendaSettingsPerUser);
            this.buttonAgendaSettingsPerUser.setSelection(UserDocboxPreferences.getAgendaSettingsPerUser());
            this.buttonAgendaSettingsPerUser.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        }
        if (UserDocboxPreferences.hasAgendaPlugin()) {
            boolean enabled = UserDocboxPreferences.getAgendaSettingsPerUser() || enableForMandant;
            Label textLabel = new Label(this.getFieldEditorParent(), 0);
            textLabel.setText(Messages.UserDocboxPreferences_AgendaBerich);
            textLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
            this.agendaBereichCombo = new Combo(this.getFieldEditorParent(), 12);
            this.agendaBereichCombo.setItems(this.bereiche);
            this.agendaBereichCombo.select(this.getAgendaIndex());
            this.agendaBereichCombo.setEnabled(enabled);
            textLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsEmergencyService = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsEmergencyService.setText(Messages.UserDocboxPreferences_GetAppointmentsEmergencyService);
            this.buttonGetAppointmentsEmergencyService.setSelection(UserDocboxPreferences.isAppointmentsEmergencyService());
            this.buttonGetAppointmentsEmergencyService.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsEmergencyService.setEnabled(enabled);
            this.buttonGetAppointmentsPharmaVisits = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsPharmaVisits.setText(Messages.UserDocboxPreferences_GetAppointmentsPharmaVisits);
            this.buttonGetAppointmentsPharmaVisits.setSelection(UserDocboxPreferences.isAppointmentsPharmaVisits());
            this.buttonGetAppointmentsPharmaVisits.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsPharmaVisits.setEnabled(enabled);
            this.buttonGetAppointmentsTerminvereinbarung = new Button(this.getFieldEditorParent(), 32);
            this.buttonGetAppointmentsTerminvereinbarung.setText(Messages.UserDocboxPreferences_GetAppointmentsTerminvereinbarungen);
            this.buttonGetAppointmentsTerminvereinbarung.setSelection(UserDocboxPreferences.isAppointmentsTerminvereinbarung());
            this.buttonGetAppointmentsTerminvereinbarung.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
            this.buttonGetAppointmentsTerminvereinbarung.setEnabled(enabled);
        }
        if (enableForMandant) {
            new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            this.buttonClearDocboxInbox = new Button(this.getFieldEditorParent(), 8);
            this.buttonClearDocboxInbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 200);
                    box.setText(Messages.UserDocboxPreferences_ClearDocboxInbox);
                    box.setMessage(Messages.UserDocboxPreferences_ClearDocboxInboxConfirm);
                    if (box.open() == 64) {
                        CdaMessage.deleteCdaMessages((Anwender)CoreHub.actMandant);
                    }
                }
            });
            this.buttonClearDocboxInbox.setText(Messages.UserDocboxPreferences_ClearDocboxInbox);
            this.buttonClearDocboxInbox.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        }
        Button btnConvertDocboxIds = new Button(this.getFieldEditorParent(), 8);
        btnConvertDocboxIds.setText(Messages.UserDocboxPreferences_ConvertDocboxIds);
        btnConvertDocboxIds.setToolTipText(Messages.UserDocboxPreferences_ConvertDocboxIds_Tooltip);
        btnConvertDocboxIds.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)false, (int)1, (boolean)false));
        btnConvertDocboxIds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IProgressService progService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progService.runInUI((IRunnableContext)progService, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            DocboxContact.importDocboxIdsFromKontaktExtinfo(monitor);
                        }
                    }, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public int getAgendaIndex() {
        String agendaBereich = UserDocboxPreferences.getAppointmentsBereich();
        if (agendaBereich != null && !"".equals(agendaBereich)) {
            int i = 0;
            while (this.bereiche != null && i < this.bereiche.length) {
                if (this.bereiche[i].equals(agendaBereich)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean hasAgendaPlugin() {
        Termin termin = Termin.load((String)"1");
        return termin != null && termin.exists();
    }

    public static String getDocboxLoginID(boolean prefixed) {
        String loginId = CoreHub.mandantCfg.get("docbox/loginid", "");
        if (!prefixed && loginId.startsWith(WsClientConfig.TESTLOGINIDPREFIX)) {
            loginId = loginId.substring(WsClientConfig.TESTLOGINIDPREFIX.length());
        }
        return loginId;
    }

    public static String getSha1DocboxPassword() {
        String sha1Password = CoreHub.mandantCfg.get("docbox/password", "");
        return sha1Password;
    }

    public static String getSha1DocboxSecretKey() {
        String docboxSha1SecretKey = "";
        showSha1SecretKey = false;
        if (UserDocboxPreferences.isDocboxTest()) {
            return CDACHServicesClient.getSHA1("docboxtest");
        }
        URL baseUrl = CDACHServices_Service.class.getResource("");
        try {
            URL url = new URL(baseUrl + "/product.key");
            InputStream in = url.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            docboxSha1SecretKey = bufferedReader.readLine();
        }
        catch (Exception e) {
            docboxSha1SecretKey = CDACHServicesClient.getSHA1(CoreHub.mandantCfg.get("docbox/secretkey", ""));
            showSha1SecretKey = true;
        }
        return docboxSha1SecretKey;
    }

    public static String getPathFiles() {
        return CoreHub.mandantCfg.get(USR_DEFDOCBOXPATHFILES, "");
    }

    public static String getPathHCardAPI() {
        return CoreHub.mandantCfg.get(USR_DEFDOCBOXPATHHCARDAPI, "");
    }

    public static boolean getAgendaSettingsPerUser() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return false;
        }
        boolean value = CoreHub.mandantCfg.get(USR_AGENDASETTINGSPERUSER, "0").equals("1");
        return value;
    }

    private static String getHost() {
        String host = "";
        host = UserDocboxPreferences.useHCard() ? (UserDocboxPreferences.isDocboxTest() ? "swissmedicalsuite.test.docbox.ch" : "swissmedicalsuite.docbox.ch") : (UserDocboxPreferences.isDocboxTest() ? "www.test.docbox.ch" : "www.docbox.ch");
        return host;
    }

    public static String getDocboxBrowserHome() {
        return "http://www.docbox.ch";
    }

    public static String getDocboxBrowserUrl() {
        String test = UserDocboxPreferences.isDocboxTest() ? "test" : "";
        String host = UserDocboxPreferences.getHost();
        String cgibin = "cgi-bin";
        return "https://" + host + "/" + cgibin + "/WebObjects/docbox" + test + ".woa/wa/default";
    }

    public static String getDocboxServiceUrl() {
        String test = UserDocboxPreferences.isDocboxTest() ? "test" : "";
        String host = UserDocboxPreferences.getHost();
        String cgibin = "cgi-bin";
        return "https://" + host + "/" + cgibin + "/WebObjects/docboxservice" + test + ".woa/ws/CDACHServices";
    }

    private void setAgendaSettingsPerUser(boolean value) {
        CoreHub.mandantCfg.set(USR_AGENDASETTINGSPERUSER, value ? "1" : "0");
    }

    public boolean performOk() {
        super.performOk();
        String sha1Password = this.passwordFieldEditor.getStringValue().equals(this.oldSha1Password) ? this.oldSha1Password : CDACHServicesClient.getSHA1(this.passwordFieldEditor.getStringValue());
        CoreHub.mandantCfg.set("docbox/loginid", this.loginIdFieldEditor.getStringValue());
        CoreHub.mandantCfg.set("docbox/password", sha1Password);
        CoreHub.mandantCfg.set(USR_DEFDOCBOXPATHFILES, this.directoryFieldEditor.getStringValue());
        CoreHub.mandantCfg.set(USR_DEFDOCBOXPATHHCARDAPI, this.directoryhCardEditor.getStringValue());
        if (showSha1SecretKey) {
            CoreHub.mandantCfg.set("docbox/secretkey", this.secretkeyFieldEditor.getStringValue());
        }
        if (this.buttonAgendaSettingsPerUser != null) {
            this.setAgendaSettingsPerUser(this.buttonAgendaSettingsPerUser.getSelection());
        }
        if (this.buttonUseHCard.getSelection() != this.oldUseHCard) {
            UserDocboxPreferences.setUseHCard(this.buttonUseHCard.getSelection());
        }
        if (this.buttonUseProxy.getSelection() != this.oldUseProxy) {
            UserDocboxPreferences.setUseProxy(this.buttonUseProxy.getSelection());
        }
        UserDocboxPreferences.setProxyHost(this.proxyHostFieldEditor.getStringValue());
        UserDocboxPreferences.setProxyPort(this.proxyPortFieldEditor.getStringValue());
        if (UserDocboxPreferences.hasAgendaPlugin()) {
            if (!this.oldAppointmentsBereich.equals(this.getSelectedAgendaBereich())) {
                UserDocboxPreferences.setAppointmentsBereich(this.getSelectedAgendaBereich());
            }
            if (this.buttonGetAppointmentsEmergencyService.getSelection() != this.oldAppointmentsEmergencyService) {
                UserDocboxPreferences.setAppointmentsEmergencyService(this.buttonGetAppointmentsEmergencyService.getSelection());
            }
            if (this.buttonGetAppointmentsPharmaVisits.getSelection() != this.oldAppointmentsPharmaVisits) {
                UserDocboxPreferences.setAppointmentsPharmaVisits(this.buttonGetAppointmentsPharmaVisits.getSelection());
            }
            if (this.buttonGetAppointmentsTerminvereinbarung.getSelection() != this.oldAppointmentsTerminvereinbarung) {
                UserDocboxPreferences.setAppointmentsTerminvereinbarung(this.buttonGetAppointmentsTerminvereinbarung.getSelection());
            }
        }
        return true;
    }

    private String getSelectedAgendaBereich() {
        String bereich = "";
        if (this.agendaBereichCombo.getSelectionIndex() != -1) {
            return this.bereiche[this.agendaBereichCombo.getSelectionIndex()];
        }
        return bereich;
    }

    public boolean performCancel() {
        super.performCancel();
        CoreHub.mandantCfg.set("docbox/loginid", this.oldLoginId);
        CoreHub.mandantCfg.set("docbox/password", this.oldSha1Password);
        CoreHub.mandantCfg.set("docbox/secretkey", this.oldSecretKey);
        UserDocboxPreferences.setUseHCard(this.oldUseHCard);
        UserDocboxPreferences.setUseProxy(this.oldUseProxy);
        UserDocboxPreferences.setProxyHost(this.oldProxyHost);
        UserDocboxPreferences.setProxyPort(this.oldProxyPort);
        return true;
    }

    protected void performDefaults() {
        this.initialize();
    }

    public boolean performConnectionTest(Holder<String> message) {
        Holder _checkAccess_success = new Holder();
        try {
            CDACHServices port = UserDocboxPreferences.getPort();
            port.checkAccess((Holder<Boolean>)_checkAccess_success, message);
        }
        catch (Exception e) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            message.value = e.getMessage();
            return false;
        }
        catch (NoClassDefFoundError e) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            message.value = String.valueOf(message.value) + e.getMessage();
            return false;
        }
        catch (ExceptionInInitializerError e2) {
            message.value = "Verbindungsproblem mit docbox";
            message.value = String.valueOf(message.value) + "\n";
            return false;
        }
        return (Boolean)_checkAccess_success.value;
    }

    public static boolean hasValidDocboxCredentials() {
        return (!"".equals(UserDocboxPreferences.getDocboxLoginID(true)) && !"".equals(UserDocboxPreferences.getSha1DocboxPassword()) || UserDocboxPreferences.useHCard()) && !"".equals(UserDocboxPreferences.getSha1DocboxSecretKey());
    }

    public void init(IWorkbench workbench) {
    }

    public static Settings getSettingsForUser() {
        if (CoreHub.actUser.getId().equals(CoreHub.actMandant.getId())) {
            return CoreHub.mandantCfg;
        }
        Settings settings = UserDocboxPreferences.getAgendaSettingsPerUser() ? CoreHub.userCfg : CoreHub.mandantCfg;
        return settings;
    }

    public static boolean isAppointmentsEmergencyService() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().get(USR_GETAPPOINTMENTSEMERGENCYSERVICE, "0").equals("1");
    }

    public static void setAppointmentsEmergencyService(boolean appointmentsEmergencyService) {
        UserDocboxPreferences.getSettingsForUser().set(USR_GETAPPOINTMENTSEMERGENCYSERVICE, appointmentsEmergencyService ? "1" : "0");
    }

    public static boolean isAppointmentsPharmaVisits() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().get(USR_GETAPPOINTMENTSPHARMAVISITS, "0").equals("1");
    }

    public static void setAppointmentsPharmaVisits(boolean appointmentsPharmaVisits) {
        UserDocboxPreferences.getSettingsForUser().set(USR_GETAPPOINTMENTSPHARMAVISITS, appointmentsPharmaVisits ? "1" : "0");
    }

    public static boolean isAppointmentsTerminvereinbarung() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return false;
        }
        return UserDocboxPreferences.getSettingsForUser().get(USR_GETAPPOINTMENTSTERMINVEREINBARUNG, "0").equals("1");
    }

    public static void setAppointmentsTerminvereinbarung(boolean appointmentsTerminvereinbarung) {
        UserDocboxPreferences.getSettingsForUser().set(USR_GETAPPOINTMENTSTERMINVEREINBARUNG, appointmentsTerminvereinbarung ? "1" : "0");
    }

    public static String getAppointmentsBereich() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return "";
        }
        return UserDocboxPreferences.getSettingsForUser().get(USR_APPOINTMENTSBEREICH, "");
    }

    public static void setAppointmentsBereich(String appointmentsBereich) {
        UserDocboxPreferences.getSettingsForUser().set(USR_APPOINTMENTSBEREICH, appointmentsBereich);
    }

    public static boolean useHCard() {
        return CoreHub.mandantCfg.get(USR_USEHCARD, "0").equals("1");
    }

    public static void setUseHCard(boolean useHCard) {
        CoreHub.mandantCfg.set(USR_USEHCARD, useHCard ? "1" : "0");
    }

    public static boolean useProxy() {
        return CoreHub.mandantCfg.get(USR_USEPROXY, "0").equals("1");
    }

    public static void setUseProxy(boolean useHCard) {
        CoreHub.mandantCfg.set(USR_USEPROXY, useHCard ? "1" : "0");
    }

    public static synchronized CDACHServices getPort() {
        System.setProperty("jna.library.path", UserDocboxPreferences.getPathHCardAPI());
        if (UserDocboxPreferences.useProxy()) {
            System.setProperty("https.proxyHost", UserDocboxPreferences.getProxyHost());
            System.setProperty("https.proxyPort", UserDocboxPreferences.getProxyPort());
        }
        CDACHServices_Service serviceClient = new CDACHServices_Service();
        if (UserDocboxPreferences.useHCard()) {
            new HCardBrowser(UserDocboxPreferences.getDocboxLoginID(false), null).setProxyPort();
        }
        WsClientUtil.addWsSecurityAndHttpConfigWithClientCert((Service)serviceClient, (String)(String.valueOf(WsClientConfig.getSecretkey()) + WsClientConfig.getUsername()), (String)WsClientConfig.getPassword(), (String)WsClientConfig.getP12Path(), null, (String)WsClientConfig.getP12Password(), null);
        CDACHServices port = serviceClient.getCDACHServices();
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", UserDocboxPreferences.getDocboxServiceUrl());
        return port;
    }

    public static boolean downloadAppointments() {
        return UserDocboxPreferences.getAppointmentsBereich() != null && !"".equals(UserDocboxPreferences.getAppointmentsBereich()) && (UserDocboxPreferences.isAppointmentsPharmaVisits() || UserDocboxPreferences.isAppointmentsEmergencyService() || UserDocboxPreferences.isAppointmentsTerminvereinbarung());
    }

    public static String getProxyHost() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return "";
        }
        return CoreHub.mandantCfg.get(USR_PROXYHOST, "");
    }

    public static void setProxyHost(String proxyHost) {
        CoreHub.mandantCfg.set(USR_PROXYHOST, proxyHost);
    }

    public static String getProxyPort() {
        if (CoreHub.actUser == null || CoreHub.mandantCfg == null) {
            return "";
        }
        return CoreHub.mandantCfg.get(USR_PROXYPORT, "");
    }

    public static void setProxyPort(String proxyPort) {
        CoreHub.mandantCfg.set(USR_PROXYPORT, proxyPort);
    }
}

