/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.elexis.UserDocboxPreferences;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Anwender;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.part.ViewPart;

public class DocboxView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "ch.docbox.elexis.DocboxView";
    private Browser browser;
    ElexisUiEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            DocboxView.this.userChanged();
        }
    };

    private String getDoboxLoginUrl() {
        return UserDocboxPreferences.getDocboxBrowserUrl();
    }

    public void createPartControl(Composite parent) {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_user});
        this.browser = new Browser(parent, 8);
        this.setHome();
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_user});
        super.dispose();
    }

    void userChanged() {
        this.setHome();
    }

    public void setHome() {
        if (CoreHub.actUser != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("MainWelcome"));
        } else {
            this.browser.setUrl(UserDocboxPreferences.getDocboxBrowserHome());
        }
    }

    public void setHospitalReferral() {
        if (CoreHub.actUser != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("HospitalApplicationsOverview"));
        }
    }

    public void setMyPatient() {
        if (CoreHub.actUser != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("MyPatient"));
        }
    }

    public void setTerminvereinbarung() {
        if (CoreHub.actUser != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            this.browser.setUrl(String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("AppBookingWizzard"));
        }
    }

    public void setAppointment(String termin) {
        if (CoreHub.actUser != null && UserDocboxPreferences.hasValidDocboxCredentials()) {
            String url = String.valueOf(this.getDoboxLoginUrl()) + this.getSSOLoginParams("DocCalendar");
            if (termin != null) {
                try {
                    url = String.valueOf(url) + "&id=" + URLEncoder.encode(termin, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.browser.setUrl(url);
        }
    }

    private String getSSOLoginParams(String page) {
        String ts = "" + System.currentTimeMillis() / 1000L;
        String username = UserDocboxPreferences.getDocboxLoginID(false);
        String signature = UserDocboxPreferences.getSSOSignature(ts);
        try {
            return "?ts=" + ts + "&loginId=" + URLEncoder.encode(username, "UTF-8") + "&sig=" + URLEncoder.encode(signature, "UTF-8") + "&page=" + URLEncoder.encode(page, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void setFocus() {
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void doSaveAs() {
    }
}

