/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.cdach.CdaChXPath;
import ch.docbox.elexis.Messages;
import ch.docbox.model.CdaMessage;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DocboxDocumentsView
extends ViewPart
implements ISaveablePart2,
IActivationListener,
Heartbeat.HeartListener {
    public static final String ID = "chdocbox.elexis.DocboxDocumentsView";
    private TableViewer tableViewer;
    private Table table;
    private Font boldFont;
    private int sortColumn = 0;
    private boolean sortReverse = false;
    public CdaMessage selectedCdaMessage;
    private final ElexisEventListenerImpl reloadListener = new ElexisUiEventListenerImpl(CdaMessage.class, 8){

        public void runInUi(ElexisEvent ev) {
            if (!DocboxDocumentsView.this.tableViewer.getControl().isDisposed()) {
                log.log("reloadListener refresh", 5);
                DocboxDocumentsView.this.tableViewer.refresh(true);
            }
        }
    };
    private final ElexisEventListenerImpl updateListener = new ElexisUiEventListenerImpl(CdaMessage.class, 4){

        public void runInUi(ElexisEvent ev) {
            if (!DocboxDocumentsView.this.tableViewer.getControl().isDisposed()) {
                log.log("updateListener refresh", 5);
                DocboxDocumentsView.this.tableViewer.refresh(true);
            }
        }
    };
    private final ElexisUiEventListenerImpl patientSelectionListener = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            CdaMessage cdaMessage;
            ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj != null && !(cdaMessage = (CdaMessage)((Object)obj)).isEqualsPatient((Patient)ev.getObject())) {
                DocboxDocumentsView.this.tableViewer.setSelection(null);
            }
        }
    };
    ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            DocboxDocumentsView.this.userChanged();
        }
    };
    private Action actionOpenAttachments;
    private Action actionDeleteDocument;
    private Action actionShowCdaDocument;
    private Action actionCreatePatient;
    protected static Log log = Log.get((String)"DocboxDocumentsView");

    public DocboxDocumentsView() {
        CdaMessage.load("1");
    }

    private String[] getColumnLabels() {
        String[] columnLabels = new String[]{Messages.DocboxDocumentsView_DateSent, Messages.DocboxDocumentsView_Title, Messages.DocboxDocumentsView_Sender, Messages.DocboxDocumentsView_Patient, Messages.DocboxDocumentsView_Attachments};
        return columnLabels;
    }

    private int[] getColumnWidth() {
        int[] columnWidth = new int[]{80, 150, 200, 200, 500};
        return columnWidth;
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), fd.getHeight(), fd.getStyle() | 1);
        return font;
    }

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66308);
        String[] colLabels = this.getColumnLabels();
        int[] columnWidth = this.getColumnWidth();
        SortListener sortListener = new SortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.table, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.boldFont = this.createBoldFont(this.table.getFont());
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setSorter((ViewerSorter)new Sorter());
        this.tableViewer.setUseHashlookup(true);
        Transfer[] transferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.tableViewer.addDragSupport(1, transferTypes, new DragSourceListener(){
            private CdaMessage cdaMessage;

            public void dragStart(DragSourceEvent event) {
                event.doit = true;
                event.detail = 2;
                log.log("dragStart", 5);
            }

            public void dragSetData(DragSourceEvent event) {
                ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    this.cdaMessage = (CdaMessage)((Object)obj);
                    String[] files = this.cdaMessage.getFiles();
                    int i = 0;
                    while (i < files.length) {
                        files[i] = this.cdaMessage.getPath(files[i]);
                        log.log("dragSetData " + files[i], 5);
                        ++i;
                    }
                    event.data = files;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                log.log("dragFinished", 5);
                if (event.detail == 1) {
                    this.cdaMessage.setAssignedToOmnivore();
                }
            }
        });
        this.selectionEvent((PersistentObject)CoreHub.actUser);
        this.tableViewer.setInput((Object)this.getViewSite());
        this.actionOpenAttachments = new Action(Messages.DocboxDocumentsView_Action_AttachmentsOpen){

            public void run() {
                ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CdaMessage cdaMessage = (CdaMessage)((Object)obj);
                cdaMessage.execute();
            }
        };
        this.actionShowCdaDocument = new Action(Messages.DocboxDocumentsView_Action_ShowCdaDocument){

            public void run() {
                ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CdaMessage cdaMessage = (CdaMessage)((Object)obj);
                TextTransfer textTransfer = TextTransfer.getInstance();
                Clipboard cb = new Clipboard(UiDesk.getDisplay());
                cb.setContents(new Object[]{cdaMessage.getCda()}, new Transfer[]{textTransfer});
            }
        };
        this.actionDeleteDocument = new Action(Messages.DocboxDocumentsView_Action_Delete){

            public void run() {
                ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    CdaMessage cdaMessage = (CdaMessage)((Object)obj);
                    MessageBox messageBox = new MessageBox(UiDesk.getDisplay().getActiveShell(), 296);
                    messageBox.setText(Messages.DocboxDocumentsView_Action_Delete);
                    messageBox.setMessage(String.format(Messages.DocboxDocumentsView_Action_DeleteConfirmMsg, cdaMessage.getTitle()));
                    if (messageBox.open() == 32) {
                        cdaMessage.deleteDocs();
                        DocboxDocumentsView.this.tableViewer.refresh();
                    }
                }
            }
        };
        this.actionCreatePatient = new Action(Messages.DocboxDocumentsView_Action_CreatePatient){

            public void run() {
                ISelection selection = DocboxDocumentsView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    CdaMessage cdaMessage = (CdaMessage)((Object)obj);
                    CdaChXPath xpath = new CdaChXPath();
                    String name = cdaMessage.getCda();
                    if (name != null) {
                        xpath.setPatientDocument(cdaMessage.getCda());
                        String family = xpath.getPatientLastName();
                        String given = xpath.getPatientFirstName();
                        String streetAdressLine = xpath.getPatientStreet();
                        String plz = xpath.getPatientPlz();
                        String city = xpath.getPatientCity();
                        Patient p = new Patient(family, given, "", "");
                        p.set("Name", family);
                        p.set("Vorname", given);
                        p.set("Strasse", streetAdressLine);
                        p.set("Plz", plz);
                        p.set("Ort", city);
                        p.set("E-Mail", xpath.getPatientEmail());
                        if ("M".equals(xpath.getPatientGender())) {
                            p.set("Geschlecht", "m");
                        }
                        if ("F".equals(xpath.getPatientGender())) {
                            p.set("Geschlecht", "w");
                        }
                        p.set("Telefon1", xpath.getPatientHomePhone());
                        p.set("NatelNr", xpath.getPatientMobile());
                        p.set("Telefon2", xpath.getPatientOfficePhone());
                        p.set("Geburtsdatum", xpath.getPatientDateOfBirth());
                        String ahv = xpath.getPatientAhv13();
                        if (ahv != null && !"".equals(ahv)) {
                            p.addXid("www.ahv.ch/xid", xpath.getPatientAhv13(), true);
                        }
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)p);
                        ElexisEventDispatcher.reload(Patient.class);
                    }
                }
            }
        };
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DocboxDocumentsView.this.actionOpenAttachments);
                manager.add((IAction)DocboxDocumentsView.this.actionDeleteDocument);
                manager.add((IAction)DocboxDocumentsView.this.actionShowCdaDocument);
                manager.add((IAction)DocboxDocumentsView.this.actionCreatePatient);
            }
        });
        this.tableViewer.getControl().setMenu(mgr.createContextMenu(this.tableViewer.getControl()));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocboxDocumentsView.this.actionOpenAttachments.run();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null && !sel.isEmpty() && (object = sel.getFirstElement()) instanceof CdaMessage) {
                    CdaMessage cdaMessage = (CdaMessage)((Object)object);
                    cdaMessage.setRead();
                    CdaChXPath cdaChXPath = new CdaChXPath();
                    String cda = cdaMessage.getCda();
                    if (cda != null) {
                        Patient elexisPatient;
                        String patId;
                        cdaChXPath.setPatientDocument(cda);
                        String lastName = cdaChXPath.getPatientLastName();
                        String firstName = cdaChXPath.getPatientFirstName();
                        String geburtsdatum = cdaChXPath.getPatientDateOfBirth();
                        if (cdaChXPath.getPatientNumber() != null && (patId = new Query(Patient.class).findSingle("PatientNr", "=", cdaChXPath.getPatientNumber())) != null && (elexisPatient = Patient.load((String)patId)) != null && elexisPatient.getName().equals(lastName) && elexisPatient.getVorname().equals(firstName)) {
                            log.log("selecting patient by id with " + lastName + ", " + firstName, 5);
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)elexisPatient);
                            return;
                        }
                        if (KontaktMatcher.findPerson((String)lastName, (String)firstName, (String)geburtsdatum, null, null, null, null, null, (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL) != null) {
                            log.log("selecting patient by demographics " + lastName + ", " + firstName, 5);
                            Patient elexisPatient2 = KontaktMatcher.findPatient((String)lastName, (String)firstName, (String)geburtsdatum, null, null, null, null, null, (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL);
                            if (elexisPatient2 != null) {
                                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)elexisPatient2);
                            }
                        }
                    }
                    DocboxDocumentsView.this.tableViewer.refresh();
                }
            }
        });
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    void userChanged() {
        this.tableViewer.refresh();
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void doSaveAs() {
    }

    public void selectionEvent(PersistentObject obj) {
        if (obj instanceof CdaMessage) {
            CdaMessage cdaMessage = (CdaMessage)obj;
            cdaMessage.setRead();
            this.tableViewer.refresh();
        } else if (obj instanceof Anwender) {
            this.tableViewer.refresh();
        }
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.reloadListener, this.updateListener, this.patientSelectionListener});
            this.heartbeat();
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.reloadListener, this.updateListener, this.patientSelectionListener});
        }
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
        super.dispose();
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void objectChanged(PersistentObject obj) {
        if (obj instanceof CdaMessage) {
            this.tableViewer.refresh();
        }
    }

    public void objectCreated(PersistentObject obj) {
        if (obj instanceof CdaMessage) {
            this.tableViewer.refresh();
        }
    }

    public void objectDeleted(PersistentObject obj) {
        if (obj instanceof CdaMessage) {
            this.tableViewer.refresh();
        }
    }

    public void heartbeat() {
        this.reloadListener.catchElexisEvent(new ElexisEvent(null, CdaMessage.class, 8));
        this.updateListener.catchElexisEvent(new ElexisEvent(null, CdaMessage.class, 4));
    }

    class SortListener
    extends SelectionAdapter {
        SortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == DocboxDocumentsView.this.sortColumn) {
                    DocboxDocumentsView.this.sortReverse = !DocboxDocumentsView.this.sortReverse;
                } else {
                    DocboxDocumentsView.this.sortReverse = false;
                    DocboxDocumentsView.this.sortColumn = colNo;
                }
                DocboxDocumentsView.this.tableViewer.refresh();
            }
        }
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CdaMessage && e2 instanceof CdaMessage) {
                CdaMessage d1 = (CdaMessage)((Object)e1);
                CdaMessage d2 = (CdaMessage)((Object)e2);
                String c1 = "";
                String c2 = "";
                switch (DocboxDocumentsView.this.sortColumn) {
                    case 0: {
                        c1 = d1.getCreationDate();
                        c2 = d2.getCreationDate();
                        break;
                    }
                    case 1: {
                        c1 = d1.getTitle();
                        c2 = d2.getTitle();
                        break;
                    }
                    case 2: {
                        c1 = d1.getSender();
                        c2 = d2.getSender();
                        break;
                    }
                    case 3: {
                        c1 = d1.getPatient();
                        c2 = d2.getPatient();
                        break;
                    }
                    case 4: {
                        c1 = d1.getFilesListing();
                        c2 = d2.getFilesListing();
                    }
                }
                if (DocboxDocumentsView.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CdaMessage.getCdaMessages();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            CdaMessage cdaMessage = (CdaMessage)((Object)obj);
            switch (index) {
                case 0: {
                    return cdaMessage.getDate();
                }
                case 1: {
                    return cdaMessage.getTitle();
                }
                case 2: {
                    return cdaMessage.getSender();
                }
                case 3: {
                    return cdaMessage.getPatient();
                }
                case 4: {
                    return cdaMessage.getFilesListing();
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            CdaMessage cdaMessage;
            Font font = null;
            if (element instanceof CdaMessage && (cdaMessage = (CdaMessage)((Object)element)).isUnread()) {
                font = DocboxDocumentsView.this.boldFont;
            }
            return font;
        }
    }
}

