/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDACHServicesClient {
    private static Logger log = LoggerFactory.getLogger(CDACHServicesClient.class);
    public static final QName SERVICE_NAME = new QName("http://ws.docbox.ch/CDACHServices/", "CDACHServices");
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String toHex(byte[] v) {
        String out = "";
        int i = 0;
        while (i < v.length) {
            out = String.valueOf(out) + hex[v[i] >> 4 & 0xF] + hex[v[i] & 0xF];
            ++i;
        }
        return out;
    }

    public static String getSHA1(String password) {
        if (password == null || "".equals(password)) {
            return "";
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            md.update(password.getBytes("UTF-8"));
            byte[] digest = md.digest();
            return CDACHServicesClient.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error in getSHA1, returning empty string", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error in getSHA1, returning empty string", (Throwable)e);
        }
        return "";
    }
}

