/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.Collections;
import java.util.List;

public class ValidationRuleBuilder
extends RuleTypeBuilder<ValidationRuleBuilder, Rule<?>> {
    protected ValidationRuleBuilder() {
    }

    private ValidationRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Version ... versions) {
        super(rules, versions);
    }

    public final List<RuleBinding<? extends Rule<?>>> initialize() {
        if (this.getRules().isEmpty()) {
            this.configure();
        }
        return Collections.unmodifiableList(this.getRules());
    }

    protected void configure() {
    }

    public final ValidationRuleBuilder forVersion(Version ... version) {
        return new ValidationRuleBuilder(this.getRules(), version);
    }

    public final ValidationRuleBuilder forVersion(String ... version) {
        Version[] versions = new Version[version.length];
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = Version.versionOf(version[i]);
        }
        return new ValidationRuleBuilder(this.getRules(), versions);
    }

    public final VersionExpressionBuilder forVersion() {
        return new VersionExpressionBuilder();
    }

    public final ValidationRuleBuilder forAllVersions() {
        return this.forVersion().all();
    }

    public class VersionExpressionBuilder {
        public ValidationRuleBuilder all() {
            return new ValidationRuleBuilder(ValidationRuleBuilder.this.getRules(), Version.values());
        }

        public ValidationRuleBuilder asOf(String version) {
            return this.asOf(Version.versionOf(version));
        }

        public ValidationRuleBuilder asOf(Version version) {
            return new ValidationRuleBuilder(ValidationRuleBuilder.this.getRules(), Version.asOf(version));
        }

        public ValidationRuleBuilder before(String version) {
            return this.before(Version.versionOf(version));
        }

        public ValidationRuleBuilder before(Version version) {
            return new ValidationRuleBuilder(ValidationRuleBuilder.this.getRules(), Version.before(version));
        }

        public ValidationRuleBuilder except(String ... versions) {
            Version[] v = new Version[versions.length];
            for (int i = 0; i < versions.length; ++i) {
                v[i] = Version.versionOf(versions[i]);
            }
            return this.except(v);
        }

        public ValidationRuleBuilder except(Version ... versions) {
            return new ValidationRuleBuilder(ValidationRuleBuilder.this.getRules(), Version.except(versions));
        }
    }
}

