/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.validation.AbstractValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CollectingValidationExceptionHandler<R>
extends AbstractValidationExceptionHandler<R> {
    private List<ValidationException> exceptions = new ArrayList<ValidationException>();
    private Severity minimumSeverityToCollect = Severity.ERROR;

    public CollectingValidationExceptionHandler(HapiContext context) {
        super(context);
    }

    @Override
    public void error(ValidationException exception) {
        if (this.isSeverityAtLeast(Severity.ERROR)) {
            this.exceptions.add(exception);
        }
    }

    @Override
    public void info(ValidationException exception) {
        if (this.isSeverityAtLeast(Severity.INFO)) {
            this.exceptions.add(exception);
        }
    }

    @Override
    public void warning(ValidationException exception) {
        if (this.isSeverityAtLeast(Severity.WARNING)) {
            this.exceptions.add(exception);
        }
    }

    private boolean isSeverityAtLeast(Severity s) {
        return s.compareTo(this.getMinimumSeverityToCollect()) >= 0;
    }

    public List<ValidationException> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void setMinimumSeverityToCollect(Severity minimumSeverityToCollect) {
        this.minimumSeverityToCollect = minimumSeverityToCollect;
    }

    public Severity getMinimumSeverityToCollect() {
        return this.minimumSeverityToCollect;
    }

    @Override
    public boolean hasFailed() {
        for (ValidationException ve : this.exceptions) {
            if (ve.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }
}

